/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.driver.pipeline.DefaultSingleTablePipeline;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuniperQfx5100Pipeliner
extends DefaultSingleTablePipeline
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int DEFAULT_TABLE = 1;
    private ServiceDirectory serviceDirectory;
    private DeviceId deviceId;
    private FlowRuleService flowRuleService;
    protected DeviceService deviceService;

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        super.init(deviceId, context);
        this.deviceId = deviceId;
        this.serviceDirectory = context.directory();
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
    }

    @Override
    public void filter(FilteringObjective filterObjective) {
        this.log.debug("No action is needed here");
    }

    @Override
    public void forward(final ForwardingObjective forwardObjective) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        ForwardingObjective newFwd = forwardObjective;
        Device device = this.deviceService.getDevice(this.deviceId);
        if (forwardObjective.treatment() != null && forwardObjective.treatment().clearedDeferred()) {
            this.log.warn("Using 'clear actions' instruction which is not supported by {}  {} {} Switch", new Object[]{device.id(), device.manufacturer(), device.hwVersion()});
            newFwd = this.forwardingObjectiveWithoutCleardDef(forwardObjective).orElse(forwardObjective);
        }
        FlowRule rule = this.processForward(newFwd);
        switch (forwardObjective.op()) {
            case ADD: {
                flowOpsBuilder.add(rule);
                break;
            }
            case REMOVE: {
                flowOpsBuilder.remove(rule);
                break;
            }
            default: {
                this.fail((Objective)forwardObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)forwardObjective.op());
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                JuniperQfx5100Pipeliner.this.pass((Objective)forwardObjective);
            }

            public void onError(FlowRuleOperations ops) {
                JuniperQfx5100Pipeliner.this.fail((Objective)forwardObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Optional<ForwardingObjective> forwardingObjectiveWithoutCleardDef(ForwardingObjective forwardingObjective) {
        TrafficTreatment treatment = this.trafficTreatmentWithoutCleardDeffered(forwardingObjective.treatment());
        DefaultForwardingObjective.Builder foBuilder = (DefaultForwardingObjective.Builder)forwardingObjective.copy();
        foBuilder.withTreatment(treatment);
        switch (forwardingObjective.op()) {
            case ADD: {
                return Optional.of(foBuilder.add((ObjectiveContext)forwardingObjective.context().orElse(null)));
            }
            case REMOVE: {
                return Optional.of(foBuilder.remove((ObjectiveContext)forwardingObjective.context().orElse(null)));
            }
        }
        this.log.warn("Driver Not support other operations for forwarding objective");
        return Optional.empty();
    }

    private TrafficTreatment trafficTreatmentWithoutCleardDeffered(TrafficTreatment treatment) {
        return DefaultTrafficTreatment.builder((TrafficTreatment)treatment).notWipeDeferred().build();
    }

    private FlowRule processForward(ForwardingObjective fwd) {
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(fwd.selector()).withTreatment(fwd.treatment()).withPriority(fwd.priority()).fromApp(fwd.appId()).forTable(1);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        return ruleBuilder.build();
    }

    @Override
    public void next(NextObjective nextObjective) {
        this.log.debug("no action is needed here");
    }

    @Override
    public List<String> getNextMappings(NextGroup nextGroup) {
        return ImmutableList.of();
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }
}

