/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfdpaGroupHandlerUtility {
    static final int L2_INTERFACE_TYPE = 0;
    static final int L2_UNFILTERED_TYPE = -1342177280;
    static final int L3_INTERFACE_TYPE = 0x50000000;
    static final int L3_UNICAST_TYPE = 0x20000000;
    static final int L3_MULTICAST_TYPE = 0x60000000;
    static final int MPLS_INTERFACE_TYPE = -1879048192;
    static final int MPLS_L3VPN_SUBTYPE = -1845493760;
    static final int L3_ECMP_TYPE = 0x70000000;
    static final int L2_FLOOD_TYPE = 0x40000000;
    static final int L2_MULTICAST_TYPE = 0x30000000;
    static final int L2_LB_TYPE = -1073741824;
    static final int TYPE_MASK = 0xFFFFFFF;
    static final int SUBTYPE_MASK = 0xFFFFFF;
    static final int TYPE_VLAN_MASK = 65535;
    static final int TYPE_L3UG_DOUBLE_VLAN_MASK = 0x8000000;
    static final int THREE_NIBBLE_MASK = 4095;
    static final int FOUR_NIBBLE_MASK = 65535;
    static final int PORT_LEN = 16;
    static final int PORT_LOWER_BITS_MASK = 63;
    static final long PORT_HIGHER_BITS_MASK = -64L;
    static final String HEX_PREFIX = "0x";
    private static final Logger log = LoggerFactory.getLogger(OfdpaGroupHandlerUtility.class);

    private OfdpaGroupHandlerUtility() {
    }

    static PortNumber readOutPortFromTreatment(TrafficTreatment tt) {
        for (Instruction ins : tt.allInstructions()) {
            if (ins.type() != Instruction.Type.OUTPUT) continue;
            return ((Instructions.OutputInstruction)ins).port();
        }
        return null;
    }

    static int readLabelFromTreatment(TrafficTreatment tt) {
        for (Instruction ins : tt.allInstructions()) {
            L2ModificationInstruction insl2;
            if (ins.type() != Instruction.Type.L2MODIFICATION || (insl2 = (L2ModificationInstruction)ins).subtype() != L2ModificationInstruction.L2SubType.MPLS_LABEL) continue;
            return (Integer)((L2ModificationInstruction.ModMplsLabelInstruction)insl2).label().id();
        }
        return -1;
    }

    public static Integer makeMplsLabelGroupId(OfdpaMplsGroupSubType subType, int index) {
        return (index &= 0xFFFFFF) | 0x90000000 | subType.value << 24;
    }

    public static Integer makeMplsForwardingGroupId(OfdpaMplsGroupSubType subType, int index) {
        return (index &= 0xFFFFFF) | 0xA0000000 | subType.value << 24;
    }

    public static Set<PortNumber> getExistingOutputPorts(List<Deque<GroupKey>> allActiveKeys, GroupService groupService, DeviceId deviceId) {
        HashSet existingPorts = Sets.newHashSet();
        allActiveKeys.forEach(keyChain -> {
            GroupKey ifaceGroupKey = (GroupKey)keyChain.peekLast();
            Group ifaceGroup = groupService.getGroup(deviceId, ifaceGroupKey);
            if (ifaceGroup != null && !ifaceGroup.buckets().buckets().isEmpty()) {
                ifaceGroup.buckets().buckets().forEach(bucket -> {
                    PortNumber portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(bucket.treatment());
                    if (portNumber != null) {
                        existingPorts.add(portNumber);
                    }
                });
            }
        });
        return existingPorts;
    }

    public static List<Integer> existingPortAndLabel(List<Deque<GroupKey>> allActiveKeys, GroupService groupService, DeviceId deviceId, PortNumber portToMatch, int labelToMatch) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int index = 0;
        for (Deque<GroupKey> keyChain : allActiveKeys) {
            int label;
            GroupKey secondKey;
            Group secondGroup;
            PortNumber portNumber;
            GroupKey ifaceGroupKey = keyChain.peekLast();
            Group ifaceGroup = groupService.getGroup(deviceId, ifaceGroupKey);
            if (ifaceGroup != null && !ifaceGroup.buckets().buckets().isEmpty() && (portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(((GroupBucket)ifaceGroup.buckets().buckets().iterator().next()).treatment())) != null && portNumber.equals((Object)portToMatch) && (secondGroup = groupService.getGroup(deviceId, secondKey = (GroupKey)keyChain.toArray()[1])) != null && !secondGroup.buckets().buckets().isEmpty() && (label = OfdpaGroupHandlerUtility.readLabelFromTreatment(((GroupBucket)secondGroup.buckets().buckets().iterator().next()).treatment())) == labelToMatch) {
                indices.add(index);
            }
            ++index;
        }
        return indices;
    }

    public static List<Integer> indicesToRemoveFromNextGroup(List<Deque<GroupKey>> allActiveKeys, NextObjective nextObjective, GroupService groupService, DeviceId deviceId) {
        ArrayList indicesToRemove = Lists.newArrayList();
        int index = 0;
        for (Deque<GroupKey> keyChain : allActiveKeys) {
            GroupKey secondKey;
            Group secondGroup;
            PortNumber portNumber;
            GroupKey ifaceGroupKey;
            Group ifaceGroup;
            if (keyChain.size() >= 2 && (ifaceGroup = groupService.getGroup(deviceId, ifaceGroupKey = keyChain.peekLast())) != null && !ifaceGroup.buckets().buckets().isEmpty() && (portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(((GroupBucket)ifaceGroup.buckets().buckets().iterator().next()).treatment())) != null && (secondGroup = groupService.getGroup(deviceId, secondKey = (GroupKey)keyChain.toArray()[1])) != null && !secondGroup.buckets().buckets().isEmpty()) {
                int label = OfdpaGroupHandlerUtility.readLabelFromTreatment(((GroupBucket)secondGroup.buckets().buckets().iterator().next()).treatment());
                boolean matches = false;
                for (TrafficTreatment t : nextObjective.next()) {
                    PortNumber tPort = OfdpaGroupHandlerUtility.readOutPortFromTreatment(t);
                    int tLabel = OfdpaGroupHandlerUtility.readLabelFromTreatment(t);
                    if (tPort == null || !tPort.equals((Object)portNumber) || tLabel != label) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    indicesToRemove.add(index);
                }
            }
            ++index;
        }
        return indicesToRemove;
    }

    public static boolean verifyHashedNextObjective(NextObjective nextObjective) {
        if (nextObjective.type() != NextObjective.Type.HASHED) {
            return false;
        }
        TrafficSelector metaSelector = nextObjective.meta();
        return metaSelector == null || !Ofdpa2Pipeline.isNotMplsBos(metaSelector);
    }

    static boolean isL2Hash(NextObjective nextObj) {
        return nextObj.next().stream().flatMap(t -> t.allInstructions().stream()).allMatch(i -> i.type() == Instruction.Type.OUTPUT);
    }

    static List<GroupBucket> generateNextGroupBuckets(List<GroupInfo> groupInfos, GroupDescription.Type bucketType) {
        ArrayList newBuckets = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription groupDesc = groupInfo.nextGroupDesc();
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            treatmentBuilder.group(new GroupId(groupDesc.givenGroupId().intValue()));
            GroupBucket newBucket = null;
            switch (bucketType) {
                case ALL: {
                    newBucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                case INDIRECT: {
                    newBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                case SELECT: {
                    newBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)treatmentBuilder.build());
                    break;
                }
                default: {
                    log.warn("Unknown bucket type: {}", (Object)bucketType);
                }
            }
            if (newBucket != null) {
                newBuckets.add(newBucket);
            }
        });
        return ImmutableList.copyOf((Collection)newBuckets);
    }

    static List<GroupBucket> createL3MulticastBucket(List<GroupInfo> groupInfos) {
        ArrayList<GroupBucket> l3McastBuckets = new ArrayList<GroupBucket>();
        groupInfos.forEach(groupInfo -> {
            GroupDescription nextGroupDesc = groupInfo.nextGroupDesc() != null ? groupInfo.nextGroupDesc() : groupInfo.innerMostGroupDesc();
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group(new GroupId(nextGroupDesc.givenGroupId().intValue()));
            GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
            l3McastBuckets.add(abucket);
        });
        return l3McastBuckets;
    }

    static Group retrieveTopLevelGroup(List<Deque<GroupKey>> allActiveKeys, DeviceId deviceId, GroupService groupService, int nextid) {
        if (allActiveKeys.isEmpty()) {
            log.warn("Could not determine top level group while processingnext:{} in dev:{}", (Object)nextid, (Object)deviceId);
            return null;
        }
        GroupKey topLevelGroupKey = allActiveKeys.get(0).peekFirst();
        Group topGroup = groupService.getGroup(deviceId, topLevelGroupKey);
        if (topGroup == null) {
            log.warn("Could not find top level group while processing next:{} in dev:{}", (Object)nextid, (Object)deviceId);
        }
        return topGroup;
    }

    public static VlanId extractVlanIdFromGroupId(int groupId) {
        short vlanId = (short)((groupId & 0xFFF0000) >> 16);
        return VlanId.vlanId((short)vlanId);
    }

    public static GroupKey l2FloodGroupKey(VlanId vlanId, DeviceId deviceId) {
        int hash = Objects.hash(deviceId, vlanId);
        hash = 0x40000000 | 0xFFFFFFF & hash;
        return new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)hash));
    }

    public static GroupKey l2MulticastGroupKey(VlanId vlanId, DeviceId deviceId) {
        int hash = Objects.hash(deviceId, vlanId);
        hash = 0x30000000 | 0xFFFFFFF & hash;
        return new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)hash));
    }

    public static int l2GroupId(VlanId vlanId, long portNum) {
        return 0 | vlanId.toShort() << 16 | (int)portNum;
    }

    public static int l2UnfilteredGroupId(long portNum) {
        return 0xB0000000 | (int)portNum;
    }

    public static int l2InterfaceGroupKey(DeviceId deviceId, VlanId vlanId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, vlanId, portHigherBits);
        return 0 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    public static int l2UnfilteredGroupKey(DeviceId deviceId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, portHigherBits);
        return 0xB0000000 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    public static int l2HashGroupKey(DeviceId deviceId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, portHigherBits);
        return 0xC0000000 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    public static boolean createUnfiltered(TrafficTreatment treatment, TrafficSelector meta) {
        if (meta == null || treatment == null) {
            return false;
        }
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)meta.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null || !vlanIdCriterion.vlanId().equals((Object)VlanId.ANY)) {
            return false;
        }
        return treatment.allInstructions().stream().filter(i -> i.type() == Instruction.Type.L2MODIFICATION && ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_ID).count() == 1L;
    }

    public static int doubleVlanL3UnicastGroupKey(DeviceId deviceId, VlanId vlanId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, portHigherBits, vlanId);
        return 0x20000000 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    public static int doubleVlanL3UnicastGroupId(VlanId vlanId, long portNum) {
        return 0x28000000 | vlanId.toShort() << 15 | (int)(portNum & 0x7FFFL);
    }

    public static class GroupChecker
    implements Runnable {
        final Logger log = LoggerFactory.getLogger(this.getClass());
        private Ofdpa2GroupHandler groupHandler;

        public GroupChecker(Ofdpa2GroupHandler groupHandler) {
            this.groupHandler = groupHandler;
        }

        @Override
        public void run() {
            try {
                if (this.groupHandler.pendingGroups.size() != 0L) {
                    this.log.debug("pending groups being checked: {}", this.groupHandler.pendingGroups.asMap().keySet());
                }
                if (this.groupHandler.pendingAddNextObjectives.size() != 0L) {
                    this.log.debug("pending add-next-obj being checked: {}", this.groupHandler.pendingAddNextObjectives.asMap().keySet());
                }
                if (this.groupHandler.pendingRemoveNextObjectives.size() != 0L) {
                    this.log.debug("pending remove-next-obj being checked: {}", this.groupHandler.pendingRemoveNextObjectives.asMap().values());
                }
                if (this.groupHandler.pendingUpdateNextObjectives.size() != 0) {
                    this.log.debug("pending update-next-obj being checked: {}", (Object)this.groupHandler.pendingUpdateNextObjectives.keySet());
                }
                Set<GroupKey> keys = this.groupHandler.pendingGroups.asMap().keySet().stream().filter(key -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, key) != null).collect(Collectors.toSet());
                Set otherkeys = this.groupHandler.pendingAddNextObjectives.asMap().keySet().stream().filter(otherkey -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, otherkey) != null).collect(Collectors.toSet());
                keys.addAll(otherkeys);
                keys.forEach(key -> this.groupHandler.processPendingAddGroupsOrNextObjs((GroupKey)key, false));
                keys = this.groupHandler.pendingUpdateNextObjectives.keySet().stream().filter(key -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, key) != null).collect(Collectors.toSet());
                keys.forEach(key -> this.groupHandler.processPendingUpdateNextObjs((GroupKey)key));
                HashSet k = Sets.newHashSet();
                this.groupHandler.pendingRemoveNextObjectives.asMap().values().forEach(keylist -> keylist.stream().filter(key -> this.groupHandler.groupService.getGroup(this.groupHandler.deviceId, key) == null).forEach(k::add));
                k.forEach(key -> this.groupHandler.processPendingRemoveNextObjs((GroupKey)key));
            }
            catch (Exception exception) {
                this.log.warn("Uncaught exception is detected: {}", (Object)exception.getMessage());
                this.log.debug("Uncaught exception is detected (full stack trace): ", (Throwable)exception);
            }
        }
    }

    public static class GroupChainElem {
        private GroupDescription groupDescription;
        private AtomicInteger waitOnGroups;
        private boolean addBucketToGroup;
        private DeviceId deviceId;

        public GroupChainElem(GroupDescription groupDescription, int waitOnGroups, boolean addBucketToGroup, DeviceId deviceId) {
            this.groupDescription = groupDescription;
            this.waitOnGroups = new AtomicInteger(waitOnGroups);
            this.addBucketToGroup = addBucketToGroup;
            this.deviceId = deviceId;
        }

        int decrementAndGetGroupsWaitedOn() {
            return this.waitOnGroups.decrementAndGet();
        }

        public GroupDescription groupDescription() {
            return this.groupDescription;
        }

        public boolean addBucketToGroup() {
            return this.addBucketToGroup;
        }

        public String toString() {
            return Integer.toHexString(this.groupDescription.givenGroupId()) + " groupKey: " + this.groupDescription.appCookie() + " waiting-on-groups: " + this.waitOnGroups.get() + " addBucketToGroup: " + this.addBucketToGroup + " device: " + this.deviceId;
        }
    }

    public static class OfdpaNextGroup
    implements NextGroup {
        private final NextObjective nextObj;
        private final List<Deque<GroupKey>> gkeys;

        public OfdpaNextGroup(List<Deque<GroupKey>> gkeys, NextObjective nextObj) {
            this.nextObj = nextObj;
            this.gkeys = gkeys;
        }

        public NextObjective nextObjective() {
            return this.nextObj;
        }

        public List<Deque<GroupKey>> allKeys() {
            return this.gkeys;
        }

        public byte[] data() {
            return Ofdpa2Pipeline.appKryo.serialize(this.gkeys);
        }
    }

    public static class GroupInfo {
        private GroupDescription innerMostGroupDesc;
        private GroupDescription nextGroupDesc;

        GroupInfo(GroupDescription innerMostGroupDesc, GroupDescription nextGroupDesc) {
            this.innerMostGroupDesc = innerMostGroupDesc;
            this.nextGroupDesc = nextGroupDesc;
        }

        public GroupDescription innerMostGroupDesc() {
            return this.innerMostGroupDesc;
        }

        public GroupDescription nextGroupDesc() {
            return this.nextGroupDesc;
        }

        public void nextGroupDesc(GroupDescription nextGroupDesc) {
            this.nextGroupDesc = nextGroupDesc;
        }
    }

    public static enum OfdpaMplsGroupSubType {
        MPLS_INTF(0),
        L2_VPN(1),
        L3_VPN(2),
        MPLS_TUNNEL_LABEL_1(3),
        MPLS_TUNNEL_LABEL_2(4),
        MPLS_SWAP_LABEL(5),
        MPLS_ECMP(8);

        private short value;
        public static final int OFDPA_GROUP_TYPE_SHIFT = 28;
        public static final int OFDPA_MPLS_SUBTYPE_SHIFT = 24;

        private OfdpaMplsGroupSubType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }
}

