/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleTablePipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private FlowObjectiveStore flowObjectiveStore;
    private DeviceId deviceId;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{SingleGroup.class}).build("DefaultSingleTablePipeline");
    private Cache<Integer, NextObjective> pendingAddNext = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
        if (notification.getCause() == RemovalCause.EXPIRED) {
            ((NextObjective)notification.getValue()).context().ifPresent(c -> c.onError((Objective)notification.getValue(), ObjectiveError.FLOWINSTALLATIONFAILED));
        }
    }).build();

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = (FlowObjectiveStore)this.serviceDirectory.get(FlowObjectiveStore.class);
    }

    public void filter(FilteringObjective filter) {
        TrafficTreatment.Builder actions;
        switch (filter.type()) {
            case PERMIT: {
                actions = filter.meta() == null ? DefaultTrafficTreatment.builder().punt() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                break;
            }
            case DENY: {
                actions = filter.meta() == null ? DefaultTrafficTreatment.builder() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                actions.drop();
                break;
            }
            default: {
                this.log.warn("Unknown filter type: {}", (Object)filter.type());
                actions = DefaultTrafficTreatment.builder().drop();
            }
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        filter.conditions().forEach(arg_0 -> ((TrafficSelector.Builder)selector).add(arg_0));
        if (filter.key() != null) {
            selector.add(filter.key());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(actions.build()).fromApp(filter.appId()).withPriority(filter.priority());
        if (filter.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(filter.timeout());
        }
        this.installObjective(ruleBuilder, (Objective)filter);
    }

    public void forward(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        if (fwd.treatment() != null) {
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(fwd.treatment());
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)fwd);
        } else {
            TrafficTreatment treatment;
            if (fwd.op() == Objective.Operation.ADD) {
                NextObjective nextObjective = (NextObjective)this.pendingAddNext.getIfPresent((Object)fwd.nextId());
                if (nextObjective == null) {
                    NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
                    if (next == null) {
                        fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                        return;
                    }
                    treatment = (TrafficTreatment)this.appKryo.deserialize(next.data());
                } else {
                    this.pendingAddNext.invalidate((Object)fwd.nextId());
                    treatment = this.getTreatment(nextObjective);
                    if (treatment == null) {
                        fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.UNSUPPORTED));
                        return;
                    }
                }
            } else {
                NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
                TrafficTreatment trafficTreatment = treatment = next != null ? (TrafficTreatment)this.appKryo.deserialize(next.data()) : null;
            }
            if (treatment == null) {
                fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                return;
            }
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(treatment);
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)fwd);
        }
    }

    private void installObjective(FlowRule.Builder ruleBuilder, final Objective objective) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        switch (objective.op()) {
            case ADD: {
                flowBuilder.add(ruleBuilder.build());
                break;
            }
            case REMOVE: {
                flowBuilder.remove(ruleBuilder.build());
                break;
            }
            default: {
                this.log.warn("Unknown operation {}", (Object)objective.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onSuccess(objective));
            }

            public void onError(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onError(objective, ObjectiveError.FLOWINSTALLATIONFAILED));
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        switch (nextObjective.op()) {
            case ADD: {
                TrafficTreatment treatment = this.getTreatment(nextObjective);
                if (treatment == null) {
                    nextObjective.context().ifPresent(context -> context.onError((Objective)nextObjective, ObjectiveError.UNSUPPORTED));
                    return;
                }
                this.pendingAddNext.put((Object)nextObjective.id(), (Object)nextObjective);
                this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SingleGroup(treatment));
                break;
            }
            case REMOVE: {
                NextGroup next = this.flowObjectiveStore.removeNextGroup(Integer.valueOf(nextObjective.id()));
                if (next != null) break;
                nextObjective.context().ifPresent(context -> context.onError((Objective)nextObjective, ObjectiveError.GROUPMISSING));
                return;
            }
            default: {
                this.log.warn("Unsupported operation {}", (Object)nextObjective.op());
            }
        }
        nextObjective.context().ifPresent(context -> context.onSuccess((Objective)nextObjective));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return Collections.emptyList();
    }

    private TrafficTreatment getTreatment(NextObjective nextObjective) {
        Collection treatments = nextObjective.next();
        switch (nextObjective.type()) {
            case SIMPLE: {
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type SIMPLE should have only one traffic treatment. NexObjective: {}", (Object)nextObjective.toString());
                    return null;
                }
                return (TrafficTreatment)treatments.iterator().next();
            }
            case BROADCAST: {
                TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
                treatments.forEach(arg_0 -> ((TrafficTreatment.Builder)builder).addTreatment(arg_0));
                return builder.build();
            }
        }
        this.log.error("Unsupported next objective type {}.", (Object)nextObjective.type());
        return null;
    }

    private class SingleGroup
    implements NextGroup {
        private TrafficTreatment nextActions;

        SingleGroup(TrafficTreatment next) {
            this.nextActions = next;
        }

        public byte[] data() {
            return DefaultSingleTablePipeline.this.appKryo.serialize((Object)this.nextActions);
        }

        public TrafficTreatment treatment() {
            return this.nextActions;
        }
    }
}

