/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OltPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private static final Integer QQ_TABLE = 1;
    private static final int NO_ACTION_PRIORITY = 500;
    private static final String DOWNSTREAM = "downstream";
    private static final String UPSTREAM = "upstream";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private GroupService groupService;
    private CoreService coreService;
    private StorageService storageService;
    private DeviceId deviceId;
    private ApplicationId appId;
    protected FlowObjectiveStore flowObjectiveStore;
    private Cache<GroupKey, NextObjective> pendingGroups;
    protected static KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{OLTPipelineGroup.class}).build("OltPipeline");

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.log.debug("Initiate OLT pipeline");
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.storageService = (StorageService)this.serviceDirectory.get(StorageService.class);
        this.appId = this.coreService.registerApplication("org.onosproject.driver.OLTPipeline");
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.fail((Objective)notification.getValue(), ObjectiveError.GROUPINSTALLATIONFAILED);
            }
        }).build();
        this.groupService.addListener((EventListener)new InnerGroupListener());
    }

    public void filter(FilteringObjective filter) {
        Instructions.OutputInstruction output;
        if (filter.meta() != null && !filter.meta().immediate().isEmpty()) {
            output = (Instructions.OutputInstruction)filter.meta().immediate().stream().filter((? super T t) -> t.type().equals((Object)Instruction.Type.OUTPUT)).limit(1L).findFirst().get();
            if (output == null || !output.port().equals((Object)PortNumber.CONTROLLER)) {
                this.log.warn("OLT can only filter packet to controller");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                return;
            }
        } else {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        if (filter.key().type() != Criterion.Type.IN_PORT) {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        EthTypeCriterion ethType = (EthTypeCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        if (ethType.ethType().equals((Object)EthType.EtherType.EAPOL.ethType())) {
            this.provisionEthTypeBasedFilter(filter, ethType, output);
        } else if (ethType.ethType().equals((Object)EthType.EtherType.LLDP.ethType())) {
            this.provisionEthTypeBasedFilter(filter, ethType, output);
        } else if (ethType.ethType().equals((Object)EthType.EtherType.IPV4.ethType())) {
            IPProtocolCriterion ipProto = (IPProtocolCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.IP_PROTO);
            if (ipProto == null) {
                this.log.warn("OLT can only filter IGMP and DHCP");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                return;
            }
            if (ipProto.protocol() == 2) {
                this.provisionIgmp(filter, ethType, ipProto, output);
            } else if (ipProto.protocol() == 17) {
                UdpPortCriterion udpSrcPort = (UdpPortCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.UDP_SRC);
                UdpPortCriterion udpDstPort = (UdpPortCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.UDP_DST);
                if (udpSrcPort.udpPort().toInt() == 67 && udpDstPort.udpPort().toInt() == 68 || udpSrcPort.udpPort().toInt() == 68 && udpDstPort.udpPort().toInt() == 67) {
                    this.provisionDhcp(filter, ethType, ipProto, udpSrcPort, udpDstPort, output);
                } else {
                    this.log.warn("Filtering rule with unsupported UDP src {} or dst {} port", (Object)udpSrcPort, (Object)udpDstPort);
                    this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                }
            } else {
                this.log.warn("Currently supporting only IGMP and DHCP filters for IPv4 packets");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
            }
        } else if (ethType.ethType().equals((Object)EthType.EtherType.IPV6.ethType())) {
            IPProtocolCriterion ipProto = (IPProtocolCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.IP_PROTO);
            if (ipProto == null) {
                this.log.warn("OLT can only filter DHCP");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                return;
            }
            if (ipProto.protocol() == 17) {
                UdpPortCriterion udpSrcPort = (UdpPortCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.UDP_SRC);
                UdpPortCriterion udpDstPort = (UdpPortCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.UDP_DST);
                if (udpSrcPort.udpPort().toInt() == 546 && udpDstPort.udpPort().toInt() == 547 || udpSrcPort.udpPort().toInt() == 547 && udpDstPort.udpPort().toInt() == 546) {
                    this.provisionDhcp(filter, ethType, ipProto, udpSrcPort, udpDstPort, output);
                } else {
                    this.log.warn("Filtering rule with unsupported UDP src {} or dst {} port", (Object)udpSrcPort, (Object)udpDstPort);
                    this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                }
            } else {
                this.log.warn("Currently supporting only DHCP filters for IPv6 packets");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
            }
        } else {
            this.log.warn("\nOnly the following are Supported in OLT for filter ->\nETH TYPE : EAPOL, LLDP and IPV4\nIPV4 TYPE: IGMP and UDP (for DHCP)IPV6 TYPE: UDP (for DHCP)");
            this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(ForwardingObjective fwd) {
        if (this.checkForMulticast(fwd)) {
            this.processMulticastRule(fwd);
            return;
        }
        TrafficTreatment treatment = fwd.treatment();
        List instructions = treatment.allInstructions();
        Optional<Instruction> vlanInstruction = instructions.stream().filter((? super T i) -> i.type() == Instruction.Type.L2MODIFICATION).filter((? super T i) -> ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH || ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_POP).findAny();
        if (!vlanInstruction.isPresent()) {
            this.installNoModificationRules(fwd);
        } else {
            L2ModificationInstruction vlanIns = (L2ModificationInstruction)vlanInstruction.get();
            if (vlanIns.subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH) {
                this.installUpstreamRules(fwd);
            } else if (vlanIns.subtype() == L2ModificationInstruction.L2SubType.VLAN_POP) {
                this.installDownstreamRules(fwd);
            } else {
                this.log.error("Unknown OLT operation: {}", (Object)fwd);
                this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
                return;
            }
        }
        this.pass((Objective)fwd);
    }

    public void next(NextObjective nextObjective) {
        if (nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.error("OLT only supports broadcast groups.");
            this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
        }
        if (nextObjective.next().size() != 1) {
            this.log.error("OLT only supports singleton broadcast groups.");
            this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
        }
        TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().stream().findFirst().get();
        GroupBucket bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatment);
        DefaultGroupKey key = new DefaultGroupKey(appKryo.serialize((Object)nextObjective.id()));
        this.pendingGroups.put((Object)key, (Object)nextObjective);
        switch (nextObjective.op()) {
            case ADD: {
                DefaultGroupDescription groupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, null, nextObjective.appId());
                this.groupService.addGroup((GroupDescription)groupDesc);
                break;
            }
            case REMOVE: {
                this.groupService.removeGroup(this.deviceId, (GroupKey)key, nextObjective.appId());
                break;
            }
            case ADD_TO_EXISTING: {
                this.groupService.addBucketsToGroup(this.deviceId, (GroupKey)key, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, nextObjective.appId());
                break;
            }
            case REMOVE_FROM_EXISTING: {
                this.groupService.removeBucketsFromGroup(this.deviceId, (GroupKey)key, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, nextObjective.appId());
                break;
            }
            default: {
                this.log.warn("Unknown next objective operation: {}", (Object)nextObjective.op());
            }
        }
    }

    private void processMulticastRule(ForwardingObjective fwd) {
        GroupKey key;
        if (fwd.nextId() == null) {
            this.log.error("Multicast objective does not have a next id");
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
        }
        if ((key = this.getGroupForNextObjective(fwd.nextId())) == null) {
            this.log.error("Group for forwarding objective missing: {}", (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
        }
        Group group = this.groupService.getGroup(this.deviceId, key);
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{Instructions.createGroup((GroupId)group.id())});
        FlowRule rule = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(0).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(treatment).build();
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        switch (fwd.op()) {
            case ADD: {
                builder.add(rule);
                break;
            }
            case REMOVE: {
                builder.remove(rule);
                break;
            }
            case ADD_TO_EXISTING: 
            case REMOVE_FROM_EXISTING: {
                break;
            }
            default: {
                this.log.warn("Unknown forwarding operation: {}", (Object)fwd.op());
            }
        }
        this.applyFlowRules(builder, (Objective)fwd);
    }

    private boolean checkForMulticast(ForwardingObjective fwd) {
        IPCriterion ip = (IPCriterion)this.filterForCriterion(fwd.selector().criteria(), Criterion.Type.IPV4_DST);
        if (ip == null) {
            return false;
        }
        return ip.ip().isMulticast();
    }

    private GroupKey getGroupForNextObjective(Integer nextId) {
        NextGroup next = this.flowObjectiveStore.getNextGroup(nextId);
        return (GroupKey)appKryo.deserialize(next.data());
    }

    private void installNoModificationRules(ForwardingObjective fwd) {
        Instructions.OutputInstruction output = (Instructions.OutputInstruction)this.fetchOutput(fwd, DOWNSTREAM);
        Instructions.MetadataInstruction writeMetadata = this.fetchWriteMetadata(fwd);
        Instructions.MeterInstruction meter = (Instructions.MeterInstruction)this.fetchMeter(fwd);
        TrafficSelector selector = fwd.selector();
        Criterion inport = selector.getCriterion(Criterion.Type.IN_PORT);
        Criterion outerVlan = selector.getCriterion(Criterion.Type.VLAN_VID);
        Criterion innerVlan = selector.getCriterion(Criterion.Type.INNER_VLAN_VID);
        if (inport == null || output == null || innerVlan == null || outerVlan == null) {
            this.log.error("Forwarding objective is underspecified: {}", (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return;
        }
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(this.buildSelector(inport, outerVlan)).withTreatment(this.buildTreatment(new Instruction[]{output, writeMetadata, meter}));
        this.applyRules(fwd, outer);
    }

    private void installDownstreamRules(ForwardingObjective fwd) {
        Instructions.OutputInstruction output = (Instructions.OutputInstruction)this.fetchOutput(fwd, DOWNSTREAM);
        if (output == null) {
            return;
        }
        TrafficSelector selector = fwd.selector();
        Criterion outerVlan = selector.getCriterion(Criterion.Type.VLAN_VID);
        Criterion innerVlanCriterion = selector.getCriterion(Criterion.Type.INNER_VLAN_VID);
        Criterion inport = selector.getCriterion(Criterion.Type.IN_PORT);
        if (outerVlan == null || innerVlanCriterion == null || inport == null) {
            this.log.error("Forwarding objective is underspecified: {}", (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return;
        }
        VlanId innerVlan = ((VlanIdCriterion)innerVlanCriterion).vlanId();
        Criterion innerVid = Criteria.matchVlanId((VlanId)innerVlan);
        Criterion metadata = Criteria.matchMetadata((long)innerVlan.toShort());
        TrafficSelector outerSelector = this.buildSelector(inport, metadata, outerVlan);
        if (innerVlan.toShort() == 4096) {
            this.installDownstreamRulesForAnyVlan(fwd, (Instruction)output, outerSelector, this.buildSelector(inport, Criteria.matchVlanId((VlanId)VlanId.ANY)));
        } else {
            this.installDownstreamRulesForVlans(fwd, (Instruction)output, outerSelector, this.buildSelector(inport, innerVid));
        }
    }

    private void installDownstreamRulesForVlans(ForwardingObjective fwd, Instruction output, TrafficSelector outerSelector, TrafficSelector innerSelector) {
        List<Pair<Instruction, Instruction>> vlanOps = this.vlanOps(fwd, L2ModificationInstruction.L2SubType.VLAN_POP);
        if (vlanOps == null || vlanOps.isEmpty()) {
            return;
        }
        Pair<Instruction, Instruction> popAndRewrite = vlanOps.remove(0);
        VlanId setVlanId = ((L2ModificationInstruction.ModVlanIdInstruction)popAndRewrite.getRight()).vlanId();
        TrafficTreatment innerTreatment = VlanId.NONE.equals((Object)setVlanId) ? this.buildTreatment((Instruction)popAndRewrite.getLeft(), this.fetchMeter(fwd), this.writeMetadataIncludingOnlyTp(fwd), output) : this.buildTreatment((Instruction)popAndRewrite.getLeft(), (Instruction)popAndRewrite.getRight(), this.fetchMeter(fwd), this.writeMetadataIncludingOnlyTp(fwd), output);
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(outerSelector).withTreatment(this.buildTreatment(new Instruction[]{(Instruction)popAndRewrite.getLeft(), this.fetchMeter(fwd), this.fetchWriteMetadata(fwd), Instructions.transition((Integer)QQ_TABLE)}));
        FlowRule.Builder inner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(innerSelector).withTreatment(innerTreatment);
        this.applyRules(fwd, inner, outer);
    }

    private void installDownstreamRulesForAnyVlan(ForwardingObjective fwd, Instruction output, TrafficSelector outerSelector, TrafficSelector innerSelector) {
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(outerSelector).withTreatment(this.buildTreatment(new Instruction[]{Instructions.popVlan(), this.fetchMeter(fwd), this.fetchWriteMetadata(fwd), Instructions.transition((Integer)QQ_TABLE)}));
        FlowRule.Builder inner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(innerSelector).withTreatment(this.buildTreatment(this.fetchMeter(fwd), this.writeMetadataIncludingOnlyTp(fwd), output));
        this.applyRules(fwd, inner, outer);
    }

    private void installUpstreamRules(ForwardingObjective fwd) {
        List<Pair<Instruction, Instruction>> vlanOps = this.vlanOps(fwd, L2ModificationInstruction.L2SubType.VLAN_PUSH);
        if (vlanOps == null || vlanOps.isEmpty()) {
            return;
        }
        Instruction output = this.fetchOutput(fwd, UPSTREAM);
        if (output == null) {
            return;
        }
        Pair<Instruction, Instruction> innerPair = vlanOps.remove(0);
        Pair<Instruction, Instruction> outerPair = vlanOps.remove(0);
        boolean noneValueVlanStatus = this.checkNoneVlanCriteria(fwd);
        boolean anyValueVlanStatus = this.checkAnyVlanMatchCriteria(fwd);
        if (anyValueVlanStatus) {
            this.installUpstreamRulesForAnyVlan(fwd, output, outerPair);
        } else {
            this.installUpstreamRulesForVlans(fwd, output, innerPair, outerPair, noneValueVlanStatus);
        }
    }

    private void installUpstreamRulesForVlans(ForwardingObjective fwd, Instruction output, Pair<Instruction, Instruction> innerPair, Pair<Instruction, Instruction> outerPair, Boolean noneValueVlanStatus) {
        TrafficTreatment innerTreatment = noneValueVlanStatus != false ? this.buildTreatment(new Instruction[]{(Instruction)innerPair.getLeft(), (Instruction)innerPair.getRight(), this.fetchMeter(fwd), this.fetchWriteMetadata(fwd), Instructions.transition((Integer)QQ_TABLE)}) : this.buildTreatment(new Instruction[]{(Instruction)innerPair.getRight(), this.fetchMeter(fwd), this.fetchWriteMetadata(fwd), Instructions.transition((Integer)QQ_TABLE)});
        FlowRule.Builder inner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(innerTreatment);
        PortCriterion inPort = (PortCriterion)fwd.selector().getCriterion(Criterion.Type.IN_PORT);
        VlanId cVlanId = ((L2ModificationInstruction.ModVlanIdInstruction)innerPair.getRight()).vlanId();
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(this.buildSelector(new Criterion[]{inPort, Criteria.matchVlanId((VlanId)cVlanId)})).withTreatment(this.buildTreatment((Instruction)outerPair.getLeft(), (Instruction)outerPair.getRight(), this.fetchMeter(fwd), this.writeMetadataIncludingOnlyTp(fwd), output));
        this.applyRules(fwd, inner, outer);
    }

    private void installUpstreamRulesForAnyVlan(ForwardingObjective fwd, Instruction output, Pair<Instruction, Instruction> outerPair) {
        this.log.debug("Installing upstream rules for any value vlan");
        FlowRule.Builder inner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(this.buildTreatment(new Instruction[]{Instructions.transition((Integer)QQ_TABLE), this.fetchMeter(fwd), this.fetchWriteMetadata(fwd)}));
        TrafficSelector defaultSelector = DefaultTrafficSelector.builder().matchInPort(((PortCriterion)fwd.selector().getCriterion(Criterion.Type.IN_PORT)).port()).build();
        FlowRule.Builder defaultInner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(500).withSelector(defaultSelector).withTreatment(DefaultTrafficTreatment.emptyTreatment());
        Instruction qinqInstruction = Instructions.pushVlan((EthType)EthType.EtherType.QINQ.ethType());
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(this.buildTreatment(qinqInstruction, (Instruction)outerPair.getRight(), this.fetchMeter(fwd), this.writeMetadataIncludingOnlyTp(fwd), output));
        this.applyRules(fwd, inner, defaultInner, outer);
    }

    private boolean checkNoneVlanCriteria(ForwardingObjective fwd) {
        Criterion vlanMatchCriterion = this.filterForCriterion(fwd.selector().criteria(), Criterion.Type.VLAN_VID);
        boolean noneValueVlanStatus = false;
        if (vlanMatchCriterion != null) {
            noneValueVlanStatus = ((VlanIdCriterion)vlanMatchCriterion).vlanId().equals((Object)VlanId.NONE);
        }
        return noneValueVlanStatus;
    }

    private boolean checkAnyVlanMatchCriteria(ForwardingObjective fwd) {
        Criterion anyValueVlanCriterion = fwd.selector().criteria().stream().filter((? super T c) -> c.type().equals((Object)Criterion.Type.VLAN_VID)).filter((? super T vc) -> ((VlanIdCriterion)vc).vlanId().toShort() == 4096).findAny().orElse(null);
        if (anyValueVlanCriterion == null) {
            this.log.debug("Any value vlan match criteria is not found");
            return false;
        }
        return true;
    }

    private Instruction fetchOutput(ForwardingObjective fwd, String direction) {
        Instruction output = fwd.treatment().allInstructions().stream().filter((? super T i) -> i.type() == Instruction.Type.OUTPUT).findFirst().orElse(null);
        if (output == null) {
            this.log.error("OLT {} rule has no output", (Object)direction);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return null;
        }
        return output;
    }

    private Instruction fetchMeter(ForwardingObjective fwd) {
        Instructions.MeterInstruction meter = fwd.treatment().metered();
        if (meter == null) {
            this.log.debug("Meter instruction is not found for the forwarding objective {}", (Object)fwd);
            return null;
        }
        this.log.debug("Meter instruction is found.");
        return meter;
    }

    private Instructions.MetadataInstruction fetchWriteMetadata(ForwardingObjective fwd) {
        Instructions.MetadataInstruction writeMetadata = fwd.treatment().writeMetadata();
        if (writeMetadata == null) {
            this.log.warn("Write metadata is not found for the forwarding obj");
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return null;
        }
        this.log.debug("Write metadata is found {}", (Object)writeMetadata);
        return writeMetadata;
    }

    private List<Pair<Instruction, Instruction>> vlanOps(ForwardingObjective fwd, L2ModificationInstruction.L2SubType type) {
        List<Pair<Instruction, Instruction>> vlanOps = this.findVlanOps(fwd.treatment().allInstructions(), type);
        if (vlanOps == null || vlanOps.isEmpty()) {
            String direction = type == L2ModificationInstruction.L2SubType.VLAN_POP ? DOWNSTREAM : UPSTREAM;
            this.log.error("Missing vlan operations in {} forwarding: {}", (Object)direction, (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return ImmutableList.of();
        }
        return vlanOps;
    }

    private List<Pair<Instruction, Instruction>> findVlanOps(List<Instruction> instructions, L2ModificationInstruction.L2SubType type) {
        List<Instruction> vlanPushs = this.findL2Instructions(type, instructions);
        List<Instruction> vlanSets = this.findL2Instructions(L2ModificationInstruction.L2SubType.VLAN_ID, instructions);
        if (vlanPushs.size() != vlanSets.size()) {
            return ImmutableList.of();
        }
        ArrayList pairs = Lists.newArrayList();
        for (int i = 0; i < vlanPushs.size(); ++i) {
            pairs.add(new ImmutablePair((Object)vlanPushs.get(i), (Object)vlanSets.get(i)));
        }
        return pairs;
    }

    private List<Instruction> findL2Instructions(L2ModificationInstruction.L2SubType subType, List<Instruction> actions) {
        return actions.stream().filter((? super T i) -> i.type() == Instruction.Type.L2MODIFICATION).filter((? super T i) -> ((L2ModificationInstruction)i).subtype() == subType).collect(Collectors.toList());
    }

    private void provisionEthTypeBasedFilter(FilteringObjective filter, EthTypeCriterion ethType, Instructions.OutputInstruction output) {
        Instructions.MeterInstruction meter = filter.meta().metered();
        Instructions.MetadataInstruction writeMetadata = filter.meta().writeMetadata();
        Criterion vlanId = this.filterForCriterion(filter.conditions(), Criterion.Type.VLAN_VID);
        TrafficSelector selector = this.buildSelector(new Criterion[]{filter.key(), ethType, vlanId});
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{output, meter, writeMetadata});
        this.buildAndApplyRule(filter, selector, treatment);
    }

    private void provisionIgmp(FilteringObjective filter, EthTypeCriterion ethType, IPProtocolCriterion ipProto, Instructions.OutputInstruction output) {
        Instructions.MeterInstruction meter = filter.meta().metered();
        Instructions.MetadataInstruction writeMetadata = filter.meta().writeMetadata();
        TrafficSelector selector = this.buildSelector(new Criterion[]{filter.key(), ethType, ipProto});
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{output, meter, writeMetadata});
        this.buildAndApplyRule(filter, selector, treatment);
    }

    private void provisionDhcp(FilteringObjective filter, EthTypeCriterion ethType, IPProtocolCriterion ipProto, UdpPortCriterion udpSrcPort, UdpPortCriterion udpDstPort, Instructions.OutputInstruction output) {
        Instructions.MeterInstruction meter = filter.meta().metered();
        Instructions.MetadataInstruction writeMetadata = filter.meta().writeMetadata();
        TrafficSelector selector = this.buildSelector(new Criterion[]{filter.key(), ethType, ipProto, udpSrcPort, udpDstPort});
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{output, meter, writeMetadata});
        this.buildAndApplyRule(filter, selector, treatment);
    }

    private void buildAndApplyRule(FilteringObjective filter, TrafficSelector selector, TrafficTreatment treatment) {
        FlowRule rule = DefaultFlowRule.builder().fromApp(filter.appId()).forDevice(this.deviceId).forTable(0).makePermanent().withSelector(selector).withTreatment(treatment).withPriority(filter.priority()).build();
        FlowRuleOperations.Builder opsBuilder = FlowRuleOperations.builder();
        switch (filter.type()) {
            case PERMIT: {
                opsBuilder.add(rule);
                break;
            }
            case DENY: {
                opsBuilder.remove(rule);
                break;
            }
            default: {
                this.log.warn("Unknown filter type : {}", (Object)filter.type());
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
            }
        }
        this.applyFlowRules(opsBuilder, (Objective)filter);
    }

    private void applyRules(ForwardingObjective fwd, FlowRule.Builder ... fwdBuilders) {
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        switch (fwd.op()) {
            case ADD: {
                for (FlowRule.Builder fwdBuilder : fwdBuilders) {
                    builder.add(fwdBuilder.build());
                }
                break;
            }
            case REMOVE: {
                for (FlowRule.Builder fwdBuilder : fwdBuilders) {
                    builder.remove(fwdBuilder.build());
                }
                break;
            }
            case ADD_TO_EXISTING: {
                break;
            }
            case REMOVE_FROM_EXISTING: {
                break;
            }
            default: {
                this.log.warn("Unknown forwarding operation: {}", (Object)fwd.op());
            }
        }
        this.applyFlowRules(builder, (Objective)fwd);
    }

    private void applyFlowRules(FlowRuleOperations.Builder builder, final Objective objective) {
        this.flowRuleService.apply(builder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OltPipeline.this.pass(objective);
            }

            public void onError(FlowRuleOperations ops) {
                OltPipeline.this.fail(objective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Criterion filterForCriterion(Collection<Criterion> criteria, Criterion.Type type) {
        return criteria.stream().filter((? super T c) -> c.type().equals((Object)type)).limit(1L).findFirst().orElse(null);
    }

    private TrafficSelector buildSelector(Criterion ... criteria) {
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        Arrays.stream(criteria).filter(Objects::nonNull).forEach(arg_0 -> ((TrafficSelector.Builder)sBuilder).add(arg_0));
        return sBuilder.build();
    }

    private TrafficTreatment buildTreatment(Instruction ... instructions) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        Arrays.stream(instructions).filter(Objects::nonNull).forEach(arg_0 -> ((TrafficTreatment.Builder)tBuilder).add(arg_0));
        return tBuilder.build();
    }

    private Instruction writeMetadataIncludingOnlyTp(ForwardingObjective fwd) {
        return Instructions.writeMetadata((long)(this.fetchWriteMetadata(fwd).metadata() & 0xFFFF00000000L), (long)0L);
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private static class OLTPipelineGroup
    implements NextGroup {
        private final GroupKey key;

        public OLTPipelineGroup(GroupKey key) {
            this.key = key;
        }

        public GroupKey key() {
            return this.key;
        }

        public byte[] data() {
            return appKryo.serialize((Object)this.key);
        }
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            GroupKey key;
            NextObjective obj;
            if ((event.type() == GroupEvent.Type.GROUP_ADDED || event.type() == GroupEvent.Type.GROUP_UPDATED) && (obj = (NextObjective)OltPipeline.this.pendingGroups.getIfPresent((Object)(key = ((Group)event.subject()).appCookie()))) != null) {
                OltPipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new OLTPipelineGroup(key));
                OltPipeline.this.pass((Objective)obj);
                OltPipeline.this.pendingGroups.invalidate((Object)key);
            }
        }
    }
}

