/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraResubmit;
import org.onosproject.net.PortNumber;

public final class NiciraResubmitCodec
extends JsonCodec<NiciraResubmit> {
    private static final String RESUBMIT_PORT = "inPort";
    private static final String RESUBMIT_TABLE = "table";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraResubmit";

    public ObjectNode encode(NiciraResubmit niciraResubmit, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraResubmit), (Object)"Nicira Resubmit cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(RESUBMIT_PORT, niciraResubmit.inPort().toLong()).put(RESUBMIT_TABLE, niciraResubmit.table());
        return root;
    }

    public NiciraResubmit decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        long portNumberLong = ((JsonNode)Tools.nullIsIllegal((Object)json.get(RESUBMIT_PORT), (String)"inPort member is required in NiciraResubmit")).asLong();
        PortNumber portNumber = PortNumber.portNumber((long)portNumberLong);
        return new NiciraResubmit(portNumber);
    }
}

