/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraSetNshSpi;
import org.onosproject.net.NshServicePathId;

public final class NiciraSetNshSpiCodec
extends JsonCodec<NiciraSetNshSpi> {
    private static final String NSH_PATH_ID = "setNsp";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraSetNshSpi";

    public ObjectNode encode(NiciraSetNshSpi niciraSetNshSpi, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraSetNshSpi), (Object)"Nicira Set Nsh Spi cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(NSH_PATH_ID, niciraSetNshSpi.nshSpi().servicePathId());
        return root;
    }

    public NiciraSetNshSpi decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int servicePathIdInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NSH_PATH_ID), (String)"setNsp member is required in NiciraSetNshSpi")).asInt();
        NshServicePathId pathId = NshServicePathId.of((int)servicePathIdInt);
        return new NiciraSetNshSpi(pathId);
    }
}

