/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.extensions.Ofdpa3CopyField;
import org.onosproject.driver.extensions.Ofdpa3MplsType;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.OfdpaMatchActsetOutput;
import org.onosproject.driver.extensions.OfdpaMatchAllowVlanTranslation;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.OfdpaGroupHandlerUtility;
import org.onosproject.driver.pipeline.ofdpa.OfdpaPipelineUtility;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa2Pipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private static final Timer TIMER = new Timer("fwdobj-batching");
    private Accumulator<Pair<ForwardingObjective, Collection<FlowRule>>> accumulator;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ServiceDirectory serviceDirectory;
    protected FlowRuleService flowRuleService;
    protected CoreService coreService;
    protected GroupService groupService;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId driverId;
    protected DeviceService deviceService;
    protected static KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{OfdpaGroupHandlerUtility.OfdpaNextGroup.class}).register(new Class[]{ArrayDeque.class}).build("Ofdpa2Pipeline");
    protected Ofdpa2GroupHandler groupHandler;
    private ScheduledExecutorService retryExecutorService = Executors.newScheduledThreadPool(5, Tools.groupedThreads((String)"OfdpaPipeliner", (String)"retry-%d", (Logger)this.log));
    private ScheduledExecutorService accumulatorExecutorService = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"OfdpaPipeliner", (String)"acc-%d", (Logger)this.log));

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.serviceDirectory = context.directory();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        if (OfdpaPipelineUtility.isAccumulatorEnabled(this)) {
            this.accumulator = new ForwardingObjectiveAccumulator(context.accumulatorMaxObjectives(), context.accumulatorMaxBatchMillis(), context.accumulatorMaxIdleMillis());
        }
        this.initDriverId();
        this.initGroupHander(context);
        this.initializePipeline();
    }

    void setupAccumulatorForTests(int maxFwd, int maxBatchMS, int maxIdleMS) {
        if (this.accumulator == null) {
            this.accumulator = new ForwardingObjectiveAccumulator(maxFwd, maxBatchMS, maxIdleMS);
        }
    }

    protected void initDriverId() {
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.Ofdpa2Pipeline");
    }

    protected void initGroupHander(PipelinerContext context) {
        this.groupHandler = new Ofdpa2GroupHandler();
        this.groupHandler.init(this.deviceId, context);
    }

    protected void initializePipeline() {
    }

    public boolean requireMplsPop() {
        return true;
    }

    protected boolean requireEthType() {
        return true;
    }

    public boolean requireMplsBosMatch() {
        return true;
    }

    public boolean requireMplsTtlModification() {
        return true;
    }

    protected boolean requireVlanExtensions() {
        return true;
    }

    protected boolean matchInPortTmacTable() {
        return true;
    }

    protected boolean supportIpv6L4Dst() {
        return true;
    }

    protected boolean shouldRetry() {
        return true;
    }

    protected boolean requireUnicastBeforeMulticast() {
        return false;
    }

    protected boolean supportsUnicastBlackHole() {
        return true;
    }

    protected boolean requirePuntTable() {
        return false;
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.log.warn("filter objective other than PERMIT currently not supported");
            OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(ForwardingObjective fwd) {
        Collection<FlowRule> rules = this.processForward(fwd);
        if (rules == null || rules.isEmpty()) {
            return;
        }
        if (this.accumulator != null && Objects.equals(fwd.flag(), ForwardingObjective.Flag.SPECIFIC)) {
            this.accumulator.add((Object)Pair.of((Object)fwd, rules));
        } else {
            this.sendForwards(Collections.singletonList(Pair.of((Object)fwd, rules)));
        }
    }

    private void sendForwards(List<Pair<ForwardingObjective, Collection<FlowRule>>> pairs) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        this.log.debug("Sending {} fwd-objs", (Object)pairs.size());
        final ArrayList fwdObjs = Lists.newArrayList();
        pairs.forEach(pair -> {
            ForwardingObjective fwd = (ForwardingObjective)pair.getLeft();
            Collection rules = (Collection)pair.getRight();
            switch (fwd.op()) {
                case ADD: {
                    rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                    this.log.debug("Applying a add fwd-obj {} to sw:{}", (Object)fwd.id(), (Object)this.deviceId);
                    fwdObjs.add(fwd);
                    break;
                }
                case REMOVE: {
                    rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                    this.log.debug("Deleting a flow rule to sw:{}", (Object)this.deviceId);
                    fwdObjs.add(fwd);
                    break;
                }
                default: {
                    OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                    this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
                }
            }
        });
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                Ofdpa2Pipeline.this.log.trace("Flow rule operations onSuccess {}", (Object)ops);
                fwdObjs.forEach(OfdpaPipelineUtility::pass);
            }

            public void onError(FlowRuleOperations ops) {
                ObjectiveError error = ObjectiveError.FLOWINSTALLATIONFAILED;
                Ofdpa2Pipeline.this.log.warn("Flow rule operations onError {}. Reason = {}", (Object)ops, (Object)error);
                fwdObjs.forEach(fwdObj -> OfdpaPipelineUtility.fail(fwdObj, error));
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        NextGroup nextGroup = this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id()));
        switch (nextObjective.op()) {
            case ADD: {
                if (nextGroup != null) {
                    this.log.warn("Cannot add next {} that already exists in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id {} in dev {} - add group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.addGroup(nextObjective);
                break;
            }
            case ADD_TO_EXISTING: {
                if (nextGroup != null) {
                    this.log.debug("Processing NextObjective id {} in dev {} - add bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                    this.groupHandler.addBucketToGroup(nextObjective, nextGroup);
                    break;
                }
                this.log.debug("Waiting to add bucket to group for next-id:{} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.pendingBuckets.compute(nextObjective.id(), (nextId, pendBkts) -> {
                    if (pendBkts == null) {
                        pendBkts = Sets.newHashSet();
                    }
                    pendBkts.add(nextObjective);
                    return pendBkts;
                });
                break;
            }
            case REMOVE: {
                if (nextGroup == null) {
                    this.log.warn("Cannot remove next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id {}  in dev {} - remove group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.removeGroup(nextObjective, nextGroup);
                break;
            }
            case REMOVE_FROM_EXISTING: {
                if (nextGroup == null) {
                    this.log.warn("Cannot remove from next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id {} in dev {} - remove bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.removeBucketFromGroup(nextObjective, nextGroup);
                break;
            }
            case MODIFY: {
                if (nextGroup == null) {
                    this.log.warn("Cannot modify next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id {} in dev {} group {} - modify bucket", new Object[]{nextObjective.id(), this.deviceId, nextGroup});
                this.groupHandler.modifyBucketFromGroup(nextObjective, nextGroup);
                break;
            }
            case VERIFY: {
                if (nextGroup == null) {
                    this.log.warn("Cannot verify next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id {} in dev {} - verify", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.verifyGroup(nextObjective, nextGroup);
                break;
            }
            default: {
                this.log.warn("Unsupported operation {}", (Object)nextObjective.op());
            }
        }
    }

    protected void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        PortCriterion portCriterion = null;
        EthCriterion ethCriterion = null;
        VlanIdCriterion vidCriterion = null;
        if (!filt.key().equals(Criteria.dummy()) && filt.key().type() == Criterion.Type.IN_PORT) {
            portCriterion = (PortCriterion)filt.key();
        }
        if (portCriterion == null) {
            this.log.debug("No IN_PORT defined in filtering objective from app: {}", (Object)applicationId);
        } else {
            this.log.debug("Received filtering objective for dev/port: {}/{}", (Object)this.deviceId, (Object)portCriterion.port());
        }
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        block4: for (Criterion criterion : filt.conditions()) {
            switch (criterion.type()) {
                case ETH_DST: 
                case ETH_DST_MASKED: {
                    ethCriterion = (EthCriterion)criterion;
                    continue block4;
                }
                case VLAN_VID: {
                    vidCriterion = (VlanIdCriterion)criterion;
                    continue block4;
                }
            }
            this.log.warn("Unsupported filter {}", (Object)criterion);
            OfdpaPipelineUtility.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
            return;
        }
        VlanId assignedVlan = null;
        if (vidCriterion != null) {
            VlanId metaVlan;
            if (!vidCriterion.vlanId().equals((Object)VlanId.NONE)) {
                assignedVlan = vidCriterion.vlanId();
            }
            if (filt.meta() != null && (metaVlan = OfdpaPipelineUtility.readVlanFromTreatment(filt.meta())) != null) {
                assignedVlan = metaVlan;
            }
            if (assignedVlan == null) {
                this.log.error("Driver fails to extract VLAN information. Not processing VLAN filters on device {}.", (Object)this.deviceId);
                this.log.debug("VLAN ID in criterion={}, metadata={}", (Object)OfdpaPipelineUtility.readVlanFromTreatment(filt.meta()), (Object)vidCriterion.vlanId());
                OfdpaPipelineUtility.fail((Objective)filt, ObjectiveError.BADPARAMS);
                return;
            }
        }
        if (ethCriterion == null || ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            this.log.debug("filtering objective missing dstMac, won't program TMAC table");
        } else {
            MacAddress unicastMac = OfdpaPipelineUtility.readEthDstFromTreatment(filt.meta());
            List<List<FlowRule>> allStages = this.processEthDstFilter(portCriterion, ethCriterion, vidCriterion, assignedVlan, unicastMac, applicationId);
            for (List<FlowRule> flowRules : allStages) {
                this.log.trace("Starting a new flow rule stage for TMAC table flow");
                ops.newStage();
                for (FlowRule flowRule : flowRules) {
                    this.log.trace("{} flow rule in TMAC table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRule, this.deviceId});
                    if (install) {
                        ops = ops.add(flowRule);
                        continue;
                    }
                    if (filt.meta() != null && filt.meta().clearedDeferred()) {
                        FlowRule rule = this.buildTmacRuleForMcastFromUnicast(flowRule, applicationId);
                        if (rule != null) {
                            ops = ops.remove(rule);
                            ops.newStage();
                        }
                        ops = ops.remove(flowRule);
                        continue;
                    }
                    if (this.matchInPortTmacTable()) {
                        ops = ops.remove(flowRule);
                        continue;
                    }
                    this.log.debug("Abort TMAC flow removal on {}. Some other ports still share this TMAC flow", (Object)this.deviceId);
                }
            }
        }
        if (vidCriterion == null) {
            this.log.info("filtering objective missing VLAN, cannot program VLAN Table");
        } else {
            List<List<FlowRule>> allStages = this.processVlanIdFilter(portCriterion, vidCriterion, assignedVlan, applicationId, install);
            for (List<FlowRule> flowRules : allStages) {
                this.log.trace("Starting a new flow rule stage for VLAN table flow");
                ops.newStage();
                for (FlowRule flowRule : flowRules) {
                    this.log.trace("{} flow rules in VLAN table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRule, this.deviceId});
                    ops = install ? ops.add(flowRule) : ops.remove(flowRule);
                }
            }
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                Ofdpa2Pipeline.this.log.debug("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)Ofdpa2Pipeline.this.deviceId);
                OfdpaPipelineUtility.pass((Objective)filt);
            }

            public void onError(FlowRuleOperations ops) {
                Ofdpa2Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)Ofdpa2Pipeline.this.deviceId);
                OfdpaPipelineUtility.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    protected List<List<FlowRule>> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId, boolean install) {
        OfdpaMatchVlanVid ofdpaMatchVlanVid;
        ArrayList<FlowRule> filteringRules = new ArrayList<FlowRule>();
        ArrayList<FlowRule> assignmentRules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder preSelector = null;
        TrafficTreatment.Builder preTreatment = null;
        treatment.transition(Integer.valueOf(20));
        if (vidCriterion.vlanId() == VlanId.NONE) {
            preSelector = DefaultTrafficSelector.builder();
            if (this.requireVlanExtensions()) {
                ofdpaMatchVlanVid = new OfdpaMatchVlanVid(VlanId.NONE);
                selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
                OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(assignedVlan);
                treatment.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                OfdpaMatchVlanVid preOfdpaMatchVlanVid = new OfdpaMatchVlanVid(assignedVlan);
                preSelector.extension((ExtensionSelector)preOfdpaMatchVlanVid, this.deviceId);
            } else {
                selector.matchVlanId(VlanId.NONE);
                treatment.setVlanId(assignedVlan);
                preSelector.matchVlanId(assignedVlan);
            }
            preTreatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(20));
        } else {
            if (this.requireVlanExtensions()) {
                ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vidCriterion.vlanId());
                selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                selector.matchVlanId(vidCriterion.vlanId());
            }
            if (!assignedVlan.equals((Object)vidCriterion.vlanId())) {
                if (this.requireVlanExtensions()) {
                    OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(assignedVlan);
                    treatment.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                } else {
                    treatment.setVlanId(assignedVlan);
                }
            }
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion != null) {
            if (PortNumber.ALL.equals((Object)portCriterion.port())) {
                for (Port port : this.deviceService.getPorts(this.deviceId)) {
                    if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                    portnums.add(port.number());
                }
            } else {
                portnums.add(portCriterion.port());
            }
        } else {
            this.log.warn("Filtering Objective missing Port Criterion . VLAN Table cannot be programmed for {}", (Object)this.deviceId);
        }
        for (PortNumber pnum : portnums) {
            selector.matchInPort(pnum);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            assignmentRules.add(rule);
            if (preSelector == null) continue;
            preSelector.matchInPort(pnum);
            FlowRule preRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(preSelector.build()).withTreatment(preTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            filteringRules.add(preRule);
        }
        return install ? ImmutableList.of(filteringRules, assignmentRules) : ImmutableList.of(assignmentRules, filteringRules);
    }

    protected List<List<FlowRule>> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, MacAddress unicastMac, ApplicationId applicationId) {
        if (portCriterion != null && PortNumber.ANY.equals((Object)portCriterion.port())) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, assignedVlan, unicastMac, applicationId);
        }
        if (vidCriterion != null && vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        OfdpaMatchVlanVid ofdpaMatchVlanVid = null;
        if (vidCriterion != null && this.requireVlanExtensions()) {
            ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vidCriterion.vlanId());
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion != null) {
            if (PortNumber.ALL.equals((Object)portCriterion.port())) {
                for (Port port : this.deviceService.getPorts(this.deviceId)) {
                    if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                    portnums.add(port.number());
                }
            } else {
                portnums.add(portCriterion.port());
            }
            for (PortNumber pnum : portnums) {
                rules.add(this.buildTmacRuleForIpv4(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, pnum));
                rules.add(this.buildTmacRuleForMpls(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, pnum));
                rules.add(this.buildTmacRuleForIpv6(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, pnum));
            }
        } else {
            rules.add(this.buildTmacRuleForIpv4(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, null));
            rules.add(this.buildTmacRuleForMpls(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, null));
            rules.add(this.buildTmacRuleForIpv6(ethCriterion, vidCriterion, ofdpaMatchVlanVid, applicationId, null));
        }
        return ImmutableList.of(rules);
    }

    private FlowRule buildTmacRuleForIpv4(EthCriterion ethCriterion, VlanIdCriterion vidCriterion, OfdpaMatchVlanVid ofdpaMatchVlanVid, ApplicationId applicationId, PortNumber pnum) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        if (pnum != null) {
            if (this.matchInPortTmacTable()) {
                selector.matchInPort(pnum);
            } else {
                this.log.debug("Pipeline does not support IN_PORT matching in TMAC table, ignoring the IN_PORT criteria");
            }
        }
        if (vidCriterion != null) {
            if (this.requireVlanExtensions()) {
                selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                selector.matchVlanId(vidCriterion.vlanId());
            }
        }
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(30));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
    }

    private FlowRule buildTmacRuleForMpls(EthCriterion ethCriterion, VlanIdCriterion vidCriterion, OfdpaMatchVlanVid ofdpaMatchVlanVid, ApplicationId applicationId, PortNumber pnum) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        if (pnum != null) {
            if (this.matchInPortTmacTable()) {
                selector.matchInPort(pnum);
            } else {
                this.log.debug("Pipeline does not support IN_PORT matching in TMAC table, ignoring the IN_PORT criteria");
            }
        }
        if (vidCriterion != null) {
            if (this.requireVlanExtensions()) {
                selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                selector.matchVlanId(vidCriterion.vlanId());
            }
        }
        selector.matchEthType(Ethernet.MPLS_UNICAST);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(23));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
    }

    private FlowRule buildTmacRuleForIpv6(EthCriterion ethCriterion, VlanIdCriterion vidCriterion, OfdpaMatchVlanVid ofdpaMatchVlanVid, ApplicationId applicationId, PortNumber pnum) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        if (pnum != null) {
            if (this.matchInPortTmacTable()) {
                selector.matchInPort(pnum);
            } else {
                this.log.debug("Pipeline does not support IN_PORT matching in TMAC table, ignoring the IN_PORT criteria");
            }
        }
        if (vidCriterion != null) {
            if (this.requireVlanExtensions()) {
                selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                selector.matchVlanId(vidCriterion.vlanId());
            }
        }
        selector.matchEthType(Ethernet.TYPE_IPV6);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(30));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
    }

    protected List<List<FlowRule>> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(30));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        builder.add((Object)rule);
        selector = DefaultTrafficSelector.builder();
        treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV6);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(30));
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.of((Object)builder.add((Object)rule).build());
    }

    private FlowRule buildTmacRuleForMcastFromUnicast(FlowRule tmacRuleForUnicast, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        for (Criterion criterion : tmacRuleForUnicast.selector().criteria()) {
            if (criterion instanceof VlanIdCriterion) {
                if (this.requireVlanExtensions()) {
                    OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(((VlanIdCriterion)criterion).vlanId());
                    selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
                    continue;
                }
                selector.add(criterion);
                continue;
            }
            if (!(criterion instanceof EthTypeCriterion)) continue;
            selector.add(criterion);
            if (Objects.equals(((EthTypeCriterion)criterion).ethType(), EthType.EtherType.IPV4.ethType())) {
                selector.matchEthDstMasked(MacAddress.IPV4_MULTICAST, MacAddress.IPV4_MULTICAST_MASK);
                continue;
            }
            if (Objects.equals(((EthTypeCriterion)criterion).ethType(), EthType.EtherType.IPV6.ethType())) {
                selector.matchEthDstMasked(MacAddress.IPV6_MULTICAST, MacAddress.IPV6_MULTICAST_MASK);
                continue;
            }
            return null;
        }
        treatment.transition(Integer.valueOf(40));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        this.log.debug("Building TMac Mcast flowRule {}", (Object)rule);
        return rule;
    }

    List<List<FlowRule>> processMcastEthDstFilter(EthCriterion ethCriterion, VlanId assignedVlan, MacAddress unicastMac, ApplicationId applicationId) {
        FlowRule rule;
        TrafficTreatment.Builder treatment;
        TrafficSelector.Builder selector;
        ImmutableList.Builder unicastFlows = ImmutableList.builder();
        ImmutableList.Builder multicastFlows = ImmutableList.builder();
        if (MacAddress.IPV4_MULTICAST.equals((Object)ethCriterion.mac())) {
            if (this.requireUnicastBeforeMulticast()) {
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchEthType(Ethernet.TYPE_IPV4);
                selector.matchEthDst(unicastMac);
                selector.matchVlanId(assignedVlan);
                treatment.transition(Integer.valueOf(30));
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
                unicastFlows.add((Object)rule);
            }
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDstMasked(ethCriterion.mac(), ethCriterion.mask());
            selector.matchVlanId(assignedVlan);
            treatment.transition(Integer.valueOf(40));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            multicastFlows.add((Object)rule);
        }
        if (MacAddress.IPV6_MULTICAST.equals((Object)ethCriterion.mac())) {
            if (this.requireUnicastBeforeMulticast()) {
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchEthType(Ethernet.TYPE_IPV6);
                selector.matchEthDst(unicastMac);
                selector.matchVlanId(assignedVlan);
                treatment.transition(Integer.valueOf(30));
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
                unicastFlows.add((Object)rule);
            }
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchEthDstMasked(ethCriterion.mac(), ethCriterion.mask());
            selector.matchVlanId(assignedVlan);
            treatment.transition(Integer.valueOf(40));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            multicastFlows.add((Object)rule);
        }
        return ImmutableList.of((Object)unicastFlows.build(), (Object)multicastFlows.build());
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
            case EGRESS: {
                return this.processEgress(fwd);
            }
        }
        OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    protected Collection<FlowRule> processEgress(ForwardingObjective fwd) {
        this.log.debug("Processing egress forwarding objective:{} in dev:{}", (Object)fwd, (Object)this.deviceId);
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder sb = DefaultTrafficSelector.builder();
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)fwd.selector().getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.error("Egress forwarding objective:{} must include vlanId", (Object)fwd.id());
            OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return rules;
        }
        Optional<Instruction> outInstr = fwd.treatment().allInstructions().stream().filter((? super T instruction) -> instruction instanceof Instructions.OutputInstruction).findFirst();
        if (!outInstr.isPresent()) {
            this.log.error("Egress forwarding objective:{} must include output port", (Object)fwd.id());
            OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return rules;
        }
        PortNumber portNumber = ((Instructions.OutputInstruction)outInstr.get()).port();
        sb.matchVlanId(vlanIdCriterion.vlanId());
        OfdpaMatchActsetOutput actsetOutput = new OfdpaMatchActsetOutput(portNumber);
        sb.extension((ExtensionSelector)actsetOutput, this.deviceId);
        sb.extension((ExtensionSelector)new OfdpaMatchAllowVlanTranslation((short)1), this.deviceId);
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        tb.transition(Integer.valueOf(230));
        if (fwd.treatment() != null) {
            for (Instruction instr : fwd.treatment().allInstructions()) {
                if (instr instanceof L2ModificationInstruction && ((L2ModificationInstruction)instr).subtype() == L2ModificationInstruction.L2SubType.VLAN_ID) {
                    tb.immediate().add(instr);
                }
                if (!(instr instanceof L2ModificationInstruction) || ((L2ModificationInstruction)instr).subtype() != L2ModificationInstruction.L2SubType.VLAN_PUSH) continue;
                tb.immediate().pushVlan();
                EthType ethType = ((L2ModificationInstruction.ModVlanHeaderInstruction)instr).ethernetType();
                if (!ethType.equals((Object)EthType.EtherType.QINQ.ethType())) continue;
                TrafficSelector tpidSelector = DefaultTrafficSelector.builder().extension((ExtensionSelector)actsetOutput, this.deviceId).matchVlanId(VlanId.ANY).build();
                TrafficTreatment tpidTreatment = DefaultTrafficTreatment.builder().extension((ExtensionTreatment)new Ofdpa3CopyField(12, 0, 0, -2147480574, -2147417600), this.deviceId).popVlan().pushVlan(EthType.EtherType.QINQ.ethType()).extension((ExtensionTreatment)new Ofdpa3CopyField(12, 0, 0, -2147417600, -2147480574), this.deviceId).build();
                FlowRule.Builder tpidRuleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(tpidSelector).withTreatment(tpidTreatment).makePermanent().forTable(235);
                rules.add(tpidRuleBuilder.build());
            }
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sb.build()).withTreatment(tb.build()).makePermanent().forTable(210);
        rules.add(ruleBuilder.build());
        return rules;
    }

    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.debug("Processing versatile forwarding objective:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
        ArrayList<FlowRule> flowRules = new ArrayList<FlowRule>();
        AtomicBoolean ethTypeUsed = new AtomicBoolean(false);
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            if (criterion instanceof VlanIdCriterion) {
                VlanId vlanId = ((VlanIdCriterion)criterion).vlanId();
                if (vlanId.equals((Object)VlanId.NONE)) {
                    return;
                }
                if (this.requireVlanExtensions()) {
                    OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vlanId);
                    sbuilder.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
                } else {
                    sbuilder.matchVlanId(vlanId);
                }
            } else if (criterion instanceof Icmpv6TypeCriterion) {
                byte icmpv6Type = (byte)((Icmpv6TypeCriterion)criterion).icmpv6Type();
                sbuilder.matchIcmpv6Type(icmpv6Type);
            } else if (criterion instanceof Icmpv6CodeCriterion) {
                byte icmpv6Code = (byte)((Icmpv6CodeCriterion)criterion).icmpv6Code();
                sbuilder.matchIcmpv6Type(icmpv6Code);
            } else if (criterion instanceof TcpPortCriterion || criterion instanceof UdpPortCriterion) {
                if (!this.supportIpv6L4Dst() && OfdpaPipelineUtility.isIpv6(fwd.selector())) {
                    switch (criterion.type()) {
                        case UDP_DST: 
                        case UDP_DST_MASKED: 
                        case TCP_DST: 
                        case TCP_DST_MASKED: {
                            break;
                        }
                        default: {
                            sbuilder.add(criterion);
                            break;
                        }
                    }
                } else {
                    sbuilder.add(criterion);
                }
            } else if (criterion instanceof EthTypeCriterion) {
                sbuilder.add(criterion);
                ethTypeUsed.set(true);
            } else {
                sbuilder.add(criterion);
            }
        });
        TrafficTreatment.Builder ttBuilder = this.versatileTreatmentBuilder(fwd);
        if (ttBuilder == null) {
            return Collections.emptySet();
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        flowRules.add(ruleBuilder.build());
        if (!ethTypeUsed.get() && this.requireEthType()) {
            this.log.debug("{} doesn't match on ethType but requireEthType is true, adding complementary ACL flow.", (Object)sbuilder.toString());
            sbuilder.matchEthType(Ethernet.TYPE_IPV6);
            FlowRule.Builder ethTypeRuleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
            flowRules.add(ethTypeRuleBuilder.build());
        }
        return flowRules;
    }

    protected TrafficTreatment.Builder versatileTreatmentBuilder(ForwardingObjective fwd) {
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (PortNumber.CONTROLLER.equals((Object)o.port())) {
                        ttBuilder.add((Instruction)o);
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                if (ins instanceof Instructions.NoActionInstruction) continue;
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
            if (fwd.treatment().clearedDeferred()) {
                ttBuilder.wipeDeferred();
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            if (next == null) {
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return null;
            }
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return null;
            }
            ttBuilder.deferred().group(group.id());
        }
        return ttBuilder;
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific fwd objective:{} in dev:{} with next:{}", new Object[]{fwd.id(), this.deviceId, fwd.nextId()});
        boolean isEthTypeObj = this.isSupportedEthTypeObjective(fwd);
        boolean isEthDstObj = this.isSupportedEthDstObjective(fwd);
        if (isEthTypeObj) {
            return this.processEthTypeSpecific(fwd);
        }
        if (isEthDstObj) {
            return this.processEthDstSpecific(fwd);
        }
        this.log.warn("processSpecific: Unsupported forwarding objective criteria fwd:{} in dev:{}", (Object)fwd.nextId(), (Object)this.deviceId);
        OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return Collections.emptySet();
    }

    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        return this.processEthTypeSpecificInternal(fwd, false, 60);
    }

    protected Collection<FlowRule> processEthTypeSpecificInternal(ForwardingObjective fwd, boolean allowDefaultRoute, int mplsNextTable) {
        int forTableId;
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        boolean emptyGroup = false;
        TrafficSelector.Builder filteredSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder complementarySelector = DefaultTrafficSelector.builder();
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            if (this.buildIpv4Selector(filteredSelector, complementarySelector, fwd, allowDefaultRoute) < 0) {
                return Collections.emptyList();
            }
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            forTableId = ipv4Dst.isMulticast() ? 40 : 30;
        } else if (ethType.ethType().toShort() == Ethernet.TYPE_IPV6) {
            if (this.buildIpv6Selector(filteredSelector, fwd) < 0) {
                return Collections.emptyList();
            }
            IpPrefix ipv6Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV6_DST)).ip();
            forTableId = ipv6Dst.isMulticast() ? 40 : 30;
        } else {
            filteredSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            MplsBosCriterion bos = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
            if (bos != null && this.requireMplsBosMatch()) {
                filteredSelector.matchMplsBos(bos.mplsBos());
            }
            forTableId = 24;
            this.log.debug("processing MPLS specific forwarding objective {} -> next:{} in dev {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            if (fwd.treatment() != null) {
                for (Instruction instr : fwd.treatment().allInstructions()) {
                    if (instr instanceof L2ModificationInstruction && ((L2ModificationInstruction)instr).subtype() == L2ModificationInstruction.L2SubType.MPLS_POP) {
                        if (this.requireMplsPop()) {
                            if (mplsNextTable == 29 && OfdpaPipelineUtility.isNotMplsBos(selector)) {
                                tb.immediate().popMpls();
                            }
                        } else if (instr instanceof L2ModificationInstruction.ModMplsHeaderInstruction && !((L2ModificationInstruction.ModMplsHeaderInstruction)instr).ethernetType().equals((Object)EthType.EtherType.MPLS_UNICAST.ethType())) {
                            tb.immediate().add(instr);
                        }
                    }
                    if (!this.requireMplsTtlModification()) continue;
                    if (instr instanceof L3ModificationInstruction && ((L3ModificationInstruction)instr).subtype() == L3ModificationInstruction.L3SubType.DEC_TTL) {
                        tb.immediate().decMplsTtl();
                    }
                    if (!(instr instanceof L3ModificationInstruction) || ((L3ModificationInstruction)instr).subtype() != L3ModificationInstruction.L3SubType.TTL_IN) continue;
                    tb.immediate().add(instr);
                }
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            if (next != null) {
                List gkeys = (List)appKryo.deserialize(next.data());
                Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
                if (group == null) {
                    this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                    OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                    return Collections.emptySet();
                }
                if (OfdpaPipelineUtility.isNotMplsBos(selector) && group.type().equals((Object)GroupDescription.Type.SELECT)) {
                    this.log.warn("SR CONTINUE case cannot be handled as MPLS ECMP is not implemented in OF-DPA yet. Aborting flow {} -> next:{} in this device {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
                    OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                    return Collections.emptySet();
                }
                tb.deferred().group(group.id());
                if (gkeys.size() == 1 && ((Deque)gkeys.get(0)).size() == 1 && this.shouldRetry()) {
                    this.log.warn("Found empty group 0x{} in dev:{} .. will retry fwd:{}", new Object[]{Integer.toHexString((Integer)group.id().id()), this.deviceId, fwd.id()});
                    emptyGroup = true;
                }
            } else {
                this.log.warn("Cannot find group for nextId:{} in dev:{}. Aborting fwd:{}", new Object[]{fwd.nextId(), this.deviceId, fwd.id()});
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                return Collections.emptySet();
            }
        }
        if (forTableId == 24) {
            if (mplsNextTable == 27) {
                Ofdpa3SetMplsType setMplsType = new Ofdpa3SetMplsType(Ofdpa3MplsType.L3_PHP);
                tb.immediate().extension((ExtensionTreatment)setMplsType, this.deviceId);
            }
            tb.transition(Integer.valueOf(mplsNextTable));
        } else {
            tb.transition(Integer.valueOf(60));
        }
        if (fwd.treatment() != null && fwd.treatment().clearedDeferred()) {
            if (this.supportsUnicastBlackHole()) {
                tb.wipeDeferred();
            } else {
                this.log.warn("Clear Deferred is not supported Unicast Routing Table on device {}", (Object)this.deviceId);
                return Collections.emptySet();
            }
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ArrayList<FlowRule> flowRuleCollection = new ArrayList<FlowRule>();
        flowRuleCollection.add(ruleBuilder.build());
        if (!allowDefaultRoute) {
            flowRuleCollection.add(this.defaultRoute(fwd, complementarySelector, forTableId, tb));
            this.log.debug("Default rule 0.0.0.0/0 is being installed two rules");
        }
        if (emptyGroup) {
            this.retryExecutorService.schedule(new RetryFlows(fwd, flowRuleCollection), 1000L, TimeUnit.MILLISECONDS);
        }
        return flowRuleCollection;
    }

    private int buildIpv4Selector(TrafficSelector.Builder builderToUpdate, TrafficSelector.Builder extBuilder, ForwardingObjective fwd, boolean allowDefaultRoute) {
        TrafficSelector selector = fwd.selector();
        IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
        if (ipv4Dst.isMulticast()) {
            if (ipv4Dst.prefixLength() != 32) {
                this.log.warn("Multicast specific forwarding objective can only be /32");
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            VlanId assignedVlan = OfdpaPipelineUtility.readVlanFromSelector(fwd.meta());
            if (assignedVlan == null) {
                this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            if (this.requireVlanExtensions()) {
                OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(assignedVlan);
                builderToUpdate.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                builderToUpdate.matchVlanId(assignedVlan);
            }
            builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
            this.log.debug("processing IPv4 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            if (ipv4Dst.prefixLength() == 0) {
                if (allowDefaultRoute) {
                    builderToUpdate.matchEthType(Ethernet.TYPE_IPV4);
                } else {
                    builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(IpPrefix.valueOf((String)"0.0.0.0/1"));
                    extBuilder.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(IpPrefix.valueOf((String)"128.0.0.0/1"));
                }
            } else {
                builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
            }
            this.log.debug("processing IPv4 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        return 0;
    }

    int buildIpv6Selector(TrafficSelector.Builder builderToUpdate, ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        IpPrefix ipv6Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV6_DST)).ip();
        if (ipv6Dst.isMulticast()) {
            if (ipv6Dst.prefixLength() != 128) {
                this.log.warn("Multicast specific forwarding objective can only be /128");
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            VlanId assignedVlan = OfdpaPipelineUtility.readVlanFromSelector(fwd.meta());
            if (assignedVlan == null) {
                this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            if (this.requireVlanExtensions()) {
                OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(assignedVlan);
                builderToUpdate.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                builderToUpdate.matchVlanId(assignedVlan);
            }
            builderToUpdate.matchEthType(Ethernet.TYPE_IPV6).matchIPv6Dst(ipv6Dst);
            this.log.debug("processing IPv6 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            if (ipv6Dst.prefixLength() != 0) {
                builderToUpdate.matchIPv6Dst(ipv6Dst);
            }
            builderToUpdate.matchEthType(Ethernet.TYPE_IPV6);
            this.log.debug("processing IPv6 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        return 0;
    }

    FlowRule defaultRoute(ForwardingObjective fwd, TrafficSelector.Builder complementarySelector, int forTableId, TrafficTreatment.Builder tb) {
        FlowRule.Builder rule = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(complementarySelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            rule.makePermanent();
        } else {
            rule.makeTemporary(fwd.timeout());
        }
        return rule.build();
    }

    protected Collection<FlowRule> processEthDstSpecific(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.warn("Forwarding objective for bridging requires vlan. Not installing fwd:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
            OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE) && !ethCriterion.mac().equals((Object)MacAddress.BROADCAST)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            this.log.debug("processing L2 forwarding objective:{} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            this.log.debug("processing L2 Broadcast forwarding objective:{} -> next:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        if (this.requireVlanExtensions()) {
            OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vlanIdCriterion.vlanId());
            filteredSelectorBuilder.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
        } else {
            filteredSelectorBuilder.matchVlanId(vlanIdCriterion.vlanId());
        }
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        if (fwd.treatment() != null) {
            this.log.warn("Ignoring traffic treatment in fwd rule {} meant for L2 tablefor dev:{}. Expecting only nextId", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group != null) {
                treatmentBuilder.deferred().group(group.id());
            } else {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                OfdpaPipelineUtility.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(60));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(50);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    private boolean isSupportedEthTypeObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        return ethType != null && (ethType.ethType().toShort() == Ethernet.TYPE_IPV4 || ethType.ethType().toShort() == Ethernet.MPLS_UNICAST || ethType.ethType().toShort() == Ethernet.TYPE_IPV6);
    }

    private boolean isSupportedEthDstObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthCriterion ethDst = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanId = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        return ethDst != null || vlanId != null;
    }

    NextGroup getGroupForNextObjective(Integer nextId) {
        NextGroup next = this.flowObjectiveStore.getNextGroup(nextId);
        if (next != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            if (gkeys != null && !gkeys.isEmpty()) {
                return next;
            }
            this.log.warn("Empty next group found in FlowObjective store for next-id:{} in dev:{}", (Object)nextId, (Object)this.deviceId);
        } else {
            this.log.warn("next-id {} not found in Flow objective store for dev:{}", (Object)nextId, (Object)this.deviceId);
        }
        return null;
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        ArrayList<String> mappings = new ArrayList<String>();
        List gkeys = (List)appKryo.deserialize(nextGroup.data());
        for (Deque gkd : gkeys) {
            Group lastGroup = null;
            StringBuilder gchain = new StringBuilder();
            for (GroupKey gk : gkd) {
                Group g = this.groupService.getGroup(this.deviceId, gk);
                if (g == null) {
                    gchain.append("  NoGrp").append(" -->");
                    continue;
                }
                gchain.append("  0x").append(Integer.toHexString((Integer)g.id().id())).append(" -->");
                lastGroup = g;
            }
            List lastGroupIns = new ArrayList();
            if (lastGroup != null && !lastGroup.buckets().buckets().isEmpty()) {
                lastGroupIns = ((GroupBucket)lastGroup.buckets().buckets().get(0)).treatment().allInstructions();
            }
            for (Instruction i : lastGroupIns) {
                if (!(i instanceof Instructions.OutputInstruction)) continue;
                gchain.append(" port:").append(((Instructions.OutputInstruction)i).port());
            }
            mappings.add(gchain.toString());
        }
        return mappings;
    }

    private final class FlowRulesBuilderTask
    implements Runnable {
        private final List<Pair<ForwardingObjective, Collection<FlowRule>>> pairs;

        FlowRulesBuilderTask(List<Pair<ForwardingObjective, Collection<FlowRule>>> pairs) {
            this.pairs = pairs;
        }

        @Override
        public void run() {
            try {
                Ofdpa2Pipeline.this.sendForwards(this.pairs);
            }
            catch (Exception e) {
                Ofdpa2Pipeline.this.log.warn("Unable to send forwards", (Throwable)e);
            }
        }
    }

    private final class ForwardingObjectiveAccumulator
    extends AbstractAccumulator<Pair<ForwardingObjective, Collection<FlowRule>>> {
        ForwardingObjectiveAccumulator(int maxFwd, int maxBatchMS, int maxIdleMS) {
            super(TIMER, maxFwd, maxBatchMS, maxIdleMS);
        }

        public void processItems(List<Pair<ForwardingObjective, Collection<FlowRule>>> pairs) {
            Ofdpa2Pipeline.this.accumulatorExecutorService.execute(new FlowRulesBuilderTask(pairs));
        }
    }

    public final class RetryFlows
    implements Runnable {
        int attempts = 10;
        private Collection<FlowRule> retryFlows;
        private ForwardingObjective fwd;

        RetryFlows(ForwardingObjective fwd, Collection<FlowRule> retryFlows) {
            this.fwd = fwd;
            this.retryFlows = retryFlows;
        }

        @Override
        public void run() {
            Ofdpa2Pipeline.this.log.info("RETRY FLOWS ATTEMPT# {} for fwd:{} rules:{}", new Object[]{10 - this.attempts, this.fwd.id(), this.retryFlows.size()});
            Ofdpa2Pipeline.this.sendForwards(Collections.singletonList(Pair.of((Object)this.fwd, this.retryFlows)));
            if (--this.attempts > 0) {
                Ofdpa2Pipeline.this.retryExecutorService.schedule(this, 1000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

