/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraSetNshSi;
import org.onosproject.net.NshServiceIndex;

public final class NiciraSetNshSiCodec
extends JsonCodec<NiciraSetNshSi> {
    private static final String NSH_SERVICE_INDEX = "setNsi";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraSetNshSi";

    public ObjectNode encode(NiciraSetNshSi niciraSetNshSi, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraSetNshSi), (Object)"Nicira Set Nsh Si cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(NSH_SERVICE_INDEX, niciraSetNshSi.nshSi().serviceIndex());
        return root;
    }

    public NiciraSetNshSi decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        short serviceIndexShort = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(NSH_SERVICE_INDEX), (String)"setNsi member is required in NiciraSetNshSi")).asInt();
        NshServiceIndex index = NshServiceIndex.of((short)serviceIndexShort);
        return new NiciraSetNshSi(index);
    }
}

