/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.OfdpaMatchActsetOutput;
import org.onosproject.net.PortNumber;

public class OfdpaMatchActsetOutputCodec
extends JsonCodec<OfdpaMatchActsetOutput> {
    private static final String ACTSET_OUTPUT = "actsetOutput";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in OfdpaMatchActsetOutput";
    private static final String MISSING_ACTSET_OUTPUT_MESSAGE = "Actset Output cannot be null";

    public ObjectNode encode(OfdpaMatchActsetOutput actsetOutput, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)actsetOutput), (Object)MISSING_ACTSET_OUTPUT_MESSAGE);
        return context.mapper().createObjectNode().put(ACTSET_OUTPUT, actsetOutput.port().toLong());
    }

    public OfdpaMatchActsetOutput decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        long portNumber = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ACTSET_OUTPUT), (String)"actsetOutput member is required in OfdpaMatchActsetOutput")).asLong();
        return new OfdpaMatchActsetOutput(PortNumber.portNumber((long)portNumber));
    }
}

