/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;

public class NiciraLoad
extends AbstractExtension
implements ExtensionTreatment {
    private int ofsNbits;
    private long dst;
    private long value;
    private final KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{Map.class}).register(new Class[]{HashMap.class}).build();

    public NiciraLoad() {
    }

    public NiciraLoad(int ofsNbits, long dst, long value) {
        this.ofsNbits = ofsNbits;
        this.dst = dst;
        this.value = value;
    }

    public int ofsNbits() {
        return this.ofsNbits;
    }

    public long dst() {
        return this.dst;
    }

    public long value() {
        return this.value;
    }

    public ExtensionTreatmentType type() {
        return ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_LOAD.type();
    }

    public byte[] serialize() {
        HashMap values = Maps.newHashMap();
        values.put("ofsNbits", this.ofsNbits);
        values.put("dst", this.dst);
        values.put("value", this.value);
        return this.appKryo.serialize((Object)values);
    }

    public void deserialize(byte[] data) {
        Map values = (Map)this.appKryo.deserialize(data);
        this.ofsNbits = (Integer)values.get("ofsNbits");
        this.dst = (Long)values.get("dst");
        this.value = (Long)values.get("value");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NiciraLoad that = (NiciraLoad)((Object)o);
        return this.ofsNbits == that.ofsNbits && this.dst == that.dst && this.value == that.value && Objects.equals(this.type(), that.type());
    }

    public int hashCode() {
        return Objects.hash(this.ofsNbits, this.dst, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("ofsNbits", this.ofsNbits).add("dst", this.dst).add("value", this.value).toString();
    }
}

