/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraMatchNshSpi;
import org.onosproject.net.NshServicePathId;

public final class NiciraMatchNshSpiCodec
extends JsonCodec<NiciraMatchNshSpi> {
    private static final String NSH_PATH_ID = "nsp";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraMatchNshSpi";

    public ObjectNode encode(NiciraMatchNshSpi niciraMatchNshSpi, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraMatchNshSpi), (Object)"Nicira Match Nsh Spi cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(NSH_PATH_ID, niciraMatchNshSpi.nshSpi().servicePathId());
        return root;
    }

    public NiciraMatchNshSpi decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int nshSpiInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NSH_PATH_ID), (String)"nsp member is required in NiciraMatchNshSpi")).asInt();
        NshServicePathId nshSpi = NshServicePathId.of((int)nshSpiInt);
        return new NiciraMatchNshSpi(nshSpi);
    }
}

