/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.DefaultMoveExtensionTreatment;
import org.onosproject.driver.extensions.MoveExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;

public final class MoveExtensionTreatmentCodec
extends JsonCodec<MoveExtensionTreatment> {
    private static final String SRC_OFS = "srcOfs";
    private static final String DST_OFS = "dstOfs";
    private static final String N_BITS = "nBits";
    private static final String SRC = "src";
    private static final String DST = "dst";
    private static final String TYPE = "type";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in MoveExtensionTreatment";

    public ObjectNode encode(MoveExtensionTreatment moveExtensionTreatment, CodecContext context) {
        Preconditions.checkNotNull((Object)moveExtensionTreatment, (Object)"Move Extension Treatment cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(SRC_OFS, moveExtensionTreatment.srcOffset()).put(DST_OFS, moveExtensionTreatment.dstOffset()).put(N_BITS, moveExtensionTreatment.nBits()).put(SRC, moveExtensionTreatment.src()).put(DST, moveExtensionTreatment.dst());
        return root;
    }

    public MoveExtensionTreatment decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        ExtensionTreatmentType type = new ExtensionTreatmentType(((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in MoveExtensionTreatment")).asInt());
        int srcOfs = ((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC_OFS), (String)"srcOfs member is required in MoveExtensionTreatment")).asInt();
        int dstOfs = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DST_OFS), (String)"dstOfs member is required in MoveExtensionTreatment")).asInt();
        int nBits = ((JsonNode)Tools.nullIsIllegal((Object)json.get(N_BITS), (String)"nBits member is required in MoveExtensionTreatment")).asInt();
        int src = ((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC), (String)"src member is required in MoveExtensionTreatment")).asInt();
        int dst = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DST), (String)"dst member is required in MoveExtensionTreatment")).asInt();
        return new DefaultMoveExtensionTreatment(srcOfs, dstOfs, nBits, src, dst, type);
    }
}

