/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.Ofdpa3CopyField;

public class Ofdpa3CopyFieldCodec
extends JsonCodec<Ofdpa3CopyField> {
    private static final String N_BITS = "nBits";
    private static final String SRC = "src";
    private static final String DST = "dst";
    private static final String SRC_OFFSET = "srcOffset";
    private static final String DST_OFFSET = "dstOffset";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Ofdpa3CopyField";
    private static final String MISSING_COPY_FIELD_MESSAGE = "CopyField can not be null";

    public ObjectNode encode(Ofdpa3CopyField copyField, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)copyField), (Object)MISSING_COPY_FIELD_MESSAGE);
        return context.mapper().createObjectNode().put(N_BITS, copyField.getnBits()).put(SRC_OFFSET, copyField.getSrcOffset()).put(DST_OFFSET, copyField.getDstOffset()).put(SRC, copyField.getSrc()).put(DST, copyField.getDst());
    }

    public Ofdpa3CopyField decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int nBits = ((JsonNode)Tools.nullIsIllegal((Object)json.get(N_BITS), (String)"nBits member is required in Ofdpa3CopyField")).asInt();
        int src = ((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC), (String)"src member is required in Ofdpa3CopyField")).asInt();
        int dst = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DST), (String)"dst member is required in Ofdpa3CopyField")).asInt();
        int srcOffset = ((JsonNode)Tools.nullIsIllegal((Object)json.get(SRC_OFFSET), (String)"srcOffset member is required in Ofdpa3CopyField")).asInt();
        int dstOffset = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DST_OFFSET), (String)"dstOffset member is required in Ofdpa3CopyField")).asInt();
        return new Ofdpa3CopyField(nBits, src, dst, srcOffset, dstOffset);
    }
}

