/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.driver.extensions.Ofdpa3MatchMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;
import org.onosproject.driver.extensions.Ofdpa3MplsType;
import org.onosproject.driver.extensions.Ofdpa3PopCw;
import org.onosproject.driver.extensions.Ofdpa3PopL2Header;
import org.onosproject.driver.extensions.Ofdpa3SetMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.Ofdpa3SetOvid;
import org.onosproject.driver.extensions.Ofdpa3SetQosIndex;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa3GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.OfdpaPipelineUtility;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3Pipeline
extends Ofdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void initDriverId() {
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.Ofdpa3Pipeline");
    }

    @Override
    protected void initGroupHander(PipelinerContext context) {
        this.groupHandler = new Ofdpa3GroupHandler();
        this.groupHandler.init(this.deviceId, context);
    }

    @Override
    protected boolean requireVlanExtensions() {
        return false;
    }

    @Override
    protected boolean shouldRetry() {
        return false;
    }

    @Override
    protected boolean supportsUnicastBlackHole() {
        return true;
    }

    @Override
    protected void processFilter(final FilteringObjective filteringObjective, boolean install, ApplicationId applicationId) {
        boolean isPw = OfdpaPipelineUtility.isPseudowire(filteringObjective);
        if (isPw) {
            L2ModificationInstruction vlanInstruction;
            long tunnelId;
            FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
            VlanIdCriterion innerVlanIdCriterion = null;
            for (Object criterion : filteringObjective.conditions()) {
                if (criterion.type() != Criterion.Type.INNER_VLAN_VID) continue;
                innerVlanIdCriterion = (VlanIdCriterion)criterion;
                break;
            }
            VlanIdCriterion outerVlanIdCriterion = null;
            PortCriterion portCriterion = (PortCriterion)filteringObjective.key();
            for (Criterion criterion : filteringObjective.conditions()) {
                if (criterion.type() != Criterion.Type.VLAN_VID) continue;
                outerVlanIdCriterion = (VlanIdCriterion)criterion;
                break;
            }
            if (filteringObjective.meta() != null && filteringObjective.meta().allInstructions().size() != 2) {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            if (filteringObjective.meta() != null && filteringObjective.meta().allInstructions().size() == 2 && ((Instruction)filteringObjective.meta().allInstructions().get(0)).type() == Instruction.Type.L2MODIFICATION && ((Instruction)filteringObjective.meta().allInstructions().get(1)).type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2instruction = (L2ModificationInstruction)filteringObjective.meta().allInstructions().get(0);
                if (l2instruction.subtype() != L2ModificationInstruction.L2SubType.TUNNEL_ID) {
                    this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                    OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                tunnelId = ((L2ModificationInstruction.ModTunnelIdInstruction)l2instruction).tunnelId();
                vlanInstruction = (L2ModificationInstruction)filteringObjective.meta().allInstructions().get(1);
                if (vlanInstruction.subtype() != L2ModificationInstruction.L2SubType.VLAN_ID) {
                    this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                    OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                    return;
                }
            } else {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            VlanId egressVlan = ((L2ModificationInstruction.ModVlanIdInstruction)vlanInstruction).vlanId();
            tunnelId = 0x10000L | tunnelId;
            if (portCriterion == null || outerVlanIdCriterion == null || tunnelId > 131071L) {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            if (portCriterion.port().toLong() > 65535L) {
                this.log.error("Filtering Objective invalid logical port {}", (Object)portCriterion.port().toLong());
                OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            List<FlowRule> pwRules = this.processPwFilter(portCriterion, innerVlanIdCriterion, outerVlanIdCriterion, tunnelId, applicationId, egressVlan);
            for (FlowRule pwRule : pwRules) {
                this.log.debug("adding filtering rule in VLAN tables: {} for dev: {}", (Object)pwRule, (Object)this.deviceId);
                ops = install ? ops.add(pwRule) : ops.remove(pwRule);
            }
            this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

                public void onSuccess(FlowRuleOperations ops) {
                    Ofdpa3Pipeline.this.log.info("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)Ofdpa3Pipeline.this.deviceId);
                    OfdpaPipelineUtility.pass((Objective)filteringObjective);
                }

                public void onError(FlowRuleOperations ops) {
                    Ofdpa3Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)Ofdpa3Pipeline.this.deviceId);
                    OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
                }
            }));
        } else if (OfdpaPipelineUtility.isDoubleTagged(filteringObjective)) {
            this.processDoubleTaggedFilter(filteringObjective, install, applicationId);
        } else {
            super.processFilter(filteringObjective, install, applicationId);
        }
    }

    public boolean shouldRemoveDoubleTagged(Instruction meta) {
        Instructions.MetadataInstruction metadataInstruction = (Instructions.MetadataInstruction)meta;
        return (metadataInstruction.metadata() & metadataInstruction.metadataMask()) == 1L;
    }

    private void processDoubleTaggedFilter(final FilteringObjective filteringObjective, boolean install, ApplicationId applicationId) {
        PortCriterion portCriterion = null;
        EthCriterion ethCriterion = null;
        VlanIdCriterion innervidCriterion = null;
        VlanIdCriterion outerVidCriterion = null;
        boolean popVlan = false;
        boolean removeDoubleTagged = true;
        if (filteringObjective.meta().writeMetadata() != null) {
            removeDoubleTagged = this.shouldRemoveDoubleTagged((Instruction)filteringObjective.meta().writeMetadata());
        }
        this.log.info("HERE , removeDoubleTagged {}", (Object)removeDoubleTagged);
        TrafficTreatment meta = filteringObjective.meta();
        if (!filteringObjective.key().equals(Criteria.dummy()) && filteringObjective.key().type() == Criterion.Type.IN_PORT) {
            portCriterion = (PortCriterion)filteringObjective.key();
        }
        if (portCriterion == null) {
            this.log.warn("No IN_PORT defined in filtering objective from app: {}Failed to program VLAN tables.", (Object)applicationId);
            return;
        }
        this.log.debug("Received filtering objective for dev/port: {}/{}", (Object)this.deviceId, (Object)portCriterion.port());
        if (meta != null && meta.allInstructions().size() == 1) {
            L2ModificationInstruction l2Inst = (L2ModificationInstruction)meta.allInstructions().get(0);
            if (!l2Inst.subtype().equals((Object)L2ModificationInstruction.L2SubType.VLAN_POP)) {
                this.log.warn("Filtering objective can have only VLAN_POP instruction.");
                return;
            }
        } else {
            this.log.warn("Filtering objective should have one instruction.");
            return;
        }
        popVlan = true;
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        block5: for (Criterion criterion : filteringObjective.conditions()) {
            switch (criterion.type()) {
                case ETH_DST: 
                case ETH_DST_MASKED: {
                    ethCriterion = (EthCriterion)criterion;
                    continue block5;
                }
                case VLAN_VID: {
                    outerVidCriterion = (VlanIdCriterion)criterion;
                    continue block5;
                }
                case INNER_VLAN_VID: {
                    innervidCriterion = (VlanIdCriterion)criterion;
                    continue block5;
                }
            }
            this.log.warn("Unsupported filter {}", (Object)criterion);
            OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        if (innervidCriterion == null || outerVidCriterion == null) {
            this.log.warn("filtering objective should have two vidCriterion.");
            return;
        }
        if (ethCriterion == null || ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            this.log.warn("filtering objective missing dstMac, cannot program TMAC table");
            return;
        }
        MacAddress unicastMac = OfdpaPipelineUtility.readEthDstFromTreatment(filteringObjective.meta());
        List<List<FlowRule>> allStages = this.processEthDstFilter(portCriterion, ethCriterion, innervidCriterion, innervidCriterion.vlanId(), unicastMac, applicationId);
        for (List<FlowRule> flowRules : allStages) {
            this.log.trace("Starting a new flow rule stage for TMAC table flow");
            ops.newStage();
            for (FlowRule flowRule : flowRules) {
                this.log.trace("{} flow rules in TMAC table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRules, this.deviceId});
                if (install) {
                    ops = ops.add(flowRule);
                    continue;
                }
                if (this.matchInPortTmacTable() || filteringObjective.meta() != null && filteringObjective.meta().clearedDeferred()) {
                    if (filteringObjective.meta().writeMetadata() != null && !removeDoubleTagged) {
                        this.log.info("Skipping removal of tmac rule for device {}", (Object)this.deviceId);
                        continue;
                    }
                    ops = ops.remove(flowRule);
                    continue;
                }
                this.log.debug("Abort TMAC flow removal on {}. Some other ports still share this TMAC flow");
            }
        }
        List<FlowRule> rules = this.processDoubleVlanIdFilter(portCriterion, innervidCriterion, outerVidCriterion, popVlan, applicationId);
        for (FlowRule flowRule : rules) {
            this.log.trace("{} flow rule in VLAN table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRule, this.deviceId});
            if (flowRule.table().equals(IndexTableId.of((int)10)) && !removeDoubleTagged && !install) {
                this.log.info("Skipping removal of vlan table rule for now!");
                continue;
            }
            ops = install ? ops.add(flowRule) : ops.remove(flowRule);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                Ofdpa3Pipeline.this.log.debug("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)Ofdpa3Pipeline.this.deviceId);
                OfdpaPipelineUtility.pass((Objective)filteringObjective);
            }

            public void onError(FlowRuleOperations ops) {
                Ofdpa3Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)Ofdpa3Pipeline.this.deviceId);
                OfdpaPipelineUtility.fail((Objective)filteringObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private List<FlowRule> processDoubleVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion innerVidCriterion, VlanIdCriterion outerVidCriterion, boolean popVlan, ApplicationId applicationId) {
        TrafficSelector.Builder outerSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder outerTreatment = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder innerSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder innerTreatment = DefaultTrafficTreatment.builder();
        VlanId outerVlanId = outerVidCriterion.vlanId();
        VlanId innerVlanId = innerVidCriterion.vlanId();
        PortNumber portNumber = portCriterion.port();
        if (PortNumber.ALL.equals((Object)portNumber) || outerVlanId.equals((Object)VlanId.NONE) || innerVlanId.equals((Object)VlanId.NONE)) {
            this.log.warn("Incomplete Filtering Objective. VLAN Table cannot be programmed for {}", (Object)this.deviceId);
            return ImmutableList.of();
        }
        outerSelector.matchInPort(portNumber);
        innerSelector.matchInPort(portNumber);
        outerTreatment.transition(Integer.valueOf(11));
        innerTreatment.transition(Integer.valueOf(20));
        if (this.requireVlanExtensions()) {
            OfdpaMatchVlanVid ofdpaOuterMatchVlanVid = new OfdpaMatchVlanVid(outerVlanId);
            outerSelector.extension((ExtensionSelector)ofdpaOuterMatchVlanVid, this.deviceId);
            OfdpaMatchVlanVid ofdpaInnerMatchVlanVid = new OfdpaMatchVlanVid(innerVlanId);
            innerSelector.extension((ExtensionSelector)ofdpaInnerMatchVlanVid, this.deviceId);
        } else {
            outerSelector.matchVlanId(outerVlanId);
            innerSelector.matchVlanId(innerVlanId);
        }
        innerSelector.extension((ExtensionSelector)new Ofdpa3MatchOvid(outerVlanId), this.deviceId);
        outerTreatment.extension((ExtensionTreatment)new Ofdpa3SetOvid(outerVlanId), this.deviceId);
        if (popVlan) {
            outerTreatment.popVlan();
        }
        FlowRule outerRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(outerSelector.build()).withTreatment(outerTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
        FlowRule innerRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(innerSelector.build()).withTreatment(innerTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(11).build();
        return ImmutableList.of((Object)outerRule, (Object)innerRule);
    }

    private List<FlowRule> processPwFilter(PortCriterion portCriterion, VlanIdCriterion innerVlanIdCriterion, VlanIdCriterion outerVlanIdCriterion, long tunnelId, ApplicationId applicationId, VlanId egressVlan) {
        int mplsLogicalPort = (int)portCriterion.port().toLong();
        if (!innerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE) && !outerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE)) {
            this.log.info("Installing filter objective for double tagged CE for tunnel {}", (Object)tunnelId);
            TrafficSelector.Builder vlan1Selector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).matchVlanId(innerVlanIdCriterion.vlanId()).extension((ExtensionSelector)new Ofdpa3MatchOvid(outerVlanIdCriterion.vlanId()), this.deviceId);
            TrafficTreatment.Builder vlan1Treatment = DefaultTrafficTreatment.builder().pushVlan().setVlanId(egressVlan).extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId).extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId).setTunnelId(tunnelId).transition(Integer.valueOf(13));
            FlowRule vlan1FlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(vlan1Selector.build()).withTreatment(vlan1Treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(11).build();
            TrafficSelector.Builder vlanSelector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).matchVlanId(outerVlanIdCriterion.vlanId());
            TrafficTreatment.Builder vlanTreatment = DefaultTrafficTreatment.builder().popVlan().extension((ExtensionTreatment)new Ofdpa3SetOvid(outerVlanIdCriterion.vlanId()), this.deviceId).transition(Integer.valueOf(11));
            FlowRule vlanFlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(vlanSelector.build()).withTreatment(vlanTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            return ImmutableList.of((Object)vlan1FlowRule, (Object)vlanFlowRule);
        }
        if (!innerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE) && outerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE)) {
            this.log.info("Installing filter objective for single tagged CE for tunnel {}", (Object)tunnelId);
            TrafficSelector.Builder singleVlanSelector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).matchVlanId(innerVlanIdCriterion.vlanId());
            TrafficTreatment.Builder singleVlanTreatment = DefaultTrafficTreatment.builder().extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId).extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId).setTunnelId(tunnelId).transition(Integer.valueOf(13));
            FlowRule vlan1FlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(singleVlanSelector.build()).withTreatment(singleVlanTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            return ImmutableList.of((Object)vlan1FlowRule);
        }
        if (innerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE) && outerVlanIdCriterion.vlanId().equals((Object)VlanId.NONE)) {
            TrafficSelector.Builder singleVlanSelector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).matchVlanId(innerVlanIdCriterion.vlanId());
            TrafficTreatment.Builder singleVlanTreatment = DefaultTrafficTreatment.builder().extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId).extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId).setTunnelId(tunnelId).transition(Integer.valueOf(13));
            FlowRule vlan1FlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(singleVlanSelector.build()).withTreatment(singleVlanTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            return ImmutableList.of((Object)vlan1FlowRule);
        }
        return Collections.emptyList();
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        if (OfdpaPipelineUtility.isNotMplsBos(fwd.selector()) || OfdpaPipelineUtility.isMplsBos(fwd.selector()) && !OfdpaPipelineUtility.isMplsPop(fwd)) {
            return this.processEthTypeSpecificInternal(fwd, true, 29);
        }
        return this.processEthTypeSpecificInternal(fwd, true, 27);
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)fwd.selector().getCriterion(Criterion.Type.TUNNEL_ID);
        if (tunnelIdCriterion != null) {
            return this.processInitPwVersatile(fwd);
        }
        L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction = OfdpaPipelineUtility.getModTunnelIdInstruction(fwd.treatment());
        Instructions.OutputInstruction outputInstruction = OfdpaPipelineUtility.getOutputInstruction(fwd.treatment());
        if (modTunnelIdInstruction != null && outputInstruction != null) {
            return this.processTermPwVersatile(fwd, modTunnelIdInstruction, outputInstruction);
        }
        return super.processVersatile(fwd);
    }

    private Collection<FlowRule> processTermPwVersatile(ForwardingObjective forwardingObjective, L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction, Instructions.OutputInstruction outputInstruction) {
        TrafficTreatment.Builder mplsTreatment = DefaultTrafficTreatment.builder();
        this.createMplsTreatment(forwardingObjective.treatment(), mplsTreatment);
        TrafficSelector.Builder flowSelector = DefaultTrafficSelector.builder((TrafficSelector)forwardingObjective.selector());
        long tunnelId = 0x10000L | modTunnelIdInstruction.tunnelId();
        if (tunnelId > 131071L) {
            this.log.error("Pw Versatile Forwarding Objective must include tunnel id < {}", (Object)131071);
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        int mplsLogicalPort = (int)outputInstruction.port().toLong() | 0x20000;
        if (mplsLogicalPort > 196607) {
            this.log.error("Pw Versatile Forwarding Objective invalid logical port {}", (Object)mplsLogicalPort);
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (forwardingObjective.nextId() == null) {
            this.log.error("Pw Versatile Forwarding Objective must contain nextId ", (Object)forwardingObjective.nextId());
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        NextGroup next = this.getGroupForNextObjective(forwardingObjective.nextId());
        if (next == null) {
            this.log.warn("next-id:{} not found in dev:{}", (Object)forwardingObjective.nextId(), (Object)this.deviceId);
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        List gkeys = (List)appKryo.deserialize(next.data());
        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
        if (group == null) {
            this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), forwardingObjective.nextId(), this.deviceId});
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        TrafficTreatment.Builder flowTreatment = DefaultTrafficTreatment.builder((TrafficTreatment)mplsTreatment.build());
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3PopCw(), this.deviceId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3PopL2Header(), this.deviceId);
        flowTreatment.setTunnelId(tunnelId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId);
        flowTreatment.transition(Integer.valueOf(29));
        flowTreatment.deferred().group(group.id());
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(forwardingObjective.appId()).withPriority(forwardingObjective.priority()).forDevice(this.deviceId).withSelector(flowSelector.build()).withTreatment(flowTreatment.build()).makePermanent().forTable(24);
        return Collections.singletonList(ruleBuilder.build());
    }

    private Collection<FlowRule> processInitPwVersatile(ForwardingObjective forwardingObjective) {
        TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.TUNNEL_ID);
        PortCriterion portCriterion = (PortCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.IN_PORT);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        long tunnelId = 0x10000L | tunnelIdCriterion.tunnelId();
        if (tunnelId > 131071L) {
            this.log.error("Pw Versatile Forwarding Objective must include tunnel id < {}", (Object)131071);
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (portCriterion == null) {
            this.log.error("Pw Versatile Forwarding Objective must include port");
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (portCriterion.port().toLong() > 65535L) {
            this.log.error("Pw Versatile Forwarding Objective invalid logical port {}", (Object)portCriterion.port().toLong());
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        int mplsLogicalPort = (int)portCriterion.port().toLong();
        if (forwardingObjective.nextId() == null) {
            this.log.error("Pw Versatile Forwarding Objective must contain nextId ", (Object)forwardingObjective.nextId());
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (forwardingObjective.treatment() != null && !forwardingObjective.treatment().equals(DefaultTrafficTreatment.emptyTreatment())) {
            this.log.error("Pw Versatile Forwarding Objective cannot contain a treatment ", (Object)forwardingObjective.nextId());
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        NextGroup next = this.getGroupForNextObjective(forwardingObjective.nextId());
        if (next == null) {
            this.log.warn("next-id:{} not found in dev:{}", (Object)forwardingObjective.nextId(), (Object)this.deviceId);
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        List gkeys = (List)appKryo.deserialize(next.data());
        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
        if (group == null) {
            this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), forwardingObjective.nextId(), this.deviceId});
            OfdpaPipelineUtility.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        selector.matchTunnelId(tunnelId);
        selector.extension((ExtensionSelector)new Ofdpa3MatchMplsL2Port(mplsLogicalPort), this.deviceId);
        treatment.extension((ExtensionTreatment)new Ofdpa3SetQosIndex(0), this.deviceId);
        treatment.transition(Integer.valueOf(16));
        treatment.deferred().group(group.id());
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(forwardingObjective.appId()).withPriority(2).forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).makePermanent().forTable(13);
        return Collections.singletonList(ruleBuilder.build());
    }

    private void createMplsTreatment(TrafficTreatment treatment, TrafficTreatment.Builder mplsTreatment) {
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case TUNNEL_ID: {
                        break;
                    }
                    case DEC_MPLS_TTL: 
                    case MPLS_POP: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) break;
            if (ins.type() == Instruction.Type.L3MODIFICATION) {
                L3ModificationInstruction l3ins = (L3ModificationInstruction)ins;
                switch (l3ins.subtype()) {
                    case TTL_IN: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
        }
    }
}

