/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PicaPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    protected static final int IP_UNICAST_TABLE = 252;
    protected static final int ACL_TABLE = 0;
    private static final int DROP_PRIORITY = 0;
    private static final int HIGHEST_PRIORITY = 65535;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private CoreService coreService;
    private FlowObjectiveStore flowObjectiveStore;
    private DeviceId deviceId;
    private ApplicationId appId;
    private Collection<Filter> filters;
    private Collection<ForwardingObjective> pendingVersatiles;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{PicaGroup.class}).build("PicaPipeline");

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = context.store();
        this.filters = Collections.newSetFromMap(new ConcurrentHashMap());
        this.pendingVersatiles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.appId = this.coreService.registerApplication("org.onosproject.driver.OVSPicaPipeline");
        this.initializePipeline();
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(final ForwardingObjective fwd) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                PicaPipeline.this.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                PicaPipeline.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
                TrafficTreatment.Builder filteredTreatment = DefaultTrafficTreatment.builder();
                for (Instruction ins : treatment.allInstructions()) {
                    if (ins.type() == Instruction.Type.L2MODIFICATION) {
                        L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                        switch (l2ins.subtype()) {
                            case ETH_DST: {
                                filteredTreatment.setEthDst(((L2ModificationInstruction.ModEtherInstruction)l2ins).mac());
                                break;
                            }
                            case ETH_SRC: {
                                filteredTreatment.setEthSrc(((L2ModificationInstruction.ModEtherInstruction)l2ins).mac());
                                break;
                            }
                            case VLAN_ID: {
                                VlanId modVlanId = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                                filteredTreatment.setVlanId(modVlanId);
                                break;
                            }
                        }
                        continue;
                    }
                    if (ins.type() == Instruction.Type.OUTPUT) {
                        filteredTreatment.add(ins);
                        continue;
                    }
                    this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
                }
                this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new PicaGroup(filteredTreatment.build()));
                break;
            }
            case HASHED: 
            case BROADCAST: 
            case FAILOVER: {
                this.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                this.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    public void purgeAll(ApplicationId appId) {
        this.flowRuleService.purgeFlowRules(this.deviceId, appId);
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.debug("Processing versatile forwarding objective");
        TrafficSelector selector = fwd.selector();
        TrafficTreatment treatment = fwd.treatment();
        ArrayList<FlowRule> flowrules = new ArrayList<FlowRule>();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).withTreatment(treatment).withPriority(fwd.priority()).fromApp(fwd.appId()).makePermanent().forTable(0).build();
        flowrules.add(rule);
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.warn("No ethType in versatile forwarding obj. Not processing further.");
            return flowrules;
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_ARP) {
            if (this.filters.isEmpty()) {
                this.pendingVersatiles.add(fwd);
                return flowrules;
            }
            for (Filter filter : this.filters) {
                flowrules.addAll(this.processVersatilesWithFilters(filter, fwd));
            }
        }
        return flowrules;
    }

    private Collection<FlowRule> processVersatilesWithFilters(Filter filt, ForwardingObjective fwd) {
        ArrayList<FlowRule> flows = new ArrayList<FlowRule>();
        this.log.debug("adding ARP rule in ACL table");
        TrafficSelector.Builder sel = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
        sel.matchInPort(filt.port());
        sel.matchVlanId(filt.vlanId());
        sel.matchEthDst(filt.mac());
        sel.matchEthType(Ethernet.TYPE_ARP);
        treat.setOutput(PortNumber.CONTROLLER);
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sel.build()).withTreatment(treat.build()).withPriority(65535).fromApp(this.appId).makePermanent().forTable(0).build();
        flows.add(rule);
        sel = DefaultTrafficSelector.builder();
        treat = DefaultTrafficTreatment.builder();
        sel.matchInPort(filt.port());
        sel.matchVlanId(filt.vlanId());
        sel.matchEthDst(MacAddress.BROADCAST);
        sel.matchEthType(Ethernet.TYPE_ARP);
        treat.setOutput(PortNumber.CONTROLLER);
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sel.build()).withTreatment(treat.build()).withPriority(65535).fromApp(this.appId).makePermanent().forTable(0).build();
        flows.add(rule);
        return flows;
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific forwarding objective");
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4) {
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        ArrayList<FlowRule> ipflows = new ArrayList<FlowRule>();
        for (Filter f : this.filters) {
            TrafficSelector filteredSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip()).matchEthDst(f.mac()).matchVlanId(f.vlanId()).build();
            TrafficTreatment tt = null;
            if (fwd.nextId() != null) {
                NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
                if (next == null) {
                    this.log.error("next-id {} does not exist in store", (Object)fwd.nextId());
                    return Collections.emptySet();
                }
                tt = (TrafficTreatment)this.appKryo.deserialize(next.data());
                if (tt == null) {
                    this.log.error("Error in deserializing next-id {}", (Object)fwd.nextId());
                    return Collections.emptySet();
                }
            }
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(tt);
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            ruleBuilder.forTable(252);
            ipflows.add(ruleBuilder.build());
        }
        return ipflows;
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        PortCriterion p = (PortCriterion)filt.key();
        EthCriterion e = null;
        VlanIdCriterion v = null;
        ArrayList<IPCriterion> ips = new ArrayList<IPCriterion>();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion c : filt.conditions()) {
            if (c.type() == Criterion.Type.ETH_DST) {
                e = (EthCriterion)c;
                continue;
            }
            if (c.type() == Criterion.Type.VLAN_VID) {
                v = (VlanIdCriterion)c;
                continue;
            }
            if (c.type() == Criterion.Type.IPV4_DST) {
                ips.add((IPCriterion)c);
                continue;
            }
            this.log.error("Unsupported filter {}", (Object)c);
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
            return;
        }
        if (v == null || e == null) {
            this.log.warn("Pica Pipeline ETH_DST and/or VLAN_ID not specified");
            this.fail((Objective)filt, ObjectiveError.BADPARAMS);
            return;
        }
        Filter filter = new Filter(p, e, v, ips);
        this.filters.add(filter);
        for (ForwardingObjective fwd : this.pendingVersatiles) {
            Collection<FlowRule> ret = this.processVersatilesWithFilters(filter, fwd);
            for (FlowRule fr : ret) {
                ops.add(fr);
            }
        }
        for (IPCriterion ipaddr : ips) {
            this.log.debug("adding IP filtering rules in ACL table: {}", (Object)ipaddr.ip());
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(p.port());
            selector.matchVlanId(v.vlanId());
            selector.matchEthDst(e.mac());
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(ipaddr.ip());
            treatment.setOutput(PortNumber.CONTROLLER);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).fromApp(applicationId).makePermanent().forTable(0).build();
            ops = ops.add(rule);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                PicaPipeline.this.pass((Objective)filt);
                PicaPipeline.this.log.info("Applied filtering rules");
            }

            public void onError(FlowRuleOperations ops) {
                PicaPipeline.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
                PicaPipeline.this.log.info("Failed to apply filtering rules");
            }
        }));
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void initializePipeline() {
        this.processAclTable(true);
    }

    private void processAclTable(boolean install) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(0).build();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                PicaPipeline.this.log.info("Provisioned ACL table");
            }

            public void onError(FlowRuleOperations ops) {
                PicaPipeline.this.log.info("Failed to provision ACL table");
            }
        }));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private class PicaGroup
    implements NextGroup {
        TrafficTreatment nextActions;

        public PicaGroup(TrafficTreatment next) {
            this.nextActions = next;
        }

        public byte[] data() {
            return PicaPipeline.this.appKryo.serialize((Object)this.nextActions);
        }
    }

    private class Filter {
        private PortCriterion port;
        private VlanIdCriterion vlan;
        private EthCriterion eth;
        private Collection<IPCriterion> ips;

        public Filter(PortCriterion p, EthCriterion e, VlanIdCriterion v, Collection<IPCriterion> ips) {
            this.eth = e;
            this.port = p;
            this.vlan = v;
            this.ips = ips;
        }

        public PortNumber port() {
            return this.port.port();
        }

        public VlanId vlanId() {
            return this.vlan.vlanId();
        }

        public MacAddress mac() {
            return this.eth.mac();
        }
    }
}

