/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraSetTunnelDst;

public final class NiciraSetTunnelDstCodec
extends JsonCodec<NiciraSetTunnelDst> {
    private static final String TUNNEL_DST = "tunnelDst";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraSetTunnelDst";

    public ObjectNode encode(NiciraSetTunnelDst niciraSetTunnelDst, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraSetTunnelDst), (Object)"Nicira Set Tunnel DST cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(TUNNEL_DST, niciraSetTunnelDst.tunnelDst().toString());
        return root;
    }

    public NiciraSetTunnelDst decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        String dstIp = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TUNNEL_DST), (String)"tunnelDst member is required in NiciraSetTunnelDst")).asText();
        Ip4Address tunnelDst = Ip4Address.valueOf((String)dstIp);
        return new NiciraSetTunnelDst(tunnelDst);
    }
}

