/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentecV350Pipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    protected static final int PORT_VLAN_TABLE = 0;
    protected static final int FILTER_TABLE = 1;
    protected static final int MAC_TABLE = 2;
    protected static final int ROUTE_TABLE = 3;
    private static final long DEFAULT_METADATA = 100L;
    private static final long DEFAULT_METADATA_MASK = -1L;
    private static final int PORT_VLAN_TABLE_PRIORITY = 65535;
    private static final int FILTER_TABLE_CONTROLLER_PRIORITY = 500;
    private static final int FILTER_TABLE_TMAC_PRIORITY = 200;
    private static final int FILTER_TABLE_HIGHEST_PRIORITY = 65535;
    private static final int MAC_TABLE_PRIORITY = 65535;
    private static final int ROUTE_TABLE_PRIORITY = 65535;
    private static final short BGP_PORT = 179;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private CoreService coreService;
    private GroupService groupService;
    private FlowObjectiveStore flowObjectiveStore;
    private DeviceId deviceId;
    private ApplicationId appId;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{CentecV350Group.class}).register(new Class[]{byte[].class}).build("CentecV350Pipeline");
    private Cache<GroupKey, NextObjective> pendingGroups;
    private ScheduledExecutorService groupChecker = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"centec-V350-%d", (Logger)this.log));

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.fail((Objective)notification.getValue(), ObjectiveError.GROUPINSTALLATIONFAILED);
            }
        }).build();
        this.groupChecker.scheduleAtFixedRate(new GroupChecker(), 0L, 500L, TimeUnit.MILLISECONDS);
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.groupService.addListener((EventListener)new InnerGroupListener());
        this.appId = this.coreService.registerApplication("org.onosproject.driver.CentecV350Pipeline");
        this.initializePipeline();
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(final ForwardingObjective fwd) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CentecV350Pipeline.this.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                CentecV350Pipeline.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) break;
                TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
                TrafficTreatment.Builder treatmentWithoutPushVlan = DefaultTrafficTreatment.builder();
                for (Instruction ins : treatment.allInstructions()) {
                    if (ins.type() == Instruction.Type.L2MODIFICATION) {
                        L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                        switch (l2ins.subtype()) {
                            case ETH_DST: {
                                treatmentWithoutPushVlan.setEthDst(((L2ModificationInstruction.ModEtherInstruction)l2ins).mac());
                                break;
                            }
                            case ETH_SRC: {
                                treatmentWithoutPushVlan.setEthSrc(((L2ModificationInstruction.ModEtherInstruction)l2ins).mac());
                                break;
                            }
                            case VLAN_ID: {
                                VlanId modVlanId = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                                treatmentWithoutPushVlan.setVlanId(modVlanId);
                                break;
                            }
                        }
                        continue;
                    }
                    if (ins.type() == Instruction.Type.OUTPUT) {
                        treatmentWithoutPushVlan.add(ins);
                        continue;
                    }
                    this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
                }
                GroupBucket bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatmentWithoutPushVlan.build());
                DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
                DefaultGroupDescription groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, null, nextObjective.appId());
                this.groupService.addGroup((GroupDescription)groupDescription);
                this.pendingGroups.put((Object)key, (Object)nextObjective);
                break;
            }
            case HASHED: 
            case BROADCAST: 
            case FAILOVER: {
                this.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                this.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    public void purgeAll(ApplicationId appId) {
        this.flowRuleService.purgeFlowRules(this.deviceId, appId);
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.warn("Driver does not support versatile forwarding objective");
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return Collections.emptySet();
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific forwarding objective");
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4) {
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        TrafficSelector filteredSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchMetadata(100L).matchIPDst(((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip()).build();
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            GroupKey key = (GroupKey)this.appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, key);
            if (group == null) {
                this.log.warn("The group left!");
                this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            tb.group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(65535).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(tb.build());
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ruleBuilder.forTable(3);
        return Collections.singletonList(ruleBuilder.build());
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        PortCriterion p = (PortCriterion)filt.key();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion c : filt.conditions()) {
            FlowRule rule;
            TrafficTreatment.Builder treatment;
            TrafficSelector.Builder selector;
            if (c.type() == Criterion.Type.ETH_DST) {
                EthCriterion e = (EthCriterion)c;
                this.log.debug("adding rule for Termination MAC in Filter Table: {}", (Object)e.mac());
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchEthDst(e.mac());
                selector.matchEthType(Ethernet.TYPE_IPV4);
                treatment.transition(Integer.valueOf(2));
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(200).fromApp(applicationId).makePermanent().forTable(1).build();
                ops = install ? ops.add(rule) : ops.remove(rule);
                this.log.debug("adding rule for Termination MAC in MAC Table: {}", (Object)e.mac());
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchEthDst(e.mac());
                selector.matchMetadata(100L);
                treatment.transition(Integer.valueOf(3));
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).fromApp(applicationId).makePermanent().forTable(2).build();
                ops = install ? ops.add(rule) : ops.remove(rule);
                continue;
            }
            if (c.type() == Criterion.Type.VLAN_VID) {
                VlanIdCriterion v = (VlanIdCriterion)c;
                this.log.debug("adding rule for VLAN: {}", (Object)v.vlanId());
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchVlanId(v.vlanId());
                selector.matchInPort(p.port());
                treatment.writeMetadata(100L, -1L);
                treatment.transition(Integer.valueOf(1));
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).fromApp(applicationId).makePermanent().forTable(0).build();
                ops = install ? ops.add(rule) : ops.remove(rule);
                continue;
            }
            if (c.type() == Criterion.Type.IPV4_DST) {
                IPCriterion ipaddr = (IPCriterion)c;
                this.log.debug("adding IP filtering rules in FILTER table: {}", (Object)ipaddr.ip());
                selector = DefaultTrafficSelector.builder();
                treatment = DefaultTrafficTreatment.builder();
                selector.matchEthType(Ethernet.TYPE_IPV4);
                selector.matchIPDst(ipaddr.ip());
                treatment.setOutput(PortNumber.CONTROLLER);
                rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(500).fromApp(applicationId).makePermanent().forTable(1).build();
                ops = install ? ops.add(rule) : ops.remove(rule);
                continue;
            }
            this.log.warn("Driver does not currently process filtering condition of type: {}", (Object)c.type());
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CentecV350Pipeline.this.pass((Objective)filt);
                CentecV350Pipeline.this.log.info("Applied filtering rules");
            }

            public void onError(FlowRuleOperations ops) {
                CentecV350Pipeline.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
                CentecV350Pipeline.this.log.info("Failed to apply filtering rules");
            }
        }));
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void initializePipeline() {
        this.processPortVlanTable(true);
        this.processFilterTable(true);
    }

    private void processPortVlanTable(boolean install) {
    }

    private void processFilterTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        treatment.punt();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(500).fromApp(this.appId).makePermanent().forTable(1).build();
        ops = install ? ops.add(rule) : ops.remove(rule);
        selector = DefaultTrafficSelector.builder();
        treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)6).matchTcpSrc(TpPort.tpPort((int)179));
        treatment.punt();
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withPriority(65535).withSelector(selector.build()).withTreatment(treatment.build()).fromApp(this.appId).makePermanent().forTable(1).build();
        ops = install ? ops.add(rule) : ops.remove(rule);
        selector = DefaultTrafficSelector.builder();
        treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)6).matchTcpDst(TpPort.tpPort((int)179));
        treatment.punt();
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withPriority(65535).withSelector(selector.build()).withTreatment(treatment.build()).fromApp(this.appId).makePermanent().forTable(1).build();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CentecV350Pipeline.this.log.info("Provisioned filter table");
            }

            public void onError(FlowRuleOperations ops) {
                CentecV350Pipeline.this.log.info("Failed to provision filter table");
            }
        }));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private class CentecV350Group
    implements NextGroup {
        private final GroupKey key;

        public CentecV350Group(GroupKey key) {
            this.key = key;
        }

        public GroupKey key() {
            return this.key;
        }

        public byte[] data() {
            return CentecV350Pipeline.this.appKryo.serialize((Object)this.key);
        }
    }

    private class GroupChecker
    implements Runnable {
        private GroupChecker() {
        }

        @Override
        public void run() {
            Set<GroupKey> keys = CentecV350Pipeline.this.pendingGroups.asMap().keySet().stream().filter(key -> CentecV350Pipeline.this.groupService.getGroup(CentecV350Pipeline.this.deviceId, key) != null).collect(Collectors.toSet());
            keys.forEach(key -> {
                NextObjective obj = (NextObjective)CentecV350Pipeline.this.pendingGroups.getIfPresent(key);
                if (obj == null) {
                    return;
                }
                CentecV350Pipeline.this.pass((Objective)obj);
                CentecV350Pipeline.this.pendingGroups.invalidate(key);
                CentecV350Pipeline.this.log.info("Heard back from group service for group {}. Applying pending forwarding objectives", (Object)obj.id());
                CentecV350Pipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new CentecV350Group((GroupKey)key));
            });
        }
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            GroupKey key;
            NextObjective obj;
            if (event.type() == GroupEvent.Type.GROUP_ADDED && (obj = (NextObjective)CentecV350Pipeline.this.pendingGroups.getIfPresent((Object)(key = ((Group)event.subject()).appCookie()))) != null) {
                CentecV350Pipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new CentecV350Group(key));
                CentecV350Pipeline.this.pass((Objective)obj);
                CentecV350Pipeline.this.pendingGroups.invalidate((Object)key);
            }
        }
    }
}

