/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringOpenTTP
extends AbstractHandlerBehaviour
implements Pipeliner {
    private static final int CHECK_DELAY = 500;
    private static final int TABLE_VLAN = 0;
    private static final int TABLE_TMAC = 1;
    private static final int TABLE_IPV4_UNICAST = 2;
    private static final int TABLE_MPLS = 3;
    private static final int TABLE_DMAC = 4;
    private static final int TABLE_ACL = 5;
    private static final int TABLE_SMAC = 6;
    protected int vlanTableId = 0;
    protected int tmacTableId = 1;
    protected int ipv4UnicastTableId = 2;
    protected int mplsTableId = 3;
    protected int dstMacTableId = 4;
    protected int aclTableId = 5;
    protected int srcMacTableId = 6;
    private static final Logger log = LoggerFactory.getLogger(SpringOpenTTP.class);
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private CoreService coreService;
    protected GroupService groupService;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    private ApplicationId appId;
    private Cache<GroupKey, NextObjective> pendingGroups;
    private static final ScheduledExecutorService GROUP_CHECKER = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"spring-open-%d", (Logger)log));
    protected KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{TrafficTreatment.class}).register(new Class[]{SpringOpenGroup.class}).build("SpringOpenTTP");

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.fail((Objective)notification.getValue(), ObjectiveError.GROUPINSTALLATIONFAILED);
            }
        }).build();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.groupService.addListener((EventListener)new InnerGroupListener());
        this.appId = this.coreService.registerApplication("org.onosproject.driver.SpringOpenTTP");
        this.setTableMissEntries();
        log.info("Spring Open TTP driver initialized");
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            log.debug("processing PERMIT filter objective");
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            log.debug("filter objective other than PERMIT not supported");
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(final ForwardingObjective fwd) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                SpringOpenTTP.this.pass((Objective)fwd);
                log.debug("Provisioned tables in {} successfully with forwarding rules", (Object)SpringOpenTTP.this.deviceId);
            }

            public void onError(FlowRuleOperations ops) {
                SpringOpenTTP.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                log.warn("Failed to provision tables in {} with forwarding rules", (Object)SpringOpenTTP.this.deviceId);
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        NextGroup nextGroup = this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id()));
        switch (nextObjective.op()) {
            case ADD: {
                if (nextGroup != null) {
                    log.warn("Cannot add next {} that already exists in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                log.debug("Processing NextObjective id{} in dev{} - add group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.addGroup(nextObjective);
                break;
            }
            case ADD_TO_EXISTING: {
                if (nextGroup != null) {
                    log.debug("Processing NextObjective id{} in dev{} - add bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                    this.addBucketToGroup(nextObjective);
                    break;
                }
                log.warn("Cannot add to group that does not exist");
                break;
            }
            case REMOVE: {
                if (nextGroup == null) {
                    log.warn("Cannot remove next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                log.debug("Processing NextObjective id{}  in dev{} - remove group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.removeGroup(nextObjective);
                break;
            }
            case REMOVE_FROM_EXISTING: {
                if (nextGroup == null) {
                    log.warn("Cannot remove from next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                log.debug("Processing NextObjective id{} in dev{} - remove bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                this.removeBucketFromGroup(nextObjective);
                break;
            }
            default: {
                log.warn("Unsupported operation {}", (Object)nextObjective.op());
            }
        }
    }

    public void purgeAll(ApplicationId appId) {
        this.flowRuleService.purgeFlowRules(this.deviceId, appId);
        this.groupService.purgeGroupEntries(this.deviceId, appId);
    }

    private void removeGroup(NextObjective nextObjective) {
        log.debug("removeGroup in {}: for next objective id {}", (Object)this.deviceId, (Object)nextObjective.id());
        DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
        this.groupService.removeGroup(this.deviceId, (GroupKey)key, this.appId);
    }

    private void addGroup(NextObjective nextObjective) {
        log.debug("addGroup with type{} for nextObjective id {}", (Object)nextObjective.type(), (Object)nextObjective.id());
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) break;
                TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().iterator().next();
                log.debug("Converting SIMPLE group for next objective id {} to {} flow-actions in device:{}", new Object[]{nextObjective.id(), treatment.allInstructions().size(), this.deviceId});
                this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SpringOpenGroup(null, treatment));
                break;
            }
            case HASHED: {
                boolean mplsEcmp = false;
                if (nextObjective.meta() != null) {
                    for (Criterion c : nextObjective.meta().criteria()) {
                        if (c.type() != Criterion.Type.MPLS_LABEL) continue;
                        mplsEcmp = true;
                    }
                }
                if (mplsEcmp) {
                    log.debug("Converting HASHED group for next objective id {} to flow-actions in device:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                    TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().iterator().next();
                    this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SpringOpenGroup(null, treatment));
                    break;
                }
                List buckets = nextObjective.next().stream().map(DefaultGroupBucket::createSelectGroupBucket).collect(Collectors.toList());
                if (buckets.isEmpty()) break;
                DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
                DefaultGroupDescription groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(buckets), (GroupKey)key, null, nextObjective.appId());
                log.debug("Creating HASHED group for next objective id {} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                this.pendingGroups.put((Object)key, (Object)nextObjective);
                this.groupService.addGroup((GroupDescription)groupDescription);
                this.verifyPendingGroupLater();
                break;
            }
            case BROADCAST: {
                List buckets = nextObjective.next().stream().map(DefaultGroupBucket::createAllGroupBucket).collect(Collectors.toList());
                if (buckets.isEmpty()) break;
                DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
                DefaultGroupDescription groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(buckets), (GroupKey)key, null, nextObjective.appId());
                log.debug("Creating BROADCAST group for next objective id {} in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                this.pendingGroups.put((Object)key, (Object)nextObjective);
                this.groupService.addGroup((GroupDescription)groupDescription);
                this.verifyPendingGroupLater();
                break;
            }
            case FAILOVER: {
                log.debug("FAILOVER next objectives not supported");
                this.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                this.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void addBucketToGroup(NextObjective nextObjective) {
        GroupBucket bucket;
        log.debug("addBucketToGroup in {}: for next objective id {}", (Object)this.deviceId, (Object)nextObjective.id());
        Collection treatments = nextObjective.next();
        TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
        DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)key);
        if (group == null) {
            log.warn("Group is not found in {} for {}", (Object)this.deviceId, (Object)key);
            return;
        }
        if (group.type() == GroupDescription.Type.INDIRECT) {
            bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment);
        } else if (group.type() == GroupDescription.Type.SELECT) {
            bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)treatment);
        } else if (group.type() == GroupDescription.Type.ALL) {
            bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatment);
        } else {
            log.warn("Unsupported Group type {}", (Object)group.type());
            return;
        }
        GroupBuckets bucketsToAdd = new GroupBuckets(Collections.singletonList(bucket));
        log.debug("Adding buckets to group id {} of next objective id {} in device {}", new Object[]{group.id(), nextObjective.id(), this.deviceId});
        this.groupService.addBucketsToGroup(this.deviceId, (GroupKey)key, bucketsToAdd, (GroupKey)key, this.appId);
    }

    private void removeBucketFromGroup(NextObjective nextObjective) {
        log.debug("removeBucketFromGroup in {}: for next objective id {}", (Object)this.deviceId, (Object)nextObjective.id());
        NextGroup nextGroup = this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id()));
        if (nextGroup != null) {
            GroupBucket bucket;
            Collection treatments = nextObjective.next();
            TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
            DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)key);
            if (group == null) {
                log.warn("Group is not found in {} for {}", (Object)this.deviceId, (Object)key);
                return;
            }
            if (group.type() == GroupDescription.Type.INDIRECT) {
                bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment);
            } else if (group.type() == GroupDescription.Type.SELECT) {
                bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)treatment);
            } else if (group.type() == GroupDescription.Type.ALL) {
                bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatment);
            } else {
                log.warn("Unsupported Group type {}", (Object)group.type());
                return;
            }
            GroupBuckets removeBuckets = new GroupBuckets(Collections.singletonList(bucket));
            log.debug("Removing buckets from group id {} of next objective id {} in device {}", new Object[]{group.id(), nextObjective.id(), this.deviceId});
            this.groupService.removeBucketsFromGroup(this.deviceId, (GroupKey)key, removeBuckets, (GroupKey)key, this.appId);
        }
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        NextGroup next;
        log.debug("Processing versatile forwarding objective in dev:{}", (Object)this.deviceId);
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            log.error("Versatile forwarding objective must include ethType");
            this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
            return Collections.emptySet();
        }
        if (fwd.treatment() == null && fwd.nextId() == null) {
            log.error("VERSATILE forwarding objective needs next objective ID or treatment.");
            return Collections.emptySet();
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        treatmentBuilder.wipeDeferred();
        if (fwd.nextId() != null && (next = this.flowObjectiveStore.getNextGroup(fwd.nextId())) != null) {
            SpringOpenGroup soGroup = (SpringOpenGroup)this.appKryo.deserialize(next.data());
            if (soGroup.dummy) {
                for (Instruction ins : soGroup.treatment.allInstructions()) {
                    treatmentBuilder.add(ins);
                }
            } else {
                GroupKey key = soGroup.key;
                Group group = this.groupService.getGroup(this.deviceId, key);
                if (group == null) {
                    log.warn("The group left!");
                    this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                    return Collections.emptySet();
                }
                treatmentBuilder.deferred().group(group.id());
                log.debug("Adding OUTGROUP action");
            }
        }
        if (fwd.treatment() != null) {
            if (fwd.treatment().allInstructions().size() == 1 && ((Instruction)fwd.treatment().allInstructions().get(0)).type() == Instruction.Type.OUTPUT) {
                Instructions.OutputInstruction o = (Instructions.OutputInstruction)fwd.treatment().allInstructions().get(0);
                if (o.port() == PortNumber.CONTROLLER) {
                    treatmentBuilder.popVlan();
                    treatmentBuilder.punt();
                } else {
                    treatmentBuilder.add((Instruction)o);
                }
            } else {
                for (Instruction ins : fwd.treatment().allInstructions()) {
                    treatmentBuilder.add(ins);
                }
            }
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(fwd.selector()).withTreatment(treatmentBuilder.build());
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ruleBuilder.forTable(this.aclTableId);
        return Collections.singletonList(ruleBuilder.build());
    }

    private boolean isSupportedEthTypeObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        return ethType != null && (ethType.ethType().toShort() == Ethernet.TYPE_IPV4 || ethType.ethType().toShort() == Ethernet.MPLS_UNICAST);
    }

    private boolean isSupportedEthDstObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthCriterion ethDst = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanId = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        return ethDst != null || vlanId != null;
    }

    protected Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        log.debug("Processing specific fwd objective:{} in dev:{} with next:{}", new Object[]{fwd.id(), this.deviceId, fwd.nextId()});
        boolean isEthTypeObj = this.isSupportedEthTypeObjective(fwd);
        boolean isEthDstObj = this.isSupportedEthDstObjective(fwd);
        if (isEthTypeObj) {
            return this.processEthTypeSpecificObjective(fwd);
        }
        if (isEthDstObj) {
            return this.processEthDstSpecificObjective(fwd);
        }
        log.warn("processSpecific: Unsupported forwarding objective criteria");
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return Collections.emptySet();
    }

    protected Collection<FlowRule> processEthTypeSpecificObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        int forTableId = -1;
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            filteredSelectorBuilder = filteredSelectorBuilder.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip());
            forTableId = this.ipv4UnicastTableId;
            log.debug("processing IPv4 specific forwarding objective:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
        } else {
            filteredSelectorBuilder = filteredSelectorBuilder.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            if (selector.getCriterion(Criterion.Type.MPLS_BOS) != null) {
                filteredSelectorBuilder.matchMplsBos(((MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS)).mplsBos());
            }
            forTableId = this.mplsTableId;
            log.debug("processing MPLS specific forwarding objective:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction i : fwd.treatment().allInstructions()) {
                treatmentBuilder.add(i);
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            if (next != null) {
                SpringOpenGroup soGroup = (SpringOpenGroup)this.appKryo.deserialize(next.data());
                if (soGroup.dummy) {
                    log.debug("Adding {} flow-actions for fwd. obj. {} -> next:{} in dev: {}", new Object[]{soGroup.treatment.allInstructions().size(), fwd.id(), fwd.nextId(), this.deviceId});
                    for (Instruction ins : soGroup.treatment.allInstructions()) {
                        treatmentBuilder.add(ins);
                    }
                } else {
                    GroupKey key = soGroup.key;
                    Group group = this.groupService.getGroup(this.deviceId, key);
                    if (group == null) {
                        log.warn("The group left!");
                        this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                        return Collections.emptySet();
                    }
                    treatmentBuilder.deferred().group(group.id());
                    log.debug("Adding OUTGROUP action to group:{} for fwd. obj. {} for next:{} in dev: {}", new Object[]{group.id(), fwd.id(), fwd.nextId(), this.deviceId});
                }
            } else {
                log.warn("processSpecific: No associated next objective object");
                this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        TrafficTreatment treatment = treatmentBuilder.transition(Integer.valueOf(this.aclTableId)).build();
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(treatment);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ruleBuilder.forTable(forTableId);
        return Collections.singletonList(ruleBuilder.build());
    }

    protected Collection<FlowRule> processEthDstSpecificObjective(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            log.debug("processing L2 forwarding objective:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
        } else {
            log.debug("processing L2 Broadcast forwarding objective:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        filteredSelectorBuilder.matchVlanId(vlanIdCriterion.vlanId());
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            treatmentBuilder.deferred();
            fwd.treatment().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
        }
        if (fwd.nextId() != null && (next = this.flowObjectiveStore.getNextGroup(fwd.nextId())) != null) {
            SpringOpenGroup soGrp = (SpringOpenGroup)this.appKryo.deserialize(next.data());
            if (soGrp.dummy) {
                log.debug("Adding {} flow-actions for fwd. obj. {} in dev: {}", new Object[]{soGrp.treatment.allInstructions().size(), fwd.id(), this.deviceId});
                for (Instruction ins : soGrp.treatment.allInstructions()) {
                    treatmentBuilder.deferred().add(ins);
                }
            } else {
                GroupKey key = soGrp.key;
                Group group = this.groupService.getGroup(this.deviceId, key);
                if (group == null) {
                    log.warn("The group left!");
                    this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                    return Collections.emptySet();
                }
                treatmentBuilder.deferred().group(group.id());
                log.debug("Adding OUTGROUP action to group:{} for fwd. obj. {} in dev: {}", new Object[]{group.id(), fwd.id(), this.deviceId});
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(this.aclTableId));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(this.dstMacTableId);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    protected List<FlowRule> processEthDstFilter(EthCriterion ethCriterion, VlanIdCriterion vlanIdCriterion, FilteringObjective filt, VlanId assignedVlan, ApplicationId applicationId) {
        if (vlanIdCriterion == null) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId, filt.priority());
        }
        if (vlanIdCriterion.vlanId() == VlanId.NONE) {
            vlanIdCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selectorIp = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatmentIp = DefaultTrafficTreatment.builder();
        selectorIp.matchEthDst(ethCriterion.mac());
        selectorIp.matchEthType(Ethernet.TYPE_IPV4);
        selectorIp.matchVlanId(vlanIdCriterion.vlanId());
        treatmentIp.popVlan();
        treatmentIp.transition(Integer.valueOf(this.ipv4UnicastTableId));
        FlowRule ruleIp = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selectorIp.build()).withTreatment(treatmentIp.build()).withPriority(filt.priority()).fromApp(applicationId).makePermanent().forTable(this.tmacTableId).build();
        log.debug("adding IP ETH rule for MAC: {}", (Object)ethCriterion.mac());
        rules.add(ruleIp);
        TrafficSelector.Builder selectorMpls = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatmentMpls = DefaultTrafficTreatment.builder();
        selectorMpls.matchEthDst(ethCriterion.mac());
        selectorMpls.matchEthType(Ethernet.MPLS_UNICAST);
        selectorMpls.matchVlanId(vlanIdCriterion.vlanId());
        treatmentMpls.popVlan();
        treatmentMpls.transition(Integer.valueOf(this.mplsTableId));
        FlowRule ruleMpls = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selectorMpls.build()).withTreatment(treatmentMpls.build()).withPriority(filt.priority()).fromApp(applicationId).makePermanent().forTable(this.tmacTableId).build();
        log.debug("adding MPLS ETH rule for MAC: {}", (Object)ethCriterion.mac());
        rules.add(ruleMpls);
        return rules;
    }

    protected List<FlowRule> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId, int priority) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(2));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(priority).fromApp(applicationId).makePermanent().forTable(1).build();
        return ImmutableList.builder().add((Object)rule).build();
    }

    protected List<FlowRule> processVlanIdFilter(VlanIdCriterion vlanIdCriterion, FilteringObjective filt, VlanId assignedVlan, VlanId explicitlyAssignedVlan, VlanId pushedVlan, boolean pushVlan, boolean popVlan, ApplicationId applicationId) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        log.debug("adding rule for VLAN: {}", (Object)vlanIdCriterion.vlanId());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        PortCriterion p = (PortCriterion)filt.key();
        if (vlanIdCriterion.vlanId() != VlanId.NONE) {
            selector.matchVlanId(vlanIdCriterion.vlanId());
            selector.matchInPort(p.port());
            if (popVlan) {
                treatment.immediate().popVlan();
            }
            if (!(explicitlyAssignedVlan == null || popVlan && vlanIdCriterion.vlanId().equals((Object)assignedVlan))) {
                treatment.immediate().setVlanId(explicitlyAssignedVlan);
            }
            if (pushVlan) {
                treatment.immediate().pushVlan().setVlanId(pushedVlan);
            }
        } else {
            selector.matchInPort(p.port());
            treatment.immediate().pushVlan().setVlanId(assignedVlan);
        }
        treatment.transition(Integer.valueOf(this.tmacTableId));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(filt.priority()).fromApp(applicationId).makePermanent().forTable(this.vlanTableId).build();
        rules.add(rule);
        return rules;
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        EthCriterion ethCriterion = null;
        VlanIdCriterion vlanIdCriterion = null;
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion criterion : filt.conditions()) {
            if (criterion.type() == Criterion.Type.ETH_DST) {
                ethCriterion = (EthCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.VLAN_VID) {
                vlanIdCriterion = (VlanIdCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.IPV4_DST) {
                log.debug("driver does not process IP filtering rules as it sends all misses in the IP table to the controller");
                continue;
            }
            log.warn("Driver does not currently process filtering condition of type: {}", (Object)criterion.type());
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
        }
        VlanId assignedVlan = null;
        VlanId modifiedVlan = null;
        VlanId pushedVlan = null;
        boolean pushVlan = false;
        boolean popVlan = false;
        if (vlanIdCriterion != null) {
            if (filt.meta() != null) {
                for (Instruction i : filt.meta().allInstructions()) {
                    if (i instanceof L2ModificationInstruction) {
                        if (((L2ModificationInstruction)i).subtype().equals((Object)L2ModificationInstruction.L2SubType.VLAN_PUSH)) {
                            pushVlan = true;
                        } else if (((L2ModificationInstruction)i).subtype().equals((Object)L2ModificationInstruction.L2SubType.VLAN_POP)) {
                            if (modifiedVlan != null) {
                                log.error("Pop tag is not allowed after modify VLAN operation in filtering objective", (Object)this.deviceId);
                                this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                                return;
                            }
                            popVlan = true;
                        }
                    }
                    if (!(i instanceof L2ModificationInstruction.ModVlanIdInstruction)) continue;
                    if (pushVlan && vlanIdCriterion.vlanId() != VlanId.NONE) {
                        if (pushedVlan != null) {
                            log.error("Modify VLAN not allowed after push tag operation in filtering objective", (Object)this.deviceId);
                            this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                            return;
                        }
                        pushedVlan = ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
                        continue;
                    }
                    if (vlanIdCriterion.vlanId() == VlanId.NONE) {
                        assignedVlan = ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
                        continue;
                    }
                    if (modifiedVlan != null) {
                        log.error("Driver does not allow multiple modify VLAN operations in the same filtering objective", (Object)this.deviceId);
                        this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                        return;
                    }
                    modifiedVlan = ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
                }
            }
            if (vlanIdCriterion.vlanId() != VlanId.NONE) {
                if (assignedVlan == null) {
                    assignedVlan = vlanIdCriterion.vlanId();
                }
            } else {
                if (filt.meta() == null) {
                    log.error("Missing metadata in filtering objective required for vlan assignment in dev {}", (Object)this.deviceId);
                    this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                    return;
                }
                if (assignedVlan == null) {
                    log.error("Driver requires an assigned vlan-id to tag incoming untagged packets. Not processing vlan filters on device {}", (Object)this.deviceId);
                    this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                    return;
                }
            }
            if (pushVlan && popVlan) {
                log.error("Cannot push and pop vlan in the same filtering objective");
                this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                return;
            }
            if (popVlan && vlanIdCriterion.vlanId() == VlanId.NONE) {
                log.error("Cannot pop vlan for untagged packets");
                this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                return;
            }
            if (pushVlan && pushedVlan == null && vlanIdCriterion.vlanId() != VlanId.NONE) {
                log.error("No VLAN ID provided for push tag operation");
                this.fail((Objective)filt, ObjectiveError.BADPARAMS);
                return;
            }
        }
        if (ethCriterion == null) {
            log.debug("filtering objective missing dstMac, cannot program TMAC table");
        } else {
            for (FlowRule tmacRule : this.processEthDstFilter(ethCriterion, vlanIdCriterion, filt, assignedVlan, applicationId)) {
                log.debug("adding MAC filtering rules in TMAC table: {} for dev: {}", (Object)tmacRule, (Object)this.deviceId);
                ops = install ? ops.add(tmacRule) : ops.remove(tmacRule);
            }
        }
        if (vlanIdCriterion == null) {
            log.debug("filtering objective missing VLAN ID criterion, cannot program VLAN Table");
        } else {
            for (FlowRule vlanRule : this.processVlanIdFilter(vlanIdCriterion, filt, assignedVlan, modifiedVlan, pushedVlan, pushVlan, popVlan, applicationId)) {
                log.debug("adding VLAN filtering rule in VLAN table: {} for dev: {}", (Object)vlanRule, (Object)this.deviceId);
                ops = install ? ops.add(vlanRule) : ops.remove(vlanRule);
            }
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                SpringOpenTTP.this.pass((Objective)filt);
                log.debug("Provisioned tables in {} with fitering rules", (Object)SpringOpenTTP.this.deviceId);
            }

            public void onError(FlowRuleOperations ops) {
                SpringOpenTTP.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
                log.warn("Failed to provision tables in {} with fitering rules", (Object)SpringOpenTTP.this.deviceId);
            }
        }));
    }

    protected void setTableMissEntries() {
        this.populateTableMissEntry(this.vlanTableId, true, false, false, -1);
        this.populateTableMissEntry(this.tmacTableId, false, false, true, this.dstMacTableId);
        this.populateTableMissEntry(this.ipv4UnicastTableId, false, true, true, this.aclTableId);
        this.populateTableMissEntry(this.mplsTableId, false, true, true, this.aclTableId);
        this.populateTableMissEntry(this.dstMacTableId, false, false, true, this.aclTableId);
        this.populateTableMissEntry(this.aclTableId, false, false, false, -1);
    }

    protected void populateTableMissEntry(int tableToAdd, boolean toControllerNow, boolean toControllerWrite, boolean toTable, int tableToSend) {
        TrafficSelector selector = DefaultTrafficSelector.builder().build();
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        if (toControllerNow) {
            tBuilder.setOutput(PortNumber.CONTROLLER);
        }
        if (toControllerWrite) {
            tBuilder.deferred().setOutput(PortNumber.CONTROLLER);
        }
        if (toTable) {
            tBuilder.transition(Integer.valueOf(tableToSend));
        }
        FlowRule flow = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).withTreatment(tBuilder.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(tableToAdd).build();
        this.flowRuleService.applyFlowRules(new FlowRule[]{flow});
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    protected void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void verifyPendingGroupLater() {
        GROUP_CHECKER.schedule(new GroupChecker(), 500L, TimeUnit.MILLISECONDS);
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    static {
        if (GROUP_CHECKER instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)GROUP_CHECKER;
            executor.setKeepAliveTime(1000L, TimeUnit.MILLISECONDS);
            executor.allowCoreThreadTimeOut(true);
        }
    }

    protected class SpringOpenGroup
    implements NextGroup {
        private final boolean dummy;
        private final GroupKey key;
        private final TrafficTreatment treatment;

        public SpringOpenGroup(GroupKey key, TrafficTreatment treatment) {
            if (key == null) {
                this.key = new DefaultGroupKey(new byte[]{0});
                this.treatment = treatment;
                this.dummy = true;
            } else {
                this.key = key;
                this.treatment = DefaultTrafficTreatment.builder().build();
                this.dummy = false;
            }
        }

        public GroupKey key() {
            return this.key;
        }

        public boolean dummy() {
            return this.dummy;
        }

        public TrafficTreatment treatment() {
            return this.treatment;
        }

        public byte[] data() {
            return SpringOpenTTP.this.appKryo.serialize((Object)this);
        }
    }

    private class GroupChecker
    implements Runnable {
        private GroupChecker() {
        }

        @Override
        public void run() {
            Set<GroupKey> keys = SpringOpenTTP.this.pendingGroups.asMap().keySet().stream().filter(key -> SpringOpenTTP.this.groupService.getGroup(SpringOpenTTP.this.deviceId, key) != null).collect(Collectors.toSet());
            keys.forEach(key -> {
                NextObjective obj = (NextObjective)SpringOpenTTP.this.pendingGroups.getIfPresent(key);
                if (obj == null) {
                    return;
                }
                log.debug("Group verified: dev:{} gid:{} <<->> nextId:{}", new Object[]{SpringOpenTTP.this.deviceId, SpringOpenTTP.this.groupService.getGroup(SpringOpenTTP.this.deviceId, key).id(), obj.id()});
                SpringOpenTTP.this.pass((Objective)obj);
                SpringOpenTTP.this.pendingGroups.invalidate(key);
                SpringOpenTTP.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new SpringOpenGroup((GroupKey)key, null));
            });
            if (!SpringOpenTTP.this.pendingGroups.asMap().isEmpty()) {
                SpringOpenTTP.this.verifyPendingGroupLater();
            }
        }
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            if (event.type() == GroupEvent.Type.GROUP_ADDED) {
                log.trace("InnerGroupListener: Group ADDED event received in device {}", (Object)SpringOpenTTP.this.deviceId);
                GroupKey key = ((Group)event.subject()).appCookie();
                NextObjective obj = (NextObjective)SpringOpenTTP.this.pendingGroups.getIfPresent((Object)key);
                if (obj != null) {
                    log.debug("Group verified: dev:{} gid:{} <<->> nextId:{}", new Object[]{SpringOpenTTP.this.deviceId, ((Group)event.subject()).id(), obj.id()});
                    SpringOpenTTP.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new SpringOpenGroup(key, null));
                    SpringOpenTTP.this.pass((Objective)obj);
                    SpringOpenTTP.this.pendingGroups.invalidate((Object)key);
                }
            } else if (event.type() == GroupEvent.Type.GROUP_ADD_FAILED) {
                log.warn("InnerGroupListener: Group ADD failed event received in device {}", (Object)SpringOpenTTP.this.deviceId);
            }
        }
    }
}

