/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.packet.IpAddress;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfDeviceMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionMock;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.ctl.NetconfControllerImpl;

class FujitsuNetconfControllerMock
extends NetconfControllerImpl {
    private static final String VOLT_DRIVER_NAME = "fujitsu-volt-netconf";
    private static final String VOLT_DEVICE_USERNAME = "abc";
    private static final String VOLT_DEVICE_PASSWORD = "123";
    private static final String VOLT_DEVICE_IP = "10.10.10.11";
    private static final int VOLT_DEVICE_PORT = 830;
    private Map<DeviceId, NetconfDevice> netconfDeviceMap = new ConcurrentHashMap<DeviceId, NetconfDevice>();

    FujitsuNetconfControllerMock() {
    }

    public NetconfDevice getNetconfDevice(DeviceId deviceInfo) {
        return this.netconfDeviceMap.get(deviceInfo);
    }

    public NetconfDevice getNetconfDevice(IpAddress ip, int port) {
        for (DeviceId info : this.netconfDeviceMap.keySet()) {
            if (!info.uri().getSchemeSpecificPart().equals(ip.toString() + ":" + port)) continue;
            return this.netconfDeviceMap.get(info);
        }
        return null;
    }

    public NetconfDevice connectDevice(DeviceId deviceId) throws NetconfException {
        int port;
        String ip;
        if (this.netconfDeviceMap.containsKey(deviceId)) {
            log.debug("Device {} is already present", (Object)deviceId);
            return this.netconfDeviceMap.get(deviceId);
        }
        log.debug("Creating NETCONF device {}", (Object)deviceId);
        String[] info = deviceId.toString().split(":");
        if (info.length == 3) {
            ip = info[1];
            port = Integer.parseInt(info[2]);
        } else {
            ip = Arrays.asList(info).stream().filter(el -> !el.equals(info[0]) && !el.equals(info[info.length - 1])).reduce((t, u) -> t + ":" + u).get();
            log.debug("ip v6 {}", (Object)ip);
            port = Integer.parseInt(info[info.length - 1]);
        }
        try {
            NetconfDeviceInfo deviceInfo = new NetconfDeviceInfo(VOLT_DEVICE_USERNAME, VOLT_DEVICE_PASSWORD, IpAddress.valueOf((String)ip), port);
            FujitsuNetconfDeviceMock netconfDevice = new FujitsuNetconfDeviceMock(deviceInfo);
            this.netconfDeviceMap.put(deviceInfo.getDeviceId(), netconfDevice);
            return netconfDevice;
        }
        catch (NullPointerException e) {
            throw new NetconfException("Cannot connect a device " + deviceId, (Throwable)e);
        }
    }

    public void disconnectDevice(DeviceId deviceId, boolean remove) {
        if (!this.netconfDeviceMap.containsKey(deviceId)) {
            log.warn("Device {} is not present", (Object)deviceId);
        } else {
            this.netconfDeviceMap.remove(deviceId);
        }
    }

    public Map<DeviceId, NetconfDevice> getDevicesMap() {
        return this.netconfDeviceMap;
    }

    public Set<DeviceId> getNetconfDevices() {
        return this.netconfDeviceMap.keySet();
    }

    public void removeDevice(DeviceId deviceId) {
        if (!this.netconfDeviceMap.containsKey(deviceId)) {
            log.warn("Device {} is not present", (Object)deviceId);
        } else {
            this.netconfDeviceMap.remove(deviceId);
        }
    }

    public FujitsuDriverHandlerAdapter setUp(FujitsuNetconfSessionListenerTest listener) throws NetconfException {
        try {
            NetconfDeviceInfo deviceInfo = new NetconfDeviceInfo(VOLT_DEVICE_USERNAME, VOLT_DEVICE_PASSWORD, IpAddress.valueOf((String)VOLT_DEVICE_IP), 830);
            NetconfDevice netconfDevice = this.connectDevice(deviceInfo.getDeviceId());
            FujitsuNetconfSessionMock session = (FujitsuNetconfSessionMock)netconfDevice.getSession();
            session.setListener(listener);
            DeviceId deviceId = deviceInfo.getDeviceId();
            DefaultDriver driver = new DefaultDriver(VOLT_DRIVER_NAME, new ArrayList(), "Fujitsu", "1.0", "1.0", (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
            DefaultDriverData driverData = new DefaultDriverData((Driver)driver, deviceId);
            FujitsuDriverHandlerAdapter driverHandler = new FujitsuDriverHandlerAdapter((DriverData)driverData);
            driverHandler.setUp((NetconfController)this);
            return driverHandler;
        }
        catch (NetconfException e) {
            throw new NetconfException("Cannot create a device ", (Throwable)e);
        }
    }
}

