/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.device.OchPortHelper;
import org.onosproject.net.optical.device.OduCltPortHelper;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuT100DeviceDescription
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DeviceDescription discoverDeviceDetails() {
        this.log.info("No description to be added for device");
        return null;
    }

    public List<PortDescription> discoverPortDetails() {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.get(this.requestBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        List<PortDescription> descriptions = FujitsuT100DeviceDescription.parseFujitsuT100Ports(XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes())));
        return ImmutableList.copyOf(descriptions);
    }

    private String requestBuilder() {
        StringBuilder rpc = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter type=\"subtree\">");
        rpc.append("<interfaces xmlns=\"urn:ietf:params:xml:ns:yang:ietf-interfaces\">");
        rpc.append("</interfaces>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    private static List<PortDescription> parseFujitsuT100Ports(HierarchicalConfiguration cfg) {
        AtomicInteger counter = new AtomicInteger(1);
        ArrayList portDescriptions = Lists.newArrayList();
        List subtrees = cfg.configurationsAt("data.interfaces.interface");
        for (HierarchicalConfiguration portConfig : subtrees) {
            if (!portConfig.getString("name").contains("LCN") && !portConfig.getString("name").contains("LMP") && portConfig.getString("type").equals("ianaift:ethernetCsmacd")) {
                portDescriptions.add(FujitsuT100DeviceDescription.parseT100OduPort(portConfig, counter.getAndIncrement()));
                continue;
            }
            if (!portConfig.getString("type").equals("ianaift:otnOtu")) continue;
            portDescriptions.add(FujitsuT100DeviceDescription.parseT100OchPort(portConfig, counter.getAndIncrement()));
        }
        return portDescriptions;
    }

    private static PortDescription parseT100OchPort(HierarchicalConfiguration cfg, long count) {
        PortNumber portNumber = PortNumber.portNumber((long)count);
        SubnodeConfiguration otuConfig = cfg.configurationAt("otu");
        boolean enabled = otuConfig.getString("administrative-state").equals("up");
        OduSignalType signalType = otuConfig.getString("rate").equals("OTU4") ? OduSignalType.ODU4 : null;
        boolean isTunable = true;
        OchSignal lambda = new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, 0, 4);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", cfg.getString("name")).build();
        return OchPortHelper.ochPortDescription((PortNumber)portNumber, (boolean)enabled, (OduSignalType)signalType, (boolean)isTunable, (OchSignal)lambda, (SparseAnnotations)annotations);
    }

    private static PortDescription parseT100OduPort(HierarchicalConfiguration cfg, long count) {
        PortNumber portNumber = PortNumber.portNumber((long)count);
        SubnodeConfiguration ethernetConfig = cfg.configurationAt("ethernet");
        boolean enabled = ethernetConfig.getString("administrative-state").equals("up");
        CltSignalType signalType = ethernetConfig.getString("rate").equals("100000000") ? CltSignalType.CLT_100GBE : null;
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", cfg.getString("name")).build();
        return OduCltPortHelper.oduCltPortDescription((PortNumber)portNumber, (boolean)enabled, (CltSignalType)signalType, (SparseAnnotations)annotations);
    }
}

