/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltFwdlConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltFwdlConfig
extends AbstractHandlerBehaviour
implements VoltFwdlConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltFwdlConfig.class);
    private static final String ONDEMAND_FIRMWARE_UPGRADE = "ondemand-firmware-upgrade";
    private static final String PARTICIPANT_LIST = "participant-list";
    private static final String MEMBER = "member";
    private static final String IMAGE_NAME = "image-name";
    private static final String REBOOT_MODE = "reboot-mode";
    private int pon;
    private int onu;

    @Override
    public String upgradeFirmwareOndemand(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        String[] data = target.split(":");
        if (data.length < 2 || data.length > 3) {
            this.log.error("Invalid number of arguments");
            return reply;
        }
        String[] onuList = data[1].split(",");
        if (onuList.length == 0) {
            this.log.error("No ONU listed");
            return reply;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<").append(ONDEMAND_FIRMWARE_UPGRADE).append(" ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(PARTICIPANT_LIST));
            for (int count = 0; count < onuList.length; ++count) {
                String[] onuId = onuList[count].split("-");
                if (onuId.length != 2) {
                    this.log.error("Invalid ONU identifier");
                    return reply;
                }
                try {
                    this.pon = Integer.parseInt(onuId[0]);
                    this.onu = Integer.parseInt(onuId[1]);
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input");
                    return reply;
                }
                request.append(FujitsuVoltXmlUtility.buildStartTag(MEMBER));
                request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id"));
                request.append(onuId[0]);
                request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id"));
                request.append(onuId[1]);
                request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                request.append(FujitsuVoltXmlUtility.buildEndTag(MEMBER));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(PARTICIPANT_LIST));
            request.append(FujitsuVoltXmlUtility.buildStartTag(IMAGE_NAME));
            request.append(data[0]);
            request.append(FujitsuVoltXmlUtility.buildEndTag(IMAGE_NAME));
            if (data.length == 3) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(REBOOT_MODE));
                request.append(data[2]);
                request.append(FujitsuVoltXmlUtility.buildEndTag(REBOOT_MODE));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONDEMAND_FIRMWARE_UPGRADE));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }
}

