/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltOnuConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltOnuConfig
extends AbstractHandlerBehaviour
implements VoltOnuConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltOnuConfig.class);
    private final Set<String> onuConfigParams = ImmutableSet.of((Object)"admin-state", (Object)"pm-enable", (Object)"fec-enable", (Object)"security-enable", (Object)"password");
    private static final String VOLT_ONUS = "volt-onus";
    private static final String ONUS_PERLINK = "onus-perlink";
    private static final String ONUS_LIST = "onus-list";
    private static final String ONU_INFO = "onu-info";
    private static final String ONU_SET_CONFIG = "onu-set-config";
    private static final String CONFIG_INFO = "config-info";
    private static final String VOLT_STATISTICS = "volt-statistics";
    private static final String ONU_STATISTICS = "onu-statistics";
    private static final String ONU_ETH_STATS = "onu-eth-stats";
    private static final String ETH_STATS = "eth-stats";
    private static final String ONU_GEM_STATS = "onu-gem-stats";
    private static final String GEM_STATS = "gem-stats";
    private int pon;
    private int onu;

    @Override
    public String getOnus(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        if (target != null) {
            onuId = target.split("-");
            if (onuId.length > 2) {
                this.log.error("Invalid number of arguments");
                return reply;
            }
            try {
                this.pon = Integer.parseInt(onuId[0]);
                if (onuId.length > 1) {
                    this.onu = Integer.parseInt(onuId[1]);
                }
            }
            catch (NumberFormatException e) {
                this.log.error("Non-number input");
                return reply;
            }
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne ").append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">").append("\n");
            if (onuId != null) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_ONUS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONUS_PERLINK));
                request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
                request.append(onuId[0]);
                request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag(ONUS_LIST));
                    request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_INFO));
                    request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
                    request.append(onuId[1]);
                    request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                    request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_INFO));
                    request.append(FujitsuVoltXmlUtility.buildEndTag(ONUS_LIST));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(ONUS_PERLINK));
                request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_ONUS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(VOLT_ONUS));
            }
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String setOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        String[] data = target.split(":");
        if (data.length != 3) {
            this.log.error("Invalid number of arguments");
            return reply;
        }
        String[] onuId = data[0].split("-");
        if (onuId.length != 2) {
            this.log.error("Invalid ONU identifier");
            return reply;
        }
        try {
            this.pon = Integer.parseInt(onuId[0]);
            this.onu = Integer.parseInt(onuId[1]);
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input");
            return reply;
        }
        if (!this.onuConfigParams.contains(data[1])) {
            this.log.error("Unsupported parameter: " + data[1]);
            return reply;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<").append(ONU_SET_CONFIG).append(" ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
            request.append(onuId[0]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
            request.append(onuId[1]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag(CONFIG_INFO));
            request.append(FujitsuVoltXmlUtility.buildStartTag(data[1], false));
            request.append(data[2]);
            request.append(FujitsuVoltXmlUtility.buildEndTag(data[1]));
            request.append(FujitsuVoltXmlUtility.buildEndTag(CONFIG_INFO));
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_SET_CONFIG));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String getOnuStatistics(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        if (target != null) {
            onuId = target.split("-");
            if (onuId.length > 2) {
                this.log.error("Invalid number of arguments:" + onuId.length);
                return reply;
            }
            try {
                this.pon = Integer.parseInt(onuId[0]);
                if (onuId.length > 1) {
                    this.onu = Integer.parseInt(onuId[1]);
                }
            }
            catch (NumberFormatException e) {
                this.log.error("Non-number input");
                return reply;
            }
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne ").append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_STATISTICS));
            if (onuId != null) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_STATISTICS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_GEM_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(GEM_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
                request.append(onuId[0]);
                request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
                    request.append(onuId[1]);
                    request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(GEM_STATS));
                request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_GEM_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_ETH_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(ETH_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
                request.append(onuId[0]);
                request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
                    request.append(onuId[1]);
                    request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(ETH_STATS));
                request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_ETH_STATS));
                request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_STATISTICS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(ONU_STATISTICS));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_STATISTICS));
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }
}

