/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltOnuOperConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltOnuOperConfig
extends AbstractHandlerBehaviour
implements VoltOnuOperConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltOnuOperConfig.class);
    private static final String ONU_REBOOT = "onu-reboot";
    private static final String ONU_ETHPORT_LOOPBACK = "onu-ethport-loopback";
    private static final String ETHPORT_ID = "ethport-id";
    private int pon;
    private int onu;
    private int eth;

    @Override
    public String rebootOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        onuId = target.split("-");
        if (onuId.length != 2) {
            this.log.error("Invalid number of arguments");
            return reply;
        }
        try {
            this.pon = Integer.parseInt(onuId[0]);
            this.onu = Integer.parseInt(onuId[1]);
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input");
            return reply;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<").append(ONU_REBOOT).append(" ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
            request.append(onuId[0]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
            request.append(onuId[1]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_REBOOT));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String loopbackEthOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] ethId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        ethId = target.split("-");
        if (ethId.length != 3) {
            this.log.error("Invalid number of arguments");
            return reply;
        }
        try {
            this.pon = Integer.parseInt(ethId[0]);
            this.onu = Integer.parseInt(ethId[1]);
            this.eth = Integer.parseInt(ethId[2]);
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input");
            return reply;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<").append(ONU_ETHPORT_LOOPBACK).append(" ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
            request.append(ethId[0]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false));
            request.append(ethId[1]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag(ETHPORT_ID, false));
            request.append(ethId[2]);
            request.append(FujitsuVoltXmlUtility.buildEndTag(ETHPORT_ID));
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_ETHPORT_LOOPBACK));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }
}

