/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltPonLinkConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltPonLinkConfig
extends AbstractHandlerBehaviour
implements VoltPonLinkConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltPonLinkConfig.class);
    private final Set<String> ponLinkParams = ImmutableSet.of((Object)"admin-state", (Object)"onu-discovery-mode", (Object)"onu-discovery-interval", (Object)"dba-cycle-time", (Object)"mac-age-time", (Object)"lof-threshold", (Object[])new String[]{"los-threshold", "pm-enable"});
    private static final String VOLT_PORTS = "volt-ports";
    private static final String GPON_PONLINK_PORTS = "gpon-ponlink-ports";
    private static final String GPON_PONLINK_PORT = "gpon-ponlink-port";
    private int pon;

    @Override
    public String getPonLinks(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return reply;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne ").append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS));
            if (target != null) {
                try {
                    this.pon = Integer.parseInt(target);
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input");
                    return reply;
                }
                request.append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORTS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORT));
                request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
                request.append(target);
                request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                request.append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORT));
                request.append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORTS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(GPON_PONLINK_PORTS));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS));
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public void setPonLink(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return;
        }
        String[] data = target.split(":");
        if (data.length != 3) {
            this.log.error("Invalid number of arguments");
            return;
        }
        try {
            this.pon = Integer.parseInt(data[0]);
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input");
            return;
        }
        if (!this.ponLinkParams.contains(data[1])) {
            this.log.error("Unsupported parameter: {} ", (Object)data[1]);
            return;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne ").append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">").append("\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS));
            request.append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORTS));
            request.append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORT));
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false));
            request.append(data[0]);
            request.append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
            request.append(FujitsuVoltXmlUtility.buildStartTag(data[1], false));
            request.append(data[2]);
            request.append(FujitsuVoltXmlUtility.buildEndTag(data[1]));
            request.append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORT));
            request.append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORTS));
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS));
            request.append("</volt-ne>");
            ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().editConfig("running", null, request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception ", (Object)ncDeviceId, (Object)e);
        }
    }
}

