/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.drivers.fujitsu.behaviour.VoltOnuOperConfig;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="volt-ethloopback", description="Operates/releases loopback on Ethernet port of an ONU in vOLT")
public class VoltEthLoopbackCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="target", description="PON link ID-ONU ID-Eth port ID[:(operate:release)]", required=true, multiValued=false)
    String target = null;
    private DeviceId deviceId;

    protected void execute() {
        DriverService service = (DriverService)VoltEthLoopbackCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        VoltOnuOperConfig volt = (VoltOnuOperConfig)h.behaviour(VoltOnuOperConfig.class);
        String reply = volt.loopbackEthOnu(this.target);
        if (reply != null) {
            this.print("%s", new Object[]{reply});
        } else {
            this.print("No reply from %s", new Object[]{this.deviceId.toString()});
        }
    }
}

