/*
 * Copyright 2016-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import org.onosproject.net.intent.IntentCompilationException;

/**
 * An exception thrown when an optical intent compilation fails.
 */
public class OpticalIntentCompilationException extends IntentCompilationException {

    private static final long serialVersionUID = 2538096696847181373L;

    public OpticalIntentCompilationException() {
        super();
    }

    public OpticalIntentCompilationException(String message) {
        super(message);
    }

    public OpticalIntentCompilationException(String message, Throwable cause) {
        super(message, cause);
    }
}
