/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltOnuConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltOnuConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListenerTest();
    private static final String TEST_VOLT_ONUS = "volt-onus";
    private static final String TEST_ONUS_PERLINK = "onus-perlink";
    private static final String TEST_ONUS_LIST = "onus-list";
    private static final String TEST_ONU_INFO = "onu-info";
    private static final String TEST_ONU_SET_CONFIG = "onu-set-config";
    private static final String TEST_CONFIG_INFO = "config-info";
    private static final String TEST_VOLT_STATISTICS = "volt-statistics";
    private static final String TEST_ONU_STATISTICS = "onu-statistics";
    private static final String TEST_ONU_ETH_STATS = "onu-eth-stats";
    private static final String TEST_ETH_STATS = "eth-stats";
    private static final String TEST_ONU_GEM_STATS = "onu-gem-stats";
    private static final String TEST_GEM_STATS = "gem-stats";
    private static final String TEST_ONU_SET_CONFIG_WITH_NAMESPACE = "<onu-set-config xmlns=\"http://fujitsu.com/ns/volt/1.1\"";
    private static final String[] INVALID_GET_TCS = new String[]{"a-b", "--1-2", "s-1", "16-1-1", "1 A-1", "1*A-1"};
    private static final String[] VALID_GET_TCS = new String[]{"1", "1-2", null};
    private static final String[] INVALID_SET_TCS = new String[]{"-11-3:admin-state:enable", "1-2:admin-state:false", "1-2:pm-enable:123", "^1-2:pm-enable:false", "1-2:fec-enable:xyz", "1-2:security-enable:123abc", "2-3:password:-1&", "2:admin-state:disable"};
    private static final String[] VALID_SET_TCS = new String[]{"1-11:admin-state:disable", "8-1:pm-enable:true", "1-1:fec-enable:true", "1-21:security-enable:false", "3-2:password:abc123"};
    private static final String[] INVALID_GET_STATS_TCS = new String[]{"1-a", "1:1", "a-1", "1-1-1", "2 A-1", "2/A-1"};
    private static final String[] VALID_GET_STATS_TCS = new String[]{"1", "3-12", null};
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltOnuConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltOnuConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testInvalidGetOnusInput() throws Exception {
        for (int i = 0; i < INVALID_GET_TCS.length; ++i) {
            String target = INVALID_GET_TCS[i];
            String reply = this.voltConfig.getOnus(target);
            Assert.assertNull((String)"Incorrect response for INVALID_GET_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidGetOnus() throws Exception {
        for (int i = 0; i < VALID_GET_TCS.length; ++i) {
            String target = VALID_GET_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.getOnus(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_GET_TCS", (Object)reply);
        }
    }

    @Test
    public void testInvalidSetOnuInput() throws Exception {
        for (int i = 0; i < INVALID_SET_TCS.length; ++i) {
            String target = INVALID_SET_TCS[i];
            String reply = this.voltConfig.setOnu(target);
            Assert.assertNull((String)"Incorrect response for INVALID_SET_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidSetOnu() throws Exception {
        for (int i = 0; i < VALID_SET_TCS.length; ++i) {
            String target = VALID_SET_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.setOnu(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_SET_TCS", (Object)reply);
        }
    }

    @Test
    public void testInvalidGetOnuStatsInput() throws Exception {
        for (int i = 0; i < INVALID_GET_STATS_TCS.length; ++i) {
            String target = INVALID_GET_STATS_TCS[i];
            String reply = this.voltConfig.getOnuStatistics(target);
            Assert.assertNull((String)"Incorrect response for INVALID_GET_STATS_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidGetOnuStats() throws Exception {
        for (int i = 0; i < VALID_GET_STATS_TCS.length; ++i) {
            String target = VALID_GET_STATS_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.getOnuStatistics(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_GET_STATS_TCS", (Object)reply);
        }
    }

    private boolean verifyGetRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_GET_TCS[this.currentKey];
        String[] onuId = null;
        if (target != null) {
            onuId = target.split("-");
        }
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        if (onuId != null) {
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_ONUS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONUS_PERLINK)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id"));
            if (onuId.length > 1) {
                rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONUS_LIST)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONU_INFO)).append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id")).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_INFO)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONUS_LIST));
            }
            rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONUS_PERLINK)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_ONUS));
        } else {
            rpc.append(FujitsuVoltXmlUtilityMock.emptyTag(TEST_VOLT_ONUS));
        }
        rpc.append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyWrappedRpcRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_SET_TCS[this.currentKey];
        String[] data = target.split(":");
        String[] onuId = data[0].split("-");
        rpc.append("<onu-set-config ");
        rpc.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id")).append(FujitsuVoltXmlUtilityMock.startTag(TEST_CONFIG_INFO)).append(FujitsuVoltXmlUtilityMock.startTag(data[1], false)).append(data[2]).append(FujitsuVoltXmlUtilityMock.endTag(data[1])).append(FujitsuVoltXmlUtilityMock.endTag(TEST_CONFIG_INFO)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_SET_CONFIG));
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyGetRequestForStats(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_GET_STATS_TCS[this.currentKey];
        String[] onuId = null;
        if (target != null) {
            onuId = target.split("-");
        }
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_STATISTICS));
        if (onuId != null) {
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONU_STATISTICS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONU_GEM_STATS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_GEM_STATS)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id"));
            if (onuId.length > 1) {
                rpc.append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id"));
            }
            rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_GEM_STATS)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_GEM_STATS));
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_ONU_ETH_STATS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ETH_STATS)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id"));
            if (onuId.length > 1) {
                rpc.append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id"));
            }
            rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_ETH_STATS)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_ETH_STATS)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_STATISTICS));
        } else {
            rpc.append(FujitsuVoltXmlUtilityMock.emptyTag(TEST_ONU_STATISTICS));
        }
        rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_STATISTICS)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private class InternalSessionListenerTest
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListenerTest() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            return false;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            Assert.assertTrue((String)"Incorrect withDefaultsMode", (boolean)withDefaultsMode.equals("report-all"));
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean forStats = filterSchema.contains(FujitsuVoltOnuConfigTest.TEST_VOLT_STATISTICS);
            boolean result = forStats ? FujitsuVoltOnuConfigTest.this.verifyGetRequestForStats(filterSchema) : FujitsuVoltOnuConfigTest.this.verifyGetRequest(filterSchema);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            request = request.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<onu-set-config xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains(FujitsuVoltOnuConfigTest.TEST_ONU_SET_CONFIG_WITH_NAMESPACE));
            boolean result = FujitsuVoltOnuConfigTest.this.verifyWrappedRpcRequest(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

