/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltPonLinkConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltPonLinkConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListenerTest();
    private static final String TEST_VOLT_PORTS = "volt-ports";
    private static final String TEST_GPON_PONLINK_PORTS = "gpon-ponlink-ports";
    private static final String TEST_GPON_PONLINK_PORT = "gpon-ponlink-port";
    private static final String[] INVALID_GET_TCS = new String[]{"a-b-c", "--1", "s-1", "1-1", "1 A", "1*A"};
    private static final String[] VALID_GET_TCS = new String[]{"1", null};
    private static final String[] INVALID_SET_TCS = new String[]{"-11:admin-state:enable", "1:admin-state:false", "2-1:onu-discovery-mode:manual", "2:onu-discovery-mode:abcdef", "3:a:onu-discovery-interval:8", "3:onu-discovery-interval:-1", "3:onu-discovery-interval:s1", "4:dba-cycle-time:41", "5*8:mac-age-time:30000", "8:mac-age-time:3699999", "1:lof-threshold:111", "2:los-threshold:22", "3:pm-enable:xyz", "3:abc-enable:xyz"};
    private static final String[] VALID_SET_TCS = new String[]{"1:admin-state:disable", "2:onu-discovery-mode:manual", "3:onu-discovery-interval:8", "4:dba-cycle-time:8", "5:mac-age-time:33333", "6:lof-threshold:7", "7:los-threshold:5", "8:pm-enable:true"};
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltPonLinkConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltPonLinkConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testInvalidGetPonLinksInput() throws Exception {
        for (int i = 0; i < INVALID_GET_TCS.length; ++i) {
            String target = INVALID_GET_TCS[i];
            String reply = this.voltConfig.getPonLinks(target);
            Assert.assertNull((String)"Incorrect response for INVALID_GET_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidGetPonLinks() throws Exception {
        for (int i = 0; i < VALID_GET_TCS.length; ++i) {
            String target = VALID_GET_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.getPonLinks(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_GET_TCS", (Object)reply);
        }
    }

    @Test
    public void testInvalidSetPonLinkInput() throws Exception {
        for (int i = 0; i < INVALID_SET_TCS.length; ++i) {
            String target = INVALID_SET_TCS[i];
            boolean result = this.voltConfig.setPonLink(target);
            Assert.assertFalse((String)"Incorrect response for INVALID_SET_TCS", (boolean)result);
        }
    }

    @Test
    public void testValidSetPonLink() throws Exception {
        for (int i = 0; i < VALID_SET_TCS.length; ++i) {
            String target = VALID_SET_TCS[i];
            this.currentKey = i;
            boolean result = this.voltConfig.setPonLink(target);
            Assert.assertTrue((String)"Incorrect response for VALID_SET_TCS", (boolean)result);
        }
    }

    private boolean verifyGetRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_GET_TCS[this.currentKey];
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_PORTS));
        if (target != null) {
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(target).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.endTag(TEST_GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_GPON_PONLINK_PORTS));
        } else {
            rpc.append(FujitsuVoltXmlUtilityMock.emptyTag(TEST_GPON_PONLINK_PORTS));
        }
        rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_PORTS)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyEditConfigRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_SET_TCS[this.currentKey];
        String[] data = target.split(":");
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_PORTS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(data[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.startTag(data[1], false)).append(data[2]).append(FujitsuVoltXmlUtilityMock.endTag(data[1])).append(FujitsuVoltXmlUtilityMock.endTag(TEST_GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_PORTS)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private class InternalSessionListenerTest
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListenerTest() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            Assert.assertTrue((String)"Incorrect target", (boolean)target.equals("running"));
            Assert.assertNull((String)"Incorrect mode", (Object)mode);
            request = request.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltPonLinkConfigTest.this.verifyEditConfigRequest(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            Assert.assertTrue((String)"Incorrect withDefaultsMode", (boolean)withDefaultsMode.equals("report-all"));
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltPonLinkConfigTest.this.verifyGetRequest(filterSchema);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            return false;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

