/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltFwdlConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltFwdlConfig
extends AbstractHandlerBehaviour
implements VoltFwdlConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltFwdlConfig.class);
    private static final String ONDEMAND_FIRMWARE_UPGRADE = "ondemand-firmware-upgrade";
    private static final String PARTICIPANT_LIST = "participant-list";
    private static final String MEMBER = "member";
    private static final String IMAGE_NAME = "image-name";
    private static final String REBOOT_MODE = "reboot-mode";
    private static final String AUTO = "auto";
    private static final String COMMA = ",";

    @Override
    public String upgradeFirmwareOndemand(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        String[] data = target.split(":");
        if (data.length < 2 || data.length > 3) {
            this.log.error("Invalid number of arguments");
            return null;
        }
        String[] onuList = data[1].split(COMMA);
        if (onuList.length == 0) {
            this.log.error("No ONU listed");
            return null;
        }
        if (data.length > 2 && !AUTO.equals(data[2])) {
            this.log.error("Invalid reboot-mode {}", (Object)data[2]);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<ondemand-firmware-upgrade ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(PARTICIPANT_LIST));
            for (int count = 0; count < onuList.length; ++count) {
                String[] onuId = onuList[count].split("-");
                if (onuId.length != 2) {
                    this.log.error("Invalid ONU identifier");
                    return null;
                }
                try {
                    int pon = Integer.parseInt(onuId[0]);
                    if (pon <= 0) {
                        this.log.error("Invalid integer for ponlink-id:{}", (Object)onuId[0]);
                        return null;
                    }
                    int onu = Integer.parseInt(onuId[1]);
                    if (onu <= 0) {
                        this.log.error("Invalid integer for onu-id:{}", (Object)onuId[1]);
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input");
                    return null;
                }
                request.append(FujitsuVoltXmlUtility.buildStartTag(MEMBER)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id")).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildStartTag("onu-id")).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id")).append(FujitsuVoltXmlUtility.buildEndTag(MEMBER));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(PARTICIPANT_LIST)).append(FujitsuVoltXmlUtility.buildStartTag(IMAGE_NAME)).append(data[0]).append(FujitsuVoltXmlUtility.buildEndTag(IMAGE_NAME));
            if (data.length == 3) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(REBOOT_MODE)).append(data[2]).append(FujitsuVoltXmlUtility.buildEndTag(REBOOT_MODE));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONDEMAND_FIRMWARE_UPGRADE));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }
}

