/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.onosproject.drivers.fujitsu.behaviour.VoltNeConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltNeConfig
extends AbstractHandlerBehaviour
implements VoltNeConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltNeConfig.class);

    @Override
    public String getAll() {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }
}

