/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltOnuConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltOnuConfig
extends AbstractHandlerBehaviour
implements VoltOnuConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltOnuConfig.class);
    private static final String ADMIN_STATE = "admin-state";
    private static final String PASSWORD = "password";
    private static final Set<String> ONUCONFIGPARAMS = ImmutableSet.of((Object)"admin-state", (Object)"pm-enable", (Object)"fec-enable", (Object)"security-enable", (Object)"password");
    private static final Set<String> ADMINSTATES = ImmutableSet.of((Object)"enable", (Object)"disable");
    private static final Set<String> ENABLES = ImmutableSet.of((Object)"true", (Object)"false");
    private static final String VOLT_ONUS = "volt-onus";
    private static final String ONUS_PERLINK = "onus-perlink";
    private static final String ONUS_LIST = "onus-list";
    private static final String ONU_INFO = "onu-info";
    private static final String ONU_SET_CONFIG = "onu-set-config";
    private static final String CONFIG_INFO = "config-info";
    private static final String VOLT_STATISTICS = "volt-statistics";
    private static final String ONU_STATISTICS = "onu-statistics";
    private static final String ONU_ETH_STATS = "onu-eth-stats";
    private static final String ETH_STATS = "eth-stats";
    private static final String ONU_GEM_STATS = "onu-gem-stats";
    private static final String GEM_STATS = "gem-stats";
    private static final String PASSWORD_PATTERN = "^[a-zA-Z0-9]+$";

    @Override
    public String getOnus(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        if (target != null && (onuId = this.checkIdString(target)) == null) {
            this.log.error("Invalid ONU identifier {}", (Object)target);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            if (onuId != null) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_ONUS)).append(FujitsuVoltXmlUtility.buildStartTag(ONUS_PERLINK)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag(ONUS_LIST)).append(FujitsuVoltXmlUtility.buildStartTag(ONU_INFO)).append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id")).append(FujitsuVoltXmlUtility.buildEndTag(ONU_INFO)).append(FujitsuVoltXmlUtility.buildEndTag(ONUS_LIST));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(ONUS_PERLINK)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_ONUS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(VOLT_ONUS));
            }
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String setOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        String[] data = target.split(":");
        if (data.length != 3) {
            this.log.error("Invalid number of arguments");
            return null;
        }
        String[] onuId = this.checkIdString(data[0]);
        if (onuId == null || onuId.length != 2) {
            this.log.error("Invalid ONU identifier {}", (Object)target);
            return null;
        }
        if (!this.checkSetParam(data[1], data[2])) {
            this.log.error("Failed to check input {}", (Object)target);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<onu-set-config ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id")).append(FujitsuVoltXmlUtility.buildStartTag(CONFIG_INFO)).append(FujitsuVoltXmlUtility.buildStartTag(data[1], false)).append(data[2]).append(FujitsuVoltXmlUtility.buildEndTag(data[1])).append(FujitsuVoltXmlUtility.buildEndTag(CONFIG_INFO)).append(FujitsuVoltXmlUtility.buildEndTag(ONU_SET_CONFIG));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String getOnuStatistics(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        if (target != null && (onuId = this.checkIdString(target)) == null) {
            this.log.error("Failed to check ID: {}", (Object)target);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_STATISTICS));
            if (onuId != null) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_STATISTICS)).append(FujitsuVoltXmlUtility.buildStartTag(ONU_GEM_STATS)).append(FujitsuVoltXmlUtility.buildStartTag(GEM_STATS)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(GEM_STATS)).append(FujitsuVoltXmlUtility.buildEndTag(ONU_GEM_STATS));
                request.append(FujitsuVoltXmlUtility.buildStartTag(ONU_ETH_STATS)).append(FujitsuVoltXmlUtility.buildStartTag(ETH_STATS)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id"));
                if (onuId.length > 1) {
                    request.append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id"));
                }
                request.append(FujitsuVoltXmlUtility.buildEndTag(ETH_STATS)).append(FujitsuVoltXmlUtility.buildEndTag(ONU_ETH_STATS)).append(FujitsuVoltXmlUtility.buildEndTag(ONU_STATISTICS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(ONU_STATISTICS));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_STATISTICS)).append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    private String[] checkIdString(String target) {
        String[] onuId = target.split("-");
        if (onuId.length > 2) {
            this.log.error("Invalid number of arguments for id:{}", (Object)onuId.length);
            return null;
        }
        try {
            int onu;
            int pon = Integer.parseInt(onuId[0]);
            if (pon <= 0) {
                this.log.error("Invalid integer for ponlink-id:{}", (Object)onuId[0]);
                return null;
            }
            if (onuId.length > 1 && (onu = Integer.parseInt(onuId[1])) <= 0) {
                this.log.error("Invalid integer for onu-id:{}", (Object)onuId[1]);
                return null;
            }
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input for id:{}", (Object)target);
            return null;
        }
        return onuId;
    }

    private boolean checkSetParam(String name, String value) {
        if (!ONUCONFIGPARAMS.contains(name)) {
            this.log.error("Unsupported parameter: {}", (Object)name);
            return false;
        }
        switch (name) {
            case "admin-state": {
                if (this.validState(ADMINSTATES, name, value)) break;
                return false;
            }
            case "password": {
                if (value.matches(PASSWORD_PATTERN)) break;
                this.log.error("Invalid value for Name {} : Value {}.", (Object)name, (Object)value);
                return false;
            }
            default: {
                if (this.validState(ENABLES, name, value)) break;
                return false;
            }
        }
        return true;
    }

    private boolean validState(Set<String> states, String name, String value) {
        if (!states.contains(value)) {
            this.log.error("Invalid value for Name {} : Value {}.", (Object)name, (Object)value);
            return false;
        }
        return true;
    }
}

