/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltAlertConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltAlertConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListener();
    private static final String TEST_VOLT_ALERTS = "volt-alerts";
    private static final String TEST_ALERT_FILTER = "alert-filter";
    private static final String TEST_NOTIFY_ALERT = "notify-alert";
    private static final String TEST_NOTIFY_ALERT_WITH_NAMESPACE = "<notify-alert xmlns=\"http://fujitsu.com/ns/volt/1.1\"";
    private static final String NOTIFY_ALERT_FILE = "/notifyalert.xml";
    private static final String[] INVALID_SET_TCS = new String[]{":abc", "@critical", "1234"};
    private static final String[] VALID_SET_TCS = new String[]{"minor", "critical", "none", "info", "major"};
    private static final String[] VERIFY_NOTIFY_ALERT_FILE_TCS = new String[]{"notify-alert", "alert-seqnum", "alert-type", "alert-clear", "severity", "resource-id", "ponlink-id", "alert-time", "date", "time"};
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltAlertConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltAlertConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testSubscribe() throws Exception {
        Assert.assertTrue((String)"Incorrect response", (boolean)this.voltConfig.subscribe(null));
        Assert.assertFalse((String)"Incorrect response", (boolean)this.voltConfig.subscribe("false"));
        Assert.assertTrue((String)"Incorrect response", (boolean)this.voltConfig.subscribe("disable"));
    }

    @Test
    public void testGetAlertFilter() throws Exception {
        this.voltConfig.getAlertFilter();
    }

    @Test
    public void testInvalidSetAlertFilterInput() throws Exception {
        for (int i = 0; i < INVALID_SET_TCS.length; ++i) {
            String target = INVALID_SET_TCS[i];
            boolean result = this.voltConfig.setAlertFilter(target);
            Assert.assertFalse((String)"Incorrect response for ", (boolean)result);
        }
    }

    @Test
    public void testValidSetAlertFilter() throws Exception {
        for (int i = 0; i < VALID_SET_TCS.length; ++i) {
            String target = VALID_SET_TCS[i];
            this.currentKey = i;
            boolean result = this.voltConfig.setAlertFilter(target);
            Assert.assertTrue((String)"Incorrect response for ", (boolean)result);
        }
    }

    @Test
    public void testNotifyAlert() throws Exception {
        boolean result = this.verifyNotifyAlert();
        Assert.assertTrue((String)"Incorrect response for ", (boolean)result);
    }

    private boolean verifyGetRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_ALERTS)).append(FujitsuVoltXmlUtilityMock.emptyTag(TEST_ALERT_FILTER)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_ALERTS)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyEditConfigRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_SET_TCS[this.currentKey];
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_VOLT_ALERTS)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ALERT_FILTER, false)).append(target).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ALERT_FILTER)).append(FujitsuVoltXmlUtilityMock.endTag(TEST_VOLT_ALERTS)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyNotifyAlert() {
        String testRequest;
        try {
            InputStream fileStream = this.getClass().getResourceAsStream(NOTIFY_ALERT_FILE);
            testRequest = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
            testRequest = testRequest.substring(testRequest.indexOf(NOTIFY_ALERT_FILE) + NOTIFY_ALERT_FILE.length());
        }
        catch (IOException e) {
            Assert.fail((String)"IOException while reading: /notifyalert.xml");
            return false;
        }
        for (int i = 0; i < VERIFY_NOTIFY_ALERT_FILE_TCS.length; ++i) {
            String target = VERIFY_NOTIFY_ALERT_FILE_TCS[i];
            int index = testRequest.indexOf(target);
            if (index >= 0) continue;
            return false;
        }
        return true;
    }

    private class InternalSessionListener
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListener() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            Assert.assertTrue((String)"Incorrect target", (boolean)target.equals("running"));
            Assert.assertNull((String)"Incorrect mode", (Object)mode);
            request = request.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltAlertConfigTest.this.verifyEditConfigRequest(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            Assert.assertTrue((String)"Incorrect withDefaultsMode", (boolean)withDefaultsMode.equals("report-all"));
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltAlertConfigTest.this.verifyGetRequest(filterSchema);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            return false;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<notify-alert xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains(FujitsuVoltAlertConfigTest.TEST_NOTIFY_ALERT_WITH_NAMESPACE));
            StringBuilder rpc = new StringBuilder();
            rpc.append("<notify-alert ");
            rpc.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"/>");
            String testRequest = rpc.toString();
            boolean result = filterSchema.equals(testRequest);
            Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        }
    }
}

