/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltControllerConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltControllerConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListenerTest();
    private static final String TEST_VOLT_OFCONFIG = "volt-ofconfig";
    private static final String TEST_OFCONFIG_ID = "ofconfig-id";
    private static final String TEST_END_LICENSE_HEADER = "-->";
    private static final String[] GET_CONTROLLERS = new String[]{"tcp:172.10.10.45:6633", "tcp:100.0.0.22:5555"};
    private static final String[] SET_CONTROLLERS = new String[]{"tcp:172.10.10.55:2222", "tcp:172.20.33.11:6633"};
    private static final String GET_CONTROLLERS_RSP_FILE = "/getcontrollers.xml";
    private static final String SET_CONTROLLERS_REQ_FILE = "/setcontrollers.xml";
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltControllerConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltControllerConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testGetControllers() throws Exception {
        ArrayList<ControllerInfo> expectedControllers = new ArrayList<ControllerInfo>();
        for (int i = 0; i < GET_CONTROLLERS.length; ++i) {
            String target = GET_CONTROLLERS[i];
            String[] data = target.split(":");
            this.currentKey = i + 1;
            DefaultAnnotations annotations = DefaultAnnotations.builder().set(TEST_OFCONFIG_ID, this.currentKey.toString()).build();
            ControllerInfo controller = new ControllerInfo(IpAddress.valueOf((String)data[1]), Integer.parseInt(data[2]), data[0], (Annotations)annotations);
            expectedControllers.add(controller);
        }
        List controllers = this.voltConfig.getControllers();
        Assert.assertTrue((String)"Incorrect response", (boolean)controllers.equals(expectedControllers));
    }

    @Test
    public void testSetControllers() throws Exception {
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        for (int i = 0; i < SET_CONTROLLERS.length; ++i) {
            String target = SET_CONTROLLERS[i];
            String[] data = target.split(":");
            this.currentKey = i + 1;
            DefaultAnnotations annotations = DefaultAnnotations.builder().set(TEST_OFCONFIG_ID, this.currentKey.toString()).build();
            ControllerInfo controller = new ControllerInfo(IpAddress.valueOf((String)data[1]), Integer.parseInt(data[2]), data[0], (Annotations)annotations);
            controllers.add(controller);
        }
        this.voltConfig.setControllers(controllers);
    }

    private boolean verifyGetRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.emptyTag(TEST_VOLT_OFCONFIG)).append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyEditConfigRequest(String request) {
        String testRequest;
        try {
            InputStream fileStream = this.getClass().getResourceAsStream(SET_CONTROLLERS_REQ_FILE);
            testRequest = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
            testRequest = testRequest.substring(testRequest.indexOf(TEST_END_LICENSE_HEADER) + TEST_END_LICENSE_HEADER.length());
        }
        catch (IOException e) {
            Assert.fail((String)"IOException while reading: /setcontrollers.xml");
            return false;
        }
        testRequest = testRequest.replaceAll("\\s+", "");
        request = request.replaceAll("\\s+", "");
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with string in /setcontrollers.xml", (boolean)result);
        return result;
    }

    private class InternalSessionListenerTest
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListenerTest() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            request = request.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltControllerConfigTest.this.verifyEditConfigRequest(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            return false;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            Assert.assertTrue((String)"Incorrect withDefaultsMode", (boolean)withDefaultsMode.equals("report-all"));
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltControllerConfigTest.this.verifyGetRequest(filterSchema);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public String buildGetReply() {
            try {
                InputStream fileStream = this.getClass().getResourceAsStream(FujitsuVoltControllerConfigTest.GET_CONTROLLERS_RSP_FILE);
                String reply = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
                return reply;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            return false;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

