/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltFwdlConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltFwdlConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListener();
    private static final String TEST_ONDEMAND_FIRMWARE_UPGRADE = "ondemand-firmware-upgrade";
    private static final String TEST_PARTICIPANT_LIST = "participant-list";
    private static final String TEST_MEMBER = "member";
    private static final String TEST_IMAGE_NAME = "image-name";
    private static final String TEST_REBOOT_MODE = "reboot-mode";
    private static final String TEST_COMMA = ",";
    private static final String TEST_ONDEMAND_FWDL_WITH_NAMESPACE = "<ondemand-firmware-upgrade xmlns=\"http://fujitsu.com/ns/volt/1.1\"";
    private static final String[] INVALID_ONDEMAND_FWDL_TCS = new String[]{"xy1-b:a1-1", "AAA:1-2,--1", "CcC:s-1,2-2,3-2:auto", "xYZam:1-1,2-2,3-3:false", "JKml901:16-1-1,2-16:a-2", "abc:&AA-1,11-2:auto", "abc:xyz:-1-1", "@bcf11:xyz:auto", "FJ123:1-1&5-2:auto"};
    private static final String[] VALID_ONDEMAND_FWDL_TCS = new String[]{"Fujitsu123:1-2", "abcDE90f:16-11,1-1,17-3:auto", "fujitsuONU12:1-1,2-2,3-3,4-4,5-5,6-6,7-7"};
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltFwdlConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltFwdlConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testInvalidOndemandFirmwareUpgradeInput() throws Exception {
        for (int i = 0; i < INVALID_ONDEMAND_FWDL_TCS.length; ++i) {
            String target = INVALID_ONDEMAND_FWDL_TCS[i];
            String reply = this.voltConfig.upgradeFirmwareOndemand(target);
            Assert.assertNull((String)"Incorrect response for INVALID_ONDEMAND_FWDL_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidOndemandFirmwareUpgrade() throws Exception {
        for (int i = 0; i < VALID_ONDEMAND_FWDL_TCS.length; ++i) {
            String target = VALID_ONDEMAND_FWDL_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.upgradeFirmwareOndemand(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_ONDEMAND_FWDL_TCS", (Object)reply);
        }
    }

    private boolean verifyWrappedRpcRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_ONDEMAND_FWDL_TCS[this.currentKey];
        String[] data = target.split(":");
        String[] onuList = data[1].split(TEST_COMMA);
        rpc.append("<ondemand-firmware-upgrade ");
        rpc.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_PARTICIPANT_LIST));
        for (int count = 0; count < onuList.length; ++count) {
            String[] onuId = onuList[count].split("-");
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_MEMBER)).append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id")).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.startTag("onu-id")).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id")).append(FujitsuVoltXmlUtilityMock.endTag(TEST_MEMBER));
        }
        rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_PARTICIPANT_LIST)).append(FujitsuVoltXmlUtilityMock.startTag(TEST_IMAGE_NAME)).append(data[0]).append(FujitsuVoltXmlUtilityMock.endTag(TEST_IMAGE_NAME));
        if (data.length == 3) {
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_REBOOT_MODE)).append(data[2]).append(FujitsuVoltXmlUtilityMock.endTag(TEST_REBOOT_MODE));
        }
        rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONDEMAND_FIRMWARE_UPGRADE));
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private class InternalSessionListener
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListener() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            return false;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            return false;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            request = request.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<ondemand-firmware-upgrade xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains(FujitsuVoltFwdlConfigTest.TEST_ONDEMAND_FWDL_WITH_NAMESPACE));
            boolean result = FujitsuVoltFwdlConfigTest.this.verifyWrappedRpcRequest(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

