/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltNeConfig;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltNeConfigTest {
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltNeConfig voltConfig;
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListener();

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltNeConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testGetAll() throws Exception {
        String reply = this.voltConfig.getAll();
        Assert.assertNotNull((String)"Incorrect response", (Object)reply);
    }

    private boolean verifyGetRequest(String request) {
        StringBuilder rpc = new StringBuilder();
        rpc.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
        rpc.append(">\n");
        rpc.append("</volt-ne>");
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private class InternalSessionListener
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListener() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            return false;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            Assert.assertTrue((String)"Incorrect withDefaultsMode", (boolean)withDefaultsMode.equals("report-all"));
            filterSchema = filterSchema.replaceAll(" +", " ");
            Assert.assertTrue((String)"Does not contain:<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)filterSchema.contains("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\""));
            boolean result = FujitsuVoltNeConfigTest.this.verifyGetRequest(filterSchema);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return true;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            return false;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

