/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.drivers.fujitsu.FujitsuDriverHandlerAdapter;
import org.onosproject.drivers.fujitsu.FujitsuNetconfControllerMock;
import org.onosproject.drivers.fujitsu.FujitsuNetconfSessionListenerTest;
import org.onosproject.drivers.fujitsu.FujitsuVoltOnuOperConfig;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtilityMock;
import org.onosproject.net.driver.DriverHandler;

public class FujitsuVoltOnuOperConfigTest {
    private final FujitsuNetconfSessionListenerTest listener = new InternalSessionListener();
    private static final String TEST_ONU_REBOOT = "onu-reboot";
    private static final String TEST_ONU_ETHPORT_LOOPBACK = "onu-ethport-loopback";
    private static final String TEST_ETHPORT_ID = "ethport-id";
    private static final String TEST_LOOPBACK_MODE = "mode";
    private static final String TEST_ONU_REBOOT_WITH_NAMESPACE = "<onu-reboot xmlns=\"http://fujitsu.com/ns/volt/1.1\"";
    private static final String TEST_ONU_ETHPORT_LOOPBACK_WITH_NAMESPACE = "<onu-ethport-loopback xmlns=\"http://fujitsu.com/ns/volt/1.1\"";
    private static final String[] INVALID_REBOOT_TCS = new String[]{"xy1-b", "--1", "s-1", "16-1-1", "&AA-1", "-1-1"};
    private static final String[] VALID_REBOOT_TCS = new String[]{"1-2", "16-11"};
    private static final String[] INVALID_ETHPORT_LOOPBACK_TCS = new String[]{"-11-3--11", "1-CCa", "abc-1", "^1-1-3", "1-2:23-1", "1:33:2", "2-2-2:false"};
    private static final String[] VALID_ETHPORT_LOOPBACK_TCS = new String[]{"8-1-1", "1-11-3:release", "2-2-2:operate"};
    private Integer currentKey;
    private FujitsuNetconfControllerMock controller;
    private FujitsuDriverHandlerAdapter driverHandler;
    private FujitsuVoltOnuOperConfig voltConfig;

    @Before
    public void setUp() throws Exception {
        this.controller = new FujitsuNetconfControllerMock();
        this.driverHandler = this.controller.setUp(this.listener);
        this.voltConfig = new FujitsuVoltOnuOperConfig();
        this.voltConfig.setHandler((DriverHandler)this.driverHandler);
    }

    @Test
    public void testInvalidRebootOnuInput() throws Exception {
        for (int i = 0; i < INVALID_REBOOT_TCS.length; ++i) {
            String target = INVALID_REBOOT_TCS[i];
            String reply = this.voltConfig.rebootOnu(target);
            Assert.assertNull((String)"Incorrect response for INVALID_REBOOT_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidRebootOnu() throws Exception {
        for (int i = 0; i < VALID_REBOOT_TCS.length; ++i) {
            String target = VALID_REBOOT_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.rebootOnu(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_REBOOT_TCS", (Object)reply);
        }
    }

    @Test
    public void testInvalidEthLoopbackOnuInput() throws Exception {
        for (int i = 0; i < INVALID_ETHPORT_LOOPBACK_TCS.length; ++i) {
            String target = INVALID_ETHPORT_LOOPBACK_TCS[i];
            String reply = this.voltConfig.loopbackEthOnu(target);
            Assert.assertNull((String)"Incorrect response for INVALID_ETHPORT_LOOPBACK_TCS", (Object)reply);
        }
    }

    @Test
    public void testValidLoopbackEthOnu() throws Exception {
        for (int i = 0; i < VALID_ETHPORT_LOOPBACK_TCS.length; ++i) {
            String target = VALID_ETHPORT_LOOPBACK_TCS[i];
            this.currentKey = i;
            String reply = this.voltConfig.loopbackEthOnu(target);
            Assert.assertNotNull((String)"Incorrect response for VALID_ETHPORT_LOOPBACK_TCS", (Object)reply);
        }
    }

    private boolean verifyWrappedRpcRequestForReboot(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_REBOOT_TCS[this.currentKey];
        String[] data = target.split(":");
        String[] onuId = data[0].split("-");
        rpc.append("<onu-reboot ");
        rpc.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id")).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_REBOOT));
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private boolean verifyWrappedRpcRequestForEthLoopback(String request) {
        StringBuilder rpc = new StringBuilder();
        String target = VALID_ETHPORT_LOOPBACK_TCS[this.currentKey];
        String[] data = target.split(":");
        String[] ethId = data[0].split("-");
        rpc.append("<onu-ethport-loopback ");
        rpc.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
        rpc.append(FujitsuVoltXmlUtilityMock.startTag("ponlink-id", false)).append(ethId[0]).append(FujitsuVoltXmlUtilityMock.endTag("ponlink-id")).append(FujitsuVoltXmlUtilityMock.startTag("onu-id", false)).append(ethId[1]).append(FujitsuVoltXmlUtilityMock.endTag("onu-id")).append(FujitsuVoltXmlUtilityMock.startTag(TEST_ETHPORT_ID, false)).append(ethId[2]).append(FujitsuVoltXmlUtilityMock.endTag(TEST_ETHPORT_ID));
        if (data.length > 1) {
            rpc.append(FujitsuVoltXmlUtilityMock.startTag(TEST_LOOPBACK_MODE, false)).append(data[1]).append(FujitsuVoltXmlUtilityMock.endTag(TEST_LOOPBACK_MODE));
        }
        rpc.append(FujitsuVoltXmlUtilityMock.endTag(TEST_ONU_ETHPORT_LOOPBACK));
        String testRequest = rpc.toString();
        boolean result = request.equals(testRequest);
        Assert.assertTrue((String)"Does not match with generated string", (boolean)result);
        return result;
    }

    private class InternalSessionListener
    implements FujitsuNetconfSessionListenerTest {
        private InternalSessionListener() {
        }

        @Override
        public boolean verifyEditConfig(String request) {
            return false;
        }

        @Override
        public boolean verifyEditConfig(String target, String mode, String request) {
            return false;
        }

        @Override
        public boolean verifyGet(String filterSchema, String withDefaultsMode) {
            return false;
        }

        @Override
        public String buildGetReply() {
            return null;
        }

        @Override
        public boolean verifyWrappedRpc(String request) {
            boolean reboot = false;
            if (request.contains(FujitsuVoltOnuOperConfigTest.TEST_ONU_REBOOT)) {
                request = request.replaceAll(" +", " ");
                Assert.assertTrue((String)"Does not contain:<onu-reboot xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains(FujitsuVoltOnuOperConfigTest.TEST_ONU_REBOOT_WITH_NAMESPACE));
                reboot = true;
            } else {
                request = request.replaceAll(" +", " ");
                Assert.assertTrue((String)"Does not contain:<onu-ethport-loopback xmlns=\"http://fujitsu.com/ns/volt/1.1\"", (boolean)request.contains(FujitsuVoltOnuOperConfigTest.TEST_ONU_ETHPORT_LOOPBACK_WITH_NAMESPACE));
            }
            boolean result = reboot ? FujitsuVoltOnuOperConfigTest.this.verifyWrappedRpcRequestForReboot(request) : FujitsuVoltOnuOperConfigTest.this.verifyWrappedRpcRequestForEthLoopback(request);
            Assert.assertTrue((String)"XML verification failure", (boolean)result);
            return result;
        }

        @Override
        public void verifyStartSubscription(String filterSchema) {
        }
    }
}

