/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltAlarmConsumer
extends AbstractHandlerBehaviour
implements AlarmConsumer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final TimeZone ZONE = TimeZone.getTimeZone("UTC");
    private static final String VOLT_ALERTS = "volt-alerts";
    private static final String OLT_ACTIVE_ALERTS = "olt-active-alerts";
    private static final String ALERT_INFO = "alert-info";
    private static final String ALERT_SEQNUM = "alert-seqnum";
    private static final String ALERT_TYPE = "alert-type";
    private static final String ALERT_TIME = "alert-time";
    private static final String ALERT_CLEAR = "alert-clear";
    private static final String RESOURCE_ID = "resource-id";
    private static final String SEVERITY = "severity";
    private static final String IP_ADDRESS = "ip-address";
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String OLT_ACTIVE_ALERTS_KEY = "data.volt-ne.volt-alerts.olt-active-alerts";
    private static final String SLASH = "/";
    private DeviceId ncDeviceId;

    public List<Alarm> consumeAlarms() {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        this.ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(this.ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)this.ncDeviceId, (Object)mastershipService.getMasterFor(this.ncDeviceId));
            return null;
        }
        this.dateFormat.setTimeZone(ZONE);
        List<Object> alarms = new ArrayList();
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">\n").append(FujitsuVoltXmlUtility.buildStartTag(VOLT_ALERTS)).append(FujitsuVoltXmlUtility.buildEmptyTag(OLT_ACTIVE_ALERTS)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_ALERTS)).append("</volt-ne>");
            String reply = ((NetconfDevice)controller.getDevicesMap().get(this.ncDeviceId)).getSession().get(request.toString(), null);
            if (reply != null) {
                alarms = this.parseVoltActiveAlerts(XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
            }
        }
        catch (IOException e) {
            this.log.error("Error reading alarms for device {} exception {}", (Object)this.ncDeviceId, (Object)e);
        }
        return ImmutableList.copyOf(alarms);
    }

    private List<Alarm> parseVoltActiveAlerts(HierarchicalConfiguration cfg) {
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        List fields = cfg.configurationsAt(OLT_ACTIVE_ALERTS_KEY);
        for (HierarchicalConfiguration sub : fields) {
            List childFields = sub.configurationsAt(ALERT_INFO);
            for (HierarchicalConfiguration child : childFields) {
                try {
                    int seqNum = Integer.parseInt(child.getString(ALERT_SEQNUM));
                    boolean cleared = Boolean.parseBoolean(child.getString(ALERT_CLEAR));
                    String alertType = child.getString(ALERT_TYPE);
                    String severity = child.getString(SEVERITY);
                    List idFields = child.configurationsAt(RESOURCE_ID);
                    if (idFields.isEmpty()) {
                        this.log.error("{} does not exsit: SQ={}, TYPE={}, SEV={}, CLEARED={}", new Object[]{RESOURCE_ID, seqNum, alertType, severity, cleared});
                        continue;
                    }
                    String alarmSrc = this.formAlarmSource(idFields);
                    if (alarmSrc == null) {
                        this.log.error("Cannot build description: SQ={}, TYPE={}, SEV={}, CLEARED={}", new Object[]{seqNum, alertType, severity, cleared});
                        continue;
                    }
                    long timeRaised = this.getTimeRaised(child);
                    this.log.debug("VOLT: ACTIVE ALERT: SQ={}, TYPE={}, SEV={}, CLEARED={}, TIME={}", new Object[]{seqNum, alertType, severity, cleared, timeRaised});
                    Alarm.SeverityLevel alarmLevel = AlertSeverity.convertToAlarmSeverityLevel(severity);
                    if (alarmLevel.equals((Object)Alarm.SeverityLevel.INDETERMINATE)) {
                        this.log.warn("Unknown severity: {}", (Object)severity);
                    }
                    DefaultAlarm.Builder alarmBuilder = new DefaultAlarm.Builder(this.ncDeviceId, alertType.toUpperCase(), alarmLevel, timeRaised).forSource(AlarmEntityId.alarmEntityId((String)alarmSrc));
                    alarms.add((Alarm)alarmBuilder.build());
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number exception {}", (Throwable)e);
                }
                catch (Exception e) {
                    this.log.error("Exception {}", (Throwable)e);
                }
            }
        }
        return alarms;
    }

    private String formAlarmSource(List<HierarchicalConfiguration> idFields) {
        AlertResourceType resourceType = AlertResourceType.UNKNOWN;
        StringBuilder alarmSrc = new StringBuilder();
        String ipAddr = null;
        int pon = 0;
        int onu = 0;
        for (HierarchicalConfiguration id : idFields) {
            try {
                String value = id.getString("ponlink-id");
                if (value == null) {
                    resourceType = AlertResourceType.SYSTEM;
                    ipAddr = id.getString(IP_ADDRESS);
                    continue;
                }
                pon = Integer.parseInt(value);
                value = id.getString("onu-id");
                if (value == null) {
                    resourceType = AlertResourceType.PONLINK;
                    continue;
                }
                resourceType = AlertResourceType.ONU;
                onu = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.log.error("Non-number resource-id exception {}", (Throwable)e);
                return null;
            }
        }
        alarmSrc.append("other:");
        alarmSrc.append(resourceType.name()).append(SLASH);
        switch (resourceType) {
            case PONLINK: {
                alarmSrc.append(pon);
                break;
            }
            case ONU: {
                alarmSrc.append(pon).append("-").append(onu);
                break;
            }
            case SYSTEM: {
                if (ipAddr == null) break;
                alarmSrc.append(ipAddr);
                break;
            }
        }
        return alarmSrc.toString();
    }

    private long getTimeRaised(HierarchicalConfiguration cfg) {
        List timeFields = cfg.configurationsAt(ALERT_TIME);
        if (timeFields.isEmpty()) {
            this.log.debug("{} does not exsit", (Object)ALERT_TIME);
        } else {
            for (HierarchicalConfiguration child : timeFields) {
                String strDate = child.getString(DATE);
                String strTime = child.getString(TIME);
                if (strDate != null && strTime != null) {
                    try {
                        Date date = this.dateFormat.parse(strDate + " " + strTime);
                        long timeRaised = date.getTime();
                        this.log.debug("{} {} coverted to {}", new Object[]{strDate, strTime, timeRaised});
                        return timeRaised;
                    }
                    catch (ParseException e) {
                        this.log.error("Cannot parse exception {} {} {}", new Object[]{strDate, strTime, e});
                        continue;
                    }
                }
                this.log.error("{} or {} does not exsit", (Object)DATE, (Object)TIME);
            }
        }
        return System.currentTimeMillis();
    }

    private static enum AlertSeverity {
        INFO("info", Alarm.SeverityLevel.WARNING),
        MINOR("minor", Alarm.SeverityLevel.MINOR),
        MAJOR("major", Alarm.SeverityLevel.MAJOR),
        CRITICAL("critical", Alarm.SeverityLevel.CRITICAL);

        private String text;
        private Alarm.SeverityLevel level;

        private AlertSeverity(String text, Alarm.SeverityLevel level) {
            this.text = text;
            this.level = level;
        }

        public static Alarm.SeverityLevel convertToAlarmSeverityLevel(String text) {
            for (AlertSeverity severity : AlertSeverity.values()) {
                if (!text.equalsIgnoreCase(severity.text)) continue;
                return severity.level;
            }
            return Alarm.SeverityLevel.INDETERMINATE;
        }
    }

    private static enum AlertResourceType {
        UNKNOWN,
        PONLINK,
        ONU,
        SYSTEM;

    }
}

