/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.juniper;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.onosproject.drivers.juniper.JuniperUtils;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DeviceDiscoveryJuniperImpl
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    public final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DeviceDescription discoverDeviceDetails() {
        String chassis;
        String sysInfo;
        DeviceId deviceId = this.handler().data().deviceId();
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(deviceId)).getSession();
        try {
            sysInfo = session.get(JuniperUtils.requestBuilder("<get-system-information/>"));
            chassis = session.get(JuniperUtils.requestBuilder("<get-chassis-mac-addresses/>"));
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        DeviceDescription description = JuniperUtils.parseJuniperDescription(deviceId, XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(sysInfo.getBytes())), chassis);
        this.log.debug("Device  description {}", (Object)description);
        return description;
    }

    public List<PortDescription> discoverPortDetails() {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.get(JuniperUtils.requestBuilder("<get-interface-information/>"));
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        List<PortDescription> descriptions = JuniperUtils.parseJuniperPorts(XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes())));
        this.log.debug("Discovered ports {}", descriptions);
        return descriptions;
    }
}

