/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.juniper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.onlab.packet.ChassisId;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;

public final class JuniperUtils {
    public static final String FAILED_CFG = "Failed to retrieve configuration.";
    private static final String RPC_TAG_NETCONF_BASE = "<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">";
    private static final String RPC_CLOSE_TAG = "</rpc>";
    public static final String REQ_LLDP_NBR_INFO = "<get-lldp-neighbors-information/>";
    public static final String REQ_SYS_INFO = "<get-system-information/>";
    public static final String REQ_MAC_ADD_INFO = "<get-chassis-mac-addresses/>";
    public static final String REQ_IF_INFO = "<get-interface-information/>";
    private static final String LLDP_NBR_INFO = "lldp-neighbors-information";
    private static final String SYS_INFO = "system-information";
    private static final String HW_MODEL = "hardware-model";
    private static final String OS_NAME = "os-name";
    private static final String OS_VER = "os-version";
    private static final String SER_NUM = "serial-number";
    private static final String IF_INFO = "interface-information";
    private static final String IF_PHY = "physical-interface";
    private static final String IF_TYPE = "if-type";
    private static final String SPEED = "speed";
    private static final String ETH = "Ethernet";
    private static final String MBPS = "mbps";
    private static final String NAME = "name";
    private static final String IF_LO_ENCAP = "logical-interface.encapsulation";
    private static final String IF_LO_NAME = "logical-interface.name";
    private static final String IF_LO_ADD = "logical-interface.address-family.interface-address.ifa-local";
    private static final String LO_INDEX = "local-index";
    private static final String STATUS = "admin-status";
    private static final String SNMP_INDEX = "snmp-index";
    private static final String IF_LO_INDEX = "logical-interface.local-index";
    private static final String IF_LO_STATUS = "logical-interface.if-config-flags.iff-up";
    private static final String LLDP_LO_PORT = "lldp-local-port-id";
    private static final String LLDP_REM_CHASS = "lldp-remote-chassis-id";
    private static final String LLDP_REM_PORT = "lldp-remote-port-id";
    private static final String REGEX_ADD = ".*Private base address\\s*([:,0-9,a-f,A-F]*).*";
    private static final Pattern ADD_PATTERN = Pattern.compile(".*Private base address\\s*([:,0-9,a-f,A-F]*).*", 32);
    private static final String JUNIPER = "JUNIPER";
    private static final String UNKNOWN = "UNKNOWN";
    private static final long DEFAULT_PORT_SPEED = 1000L;

    private JuniperUtils() {
    }

    public static String requestBuilder(String request) {
        return RPC_TAG_NETCONF_BASE + request + RPC_CLOSE_TAG;
    }

    public static DeviceDescription parseJuniperDescription(DeviceId deviceId, HierarchicalConfiguration sysInfoCfg, String chassisText) {
        SubnodeConfiguration info = sysInfoCfg.configurationAt(SYS_INFO);
        String hw = info.getString(HW_MODEL) == null ? UNKNOWN : info.getString(HW_MODEL);
        String sw = UNKNOWN;
        if (info.getString(OS_NAME) != null || info.getString(OS_VER) != null) {
            sw = info.getString(OS_NAME) + " " + info.getString(OS_VER);
        }
        String serial = info.getString(SER_NUM) == null ? UNKNOWN : info.getString(SER_NUM);
        Matcher matcher = ADD_PATTERN.matcher(chassisText);
        if (matcher.lookingAt()) {
            String chassis = matcher.group(1);
            MacAddress chassisMac = MacAddress.valueOf((String)chassis);
            return new DefaultDeviceDescription(deviceId.uri(), Device.Type.ROUTER, JUNIPER, hw, sw, serial, new ChassisId(chassisMac.toLong()), new SparseAnnotations[]{DefaultAnnotations.EMPTY});
        }
        return new DefaultDeviceDescription(deviceId.uri(), Device.Type.ROUTER, JUNIPER, hw, sw, serial, null, new SparseAnnotations[]{DefaultAnnotations.EMPTY});
    }

    public static List<PortDescription> parseJuniperPorts(HierarchicalConfiguration cfg) {
        ArrayList portDescriptions = Lists.newArrayList();
        List subtrees = cfg.configurationsAt(IF_INFO);
        for (HierarchicalConfiguration interfInfo : subtrees) {
            List interfaceTree = interfInfo.configurationsAt(IF_PHY);
            for (HierarchicalConfiguration interf : interfaceTree) {
                if (interf == null) continue;
                if (interf.getString(IF_TYPE) != null && interf.getString(SPEED) != null) {
                    if (!interf.getString(IF_TYPE).contains(ETH) || !interf.getString(SPEED).contains(MBPS)) continue;
                    portDescriptions.add(JuniperUtils.parseDefaultPort(interf));
                    continue;
                }
                if (interf.getString(IF_LO_ENCAP) != null && !interf.getString(NAME).contains("pfe") && interf.getString(IF_LO_ENCAP).contains("ENET2")) {
                    portDescriptions.add(JuniperUtils.parseLogicalPort(interf));
                    continue;
                }
                if (!interf.getString(NAME).contains("lo")) continue;
                portDescriptions.add(JuniperUtils.parseLoopback(interf));
            }
        }
        return portDescriptions;
    }

    private static PortDescription parseLoopback(HierarchicalConfiguration cfg) {
        String name = cfg.getString(IF_LO_NAME).trim();
        PortNumber portNumber = PortNumber.portNumber((String)name.replace("lo0.", ""));
        DefaultAnnotations.Builder annotationsBuilder = DefaultAnnotations.builder().set("portName", name);
        String ip = cfg.getString(IF_LO_ADD);
        if (ip != null) {
            annotationsBuilder.set("ip", ip);
        }
        return new DefaultPortDescription(portNumber, true, Port.Type.COPPER, 1000L, new SparseAnnotations[]{annotationsBuilder.build()});
    }

    private static DefaultPortDescription parseDefaultPort(HierarchicalConfiguration cfg) {
        PortNumber portNumber = PortNumber.portNumber((String)cfg.getString(LO_INDEX));
        boolean enabled = cfg.getString(STATUS).equals("up");
        int speed = Integer.parseInt(cfg.getString(SPEED).replaceAll(MBPS, ""));
        DefaultAnnotations.Builder annotationsBuilder = DefaultAnnotations.builder().set("portName", cfg.getString(NAME).trim());
        JuniperUtils.setIpIfPresent(cfg, annotationsBuilder);
        return new DefaultPortDescription(portNumber, enabled, Port.Type.COPPER, (long)speed, new SparseAnnotations[]{annotationsBuilder.build()});
    }

    private static DefaultPortDescription parseLogicalPort(HierarchicalConfiguration cfg) {
        String name = cfg.getString(NAME).trim();
        String index = cfg.getString(SNMP_INDEX).trim();
        DefaultAnnotations.Builder annotationsBuilder = DefaultAnnotations.builder().set("portName", name).set("index", index);
        JuniperUtils.setIpIfPresent(cfg, annotationsBuilder);
        PortNumber portNumber = JuniperUtils.portNumberFromName(cfg.getString(IF_LO_INDEX), name);
        boolean enabled = false;
        if (cfg.getString(IF_LO_STATUS) != null) {
            enabled = true;
        }
        return new DefaultPortDescription(portNumber, enabled, Port.Type.COPPER, 1000L, new SparseAnnotations[]{annotationsBuilder.build()});
    }

    private static PortNumber portNumberFromName(String ifIndex, String name) {
        PortNumber portNumber = PortNumber.portNumber((String)ifIndex);
        if (name.contains("-")) {
            String[] splitted = name.split("-");
            String typeInt = "[" + splitted[0] + "]";
            String number = splitted[1].replace("/", "");
            number = "(" + number + ")";
            portNumber = PortNumber.fromString((String)(typeInt + number));
        }
        return portNumber;
    }

    private static void setIpIfPresent(HierarchicalConfiguration cfg, DefaultAnnotations.Builder annotationsBuilder) {
        String ip = cfg.getString(IF_LO_ADD);
        if (ip != null) {
            annotationsBuilder.set("ip", ip);
        }
    }

    public static void createBiDirLinkDescription(DeviceId localDevId, Port localPort, DeviceId remoteDevId, Port remotePort, Set<LinkDescription> descs) {
        ConnectPoint local = new ConnectPoint((ElementId)localDevId, localPort.number());
        ConnectPoint remote = new ConnectPoint((ElementId)remoteDevId, remotePort.number());
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("layer", "IP").build();
        descs.add((LinkDescription)new DefaultLinkDescription(local, remote, Link.Type.INDIRECT, false, new SparseAnnotations[]{annotations}));
        descs.add((LinkDescription)new DefaultLinkDescription(remote, local, Link.Type.INDIRECT, false, new SparseAnnotations[]{annotations}));
    }

    public static Set<LinkAbstraction> parseJuniperLldp(HierarchicalConfiguration info) {
        HashSet<LinkAbstraction> neighbour = new HashSet<LinkAbstraction>();
        List subtrees = info.configurationsAt(LLDP_NBR_INFO);
        for (HierarchicalConfiguration neighborsInfo : subtrees) {
            List neighbors = neighborsInfo.configurationsAt(LLDP_NBR_INFO);
            for (HierarchicalConfiguration neighbor : neighbors) {
                String localPortName = neighbor.getString(LLDP_LO_PORT);
                MacAddress mac = MacAddress.valueOf((String)neighbor.getString(LLDP_REM_CHASS));
                int remotePortIndex = neighbor.getInt(LLDP_REM_PORT);
                LinkAbstraction link = new LinkAbstraction(localPortName, mac.toLong(), remotePortIndex);
                neighbour.add(link);
            }
        }
        return neighbour;
    }

    protected static final class LinkAbstraction {
        protected String localPortName;
        protected ChassisId remoteChassisId;
        protected int remotePortIndex;

        protected LinkAbstraction(String pName, long chassisId, int pIndex) {
            this.localPortName = pName;
            this.remoteChassisId = new ChassisId(chassisId);
            this.remotePortIndex = pIndex;
        }
    }
}

