/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.netconf;

import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.onosproject.drivers.netconf.TemplateRequestDriver;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class TemplateManager {
    private static final Logger log = LoggerFactory.getLogger(TemplateManager.class);
    private final Map<String, String> templates = new HashMap<String, String>();
    private TemplateRequestDriver requestDriver = new InternalRequestDriver();
    private static final Map<String, Object> EMPTY_TEMPLATE_CONTEXT = new HashMap<String, Object>();

    public void setRequestDriver(TemplateRequestDriver driver) {
        this.requestDriver = driver;
    }

    public void load(Class<? extends Object> reference, String pattern, String ... templateNames) {
        String[] stringArray = templateNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String resource;
            String name;
            String key = name = stringArray[i];
            if (name.charAt(0) == '/') {
                int start = name.lastIndexOf(47) + 1;
                int end = name.lastIndexOf(46);
                key = end == -1 ? name.substring(start) : name.substring(start, end);
                resource = name;
            } else {
                resource = String.format(pattern, name);
            }
            log.debug("LOAD TEMPLATE: '{}' as '{}' from '{}", new Object[]{name, key, resource});
            try {
                this.templates.put(name, Resources.toString((URL)Resources.getResource(reference, (String)resource), (Charset)StandardCharsets.UTF_8));
                continue;
            }
            catch (IOException ioe) {
                log.error("Unable to load NETCONF request template '{}' from '{}'", new Object[]{key, resource, ioe});
            }
        }
    }

    public void load(String ... templateMNames) {
        this.load(this.getClass(), "/templates/requests/%s.j2", templateMNames);
    }

    public void load(String pattern, String ... templateMNames) {
        this.load(this.getClass(), pattern, templateMNames);
    }

    public String get(String templateName) {
        return this.templates.get(templateName);
    }

    public String render(String template, Map<String, Object> context) {
        if (context == null) {
            return template;
        }
        String temp = template;
        for (Map.Entry<String, Object> e : context.entrySet()) {
            temp = temp.replaceAll("\\{\\{ *" + e.getKey() + " *\\}\\}", e.getValue().toString());
        }
        return temp;
    }

    public Object doRequest(NetconfSession session, String templateName, Map<String, Object> templateContext, String baseXPath, QName returnType) throws NetconfException {
        return this.requestDriver.doRequest(session, templateName, templateContext, baseXPath, returnType);
    }

    public Node doRequest(NetconfSession session, String templateName) throws NetconfException {
        return (Node)this.doRequest(session, templateName, EMPTY_TEMPLATE_CONTEXT, "/rpc-reply/data", XPathConstants.NODE);
    }

    public Node doRequest(NetconfSession session, String templateName, Map<String, Object> templateContext) throws NetconfException {
        return (Node)this.doRequest(session, templateName, templateContext, "/rpc-reply/data", XPathConstants.NODE);
    }

    private class InternalRequestDriver
    implements TemplateRequestDriver {
        private InternalRequestDriver() {
        }

        @Override
        public Object doRequest(NetconfSession session, String templateName, Map<String, Object> templateContext, String baseXPath, QName returnType) throws NetconfException {
            try {
                String data = (String)session.rpc(TemplateManager.this.render((String)TemplateManager.this.templates.get(templateName), templateContext)).get();
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(CharSource.wrap((CharSequence)data).openStream()));
                XPath xp = XPathFactory.newInstance().newXPath();
                return xp.evaluate(baseXPath, document, returnType);
            }
            catch (Exception e) {
                throw new NetconfException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

