/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.netconf;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ConfigGetter;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.DatastoreId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfConfigGetter
extends AbstractHandlerBehaviour
implements ConfigGetter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String UNABLE_TO_READ_CONFIG = "config retrieval error";

    public String getConfiguration(String type) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        DeviceId ofDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        try {
            return ((NetconfDevice)controller.getDevicesMap().get(ofDeviceId)).getSession().getConfig(DatastoreId.datastore((String)type));
        }
        catch (NetconfException e) {
            this.log.error("Configuration could not be retrieved {}", (Object)e.getMessage());
            return UNABLE_TO_READ_CONFIG;
        }
    }
}

