/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.net.Device;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCalientFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;

public class CalientFiberSwitchHandshaker
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private List<OFCalientPortDescStatsEntry> fiberPorts = new ArrayList<OFCalientPortDescStatsEntry>();

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        this.log.warn("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("Exception while sending experimenter port desc:", (Throwable)e);
        }
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCalientPortDescStatsRequest portsRequest = this.factory().buildCalientPortDescStatsRequest().build();
        this.log.warn("Sending experimenter port description message {}", (Object)portsRequest.toString());
        this.sendHandshakeMessage((OFMessage)portsRequest);
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                break;
            }
            case ERROR: {
                this.log.error("Switch Error {} {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                this.log.warn("Received port desc reply");
                OFCalientPortDescStatsReply descStatsReply = (OFCalientPortDescStatsReply)m;
                this.fiberPorts.addAll(descStatsReply.getPortDesc());
                if (descStatsReply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) break;
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    public Device.Type deviceType() {
        return Device.Type.FIBER_SWITCH;
    }

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        return ImmutableList.copyOf(this.fiberPorts);
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }

    public final void sendMsg(OFMessage m) {
        OFMessage newMsg = m;
        if (m.getType() == OFType.STATS_REQUEST) {
            OFStatsRequest sr = (OFStatsRequest)m;
            this.log.debug("Rebuilding stats request type {}", (Object)sr.getStatsType());
            switch (sr.getStatsType()) {
                case FLOW: {
                    OFCalientFlowStatsRequest request = this.factory().buildCalientFlowStatsRequest().setCookie(((OFFlowStatsRequest)sr).getCookie()).setCookieMask(((OFFlowStatsRequest)sr).getCookieMask()).setMatch(this.factory().matchWildcardAll()).setOutGroup((long)((OFFlowStatsRequest)sr).getOutGroup().getGroupNumber()).setOutPort(OFPort.ANY).setTableId(TableId.ALL).setXid(sr.getXid()).setFlags(sr.getFlags()).build();
                    newMsg = request;
                    break;
                }
                case PORT: {
                    break;
                }
            }
        }
        super.sendMsg(newMsg);
    }
}

