/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.onosproject.net.Device;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFExpPort;
import org.projectfloodlight.openflow.protocol.OFExpPortDescReply;
import org.projectfloodlight.openflow.protocol.OFExpPortDescRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;

public class OFOpticalSwitch13
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private List<OFExpPort> expPortDes = new ArrayList<OFExpPort>();

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        this.log.info("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        this.log.debug("sendHandshakeOFExperimenterPortDescRequest for sw {}", (Object)this.getStringId());
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("Failed to send handshaker message OFExperimenterPortDescRequestfor sw {}", (Throwable)e);
        }
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        this.log.debug("processDriverHandshakeMessage for sw {}", (Object)this.getStringId());
        switch (m.getType()) {
            case STATS_REPLY: {
                this.processOFMultipartReply((OFStatsReply)m);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    private void processOFMultipartReply(OFStatsReply stats) {
        this.log.debug("Received message {} during switch-driver subhandshake from switch {} ... " + stats, (Object)this.getStringId());
        if (stats.getStatsType() == OFStatsType.EXPERIMENTER) {
            try {
                OFExpPortDescReply expPortDescReply = (OFExpPortDescReply)stats;
                this.expPortDes.addAll(expPortDescReply.getEntries());
                if (!expPortDescReply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
                    this.driverHandshakeComplete.set(true);
                    return;
                }
            }
            catch (ClassCastException e) {
                this.log.error("Unexspected Experimenter Multipart message type {} ", (Object)stats.getClass().getName());
            }
        }
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFExpPortDescRequest preq = this.factory().buildExpPortDescRequest().setXid((long)this.getNextTransactionId()).build();
        this.log.debug("Sending experimented port description message {}", (Object)preq.toString());
        this.sendHandshakeMessage((OFMessage)preq);
    }

    public Device.Type deviceType() {
        String hwDesc;
        switch (hwDesc = this.hardwareDescription()) {
            case "Optical-ROADM": {
                return Device.Type.ROADM;
            }
            case "Optical-OTN": {
                return Device.Type.OTN;
            }
        }
        this.log.error("Unsupported hardwareDescription {}", (Object)hwDesc);
        return Device.Type.OTHER;
    }

    public List<OFPortDesc> getPorts() {
        return ImmutableList.copyOf((Collection)this.ports.stream().flatMap(p -> p.getEntries().stream()).collect(Collectors.toList()));
    }

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        return ImmutableList.copyOf(this.expPortDes);
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }
}

