/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.power;

import com.google.common.collect.Range;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.onosproject.driver.extensions.OplinkAttenuation;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Direction;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.PowerConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkRoadmPowerConfig
extends AbstractHandlerBehaviour
implements PowerConfig<Object> {
    private static final int LINE_IN = 1;
    private static final int LINE_OUT = 2;
    private static final int AUX_OUT_1 = 3;
    private static final int AUX_OUT_2 = 4;
    private static final int EXPRESS_OUT_1 = 5;
    private static final int EXPRESS_OUT_2 = 6;
    private static final int EXPRESS_OUT_3 = 7;
    private static final int EXPRESS_OUT_4 = 8;
    private static final int EXPRESS_OUT_5 = 9;
    private static final int EXPRESS_OUT_6 = 10;
    private static final int EXPRESS_OUT_7 = 11;
    private static final int AUX_IN_1 = 12;
    private static final int AUX_IN_2 = 13;
    private static final int EXPRESS_IN_1 = 14;
    private static final int EXPRESS_IN_2 = 15;
    private static final int EXPRESS_IN_3 = 16;
    private static final int EXPRESS_IN_4 = 17;
    private static final int EXPRESS_IN_5 = 18;
    private static final int EXPRESS_IN_6 = 19;
    private static final int EXPRESS_IN_7 = 20;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private Type getType(Object component) {
        if (component == null || component instanceof Direction) {
            return Type.PORT;
        }
        if (component instanceof OchSignal) {
            return Type.CHANNEL;
        }
        return Type.NONE;
    }

    private OpenFlowSwitch getOpenFlowDevice() {
        Dpid dpid;
        OpenFlowController controller = (OpenFlowController)this.handler().get(OpenFlowController.class);
        OpenFlowSwitch sw = controller.getSwitch(dpid = Dpid.dpid((URI)this.data().deviceId().uri()));
        if (sw == null || !sw.isConnected()) {
            return null;
        }
        return sw;
    }

    private FlowEntry findFlow(PortNumber portNum, OchSignal och) {
        FlowRuleService service = (FlowRuleService)this.handler().get(FlowRuleService.class);
        Iterable flowEntries = service.getFlowEntries(this.data().deviceId());
        for (FlowEntry entry : flowEntries) {
            PortCriterion entryPort;
            TrafficSelector selector = entry.selector();
            OchSignalCriterion entrySigid = (OchSignalCriterion)selector.getCriterion(Criterion.Type.OCH_SIGID);
            if (entrySigid == null || !och.equals((Object)entrySigid.lambda()) || (entryPort = (PortCriterion)selector.getCriterion(Criterion.Type.IN_PORT)) == null || !portNum.equals((Object)entryPort.port())) continue;
            return entry;
        }
        this.log.warn("No matching flow found");
        return null;
    }

    public Optional<Long> getTargetPower(PortNumber portNum, Object component) {
        Long returnVal = null;
        if (this.getOpenFlowDevice() != null) {
            switch (this.getType(component)) {
                case PORT: {
                    break;
                }
                case CHANNEL: {
                    returnVal = this.getChannelAttenuation(portNum, (OchSignal)component);
                    break;
                }
            }
        }
        return Optional.ofNullable(returnVal);
    }

    public Optional<Long> currentPower(PortNumber portNum, Object component) {
        Long returnVal = null;
        if (this.getOpenFlowDevice() != null) {
            switch (this.getType(component)) {
                case PORT: {
                    returnVal = this.getCurrentPortPower(portNum);
                    break;
                }
                case CHANNEL: {
                    returnVal = this.getCurrentChannelPower(portNum, (OchSignal)component);
                    break;
                }
            }
        }
        return Optional.ofNullable(returnVal);
    }

    public void setTargetPower(PortNumber portNum, Object component, long power) {
        if (this.getOpenFlowDevice() != null) {
            switch (this.getType(component)) {
                case PORT: {
                    this.setTargetPortPower(portNum, power);
                    break;
                }
                case CHANNEL: {
                    this.setChannelAttenuation(portNum, (OchSignal)component, power);
                    break;
                }
            }
        } else {
            this.log.warn("OpenFlow handshaker driver not found or device is not connected");
        }
    }

    public Optional<Range<Long>> getTargetPowerRange(PortNumber port, Object component) {
        Range<Long> range = null;
        switch (this.getType(component)) {
            case PORT: {
                range = this.getTargetPortPowerRange(port);
                break;
            }
            case CHANNEL: {
                range = this.getChannelAttenuationRange(port);
                break;
            }
        }
        return Optional.ofNullable(range);
    }

    public Optional<Range<Long>> getInputPowerRange(PortNumber port, Object component) {
        Range<Long> range = null;
        switch (this.getType(component)) {
            case PORT: {
                range = this.getInputPortPowerRange(port);
                break;
            }
        }
        return Optional.ofNullable(range);
    }

    private Long getChannelAttenuation(PortNumber portNum, OchSignal och) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry != null) {
            List instructions = flowEntry.treatment().allInstructions();
            for (Instruction ins : instructions) {
                ExtensionTreatment ext;
                if (ins.type() != Instruction.Type.EXTENSION || (ext = ((Instructions.ExtensionInstructionWrapper)ins).extensionInstruction()).type() != ExtensionTreatmentType.ExtensionTreatmentTypes.OPLINK_ATTENUATION.type()) continue;
                return ((OplinkAttenuation)ext).getAttenuation();
            }
        }
        return null;
    }

    private Long getCurrentPortPower(PortNumber portNum) {
        String currentPower;
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        Port port = deviceService.getPort(this.data().deviceId(), portNum);
        if (port != null && (currentPower = port.annotations().value("currentPower")) != null) {
            return Long.valueOf(currentPower);
        }
        return null;
    }

    private Long getCurrentChannelPower(PortNumber portNum, OchSignal och) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry != null) {
            return flowEntry.packets();
        }
        return null;
    }

    private void setTargetPortPower(PortNumber portNum, long power) {
        OpenFlowSwitch device = this.getOpenFlowDevice();
        device.sendMsg((OFMessage)device.factory().buildOplinkPortPowerSet().setXid(0L).setPort((int)portNum.toLong()).setPowerValue((int)power).build());
    }

    private void setChannelAttenuation(PortNumber portNum, OchSignal och, long power) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry != null) {
            List instructions = flowEntry.treatment().allInstructions();
            for (Instruction ins : instructions) {
                ExtensionTreatment ext;
                if (ins.type() != Instruction.Type.EXTENSION || (ext = ((Instructions.ExtensionInstructionWrapper)ins).extensionInstruction()).type() != ExtensionTreatmentType.ExtensionTreatmentTypes.OPLINK_ATTENUATION.type()) continue;
                ((OplinkAttenuation)ext).setAttenuation((int)power);
                FlowRuleService service = (FlowRuleService)this.handler().get(FlowRuleService.class);
                service.applyFlowRules(new FlowRule[]{flowEntry});
                return;
            }
            this.addAttenuation(flowEntry, power);
        } else {
            this.log.warn("Target channel power not set");
        }
    }

    private void addAttenuation(FlowEntry flowEntry, long power) {
        DefaultFlowRule.Builder flowBuilder = new DefaultFlowRule.Builder();
        flowBuilder.withCookie(flowEntry.id().value());
        flowBuilder.withPriority(flowEntry.priority());
        flowBuilder.forDevice(flowEntry.deviceId());
        flowBuilder.forTable(flowEntry.tableId());
        if (flowEntry.isPermanent()) {
            flowBuilder.makePermanent();
        } else {
            flowBuilder.makeTemporary(flowEntry.timeout());
        }
        flowBuilder.withSelector(flowEntry.selector());
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        flowEntry.treatment().allInstructions().forEach(ins -> treatmentBuilder.add(ins));
        treatmentBuilder.add((Instruction)Instructions.extension((ExtensionTreatment)new OplinkAttenuation((int)power), (DeviceId)this.data().deviceId()));
        flowBuilder.withTreatment(treatmentBuilder.build());
        FlowRuleService service = (FlowRuleService)this.handler().get(FlowRuleService.class);
        service.applyFlowRules(new FlowRule[]{flowBuilder.build()});
    }

    private Range<Long> getTargetPortPowerRange(PortNumber port) {
        Range range = null;
        long num = port.toLong();
        if (num == 2L) {
            range = Range.closed((Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(2040L));
        } else if (num >= 3L && num <= 11L) {
            range = Range.closed((Comparable)Long.valueOf(-680L), (Comparable)Long.valueOf(1530L));
        }
        return range;
    }

    private Range<Long> getChannelAttenuationRange(PortNumber port) {
        Range range = null;
        long num = port.toLong();
        if (num == 2L || num >= 12L && num <= 20L) {
            range = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(2550L));
        }
        return range;
    }

    private Range<Long> getInputPortPowerRange(PortNumber port) {
        Range range = null;
        long portNum = port.toLong();
        if (portNum == 1L) {
            range = Range.closed((Comparable)Long.valueOf(-2600L), (Comparable)Long.valueOf(540L));
        } else if (portNum == 12L || portNum == 13L) {
            range = Range.closed((Comparable)Long.valueOf(-1250L), (Comparable)Long.valueOf(1590L));
        } else if (portNum >= 14L && portNum <= 20L) {
            range = Range.closed((Comparable)Long.valueOf(-1420L), (Comparable)Long.valueOf(1420L));
        }
        return range;
    }

    private static enum Type {
        NONE,
        PORT,
        CHANNEL;

    }
}

