/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onosproject.drivers.optical.OpticalAdjacencyLinkService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkService;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsReply;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsRequest;
import org.projectfloodlight.openflow.protocol.OFExpPortAdidOtn;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacency;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyId;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyReply;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPower;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPowerReply;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPowerRequest;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;

public class OplinkRoadm
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private List<OFPortOptical> opticalPorts;

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        return ImmutableList.copyOf(this.opticalPorts);
    }

    public List<OFPortDesc> getPorts() {
        return Collections.EMPTY_LIST;
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        this.log.warn("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("OPLK ROADM exception while sending experimenter port desc:", (Throwable)e);
        }
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                this.log.debug("OPLK ROADM Received barrier response");
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                this.processOFPortStatus((OFCircuitPortStatus)m);
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                OFStatsReply stats = (OFStatsReply)m;
                if (stats.getStatsType() != OFStatsType.EXPERIMENTER) break;
                this.log.warn("OPLK ROADM : Received multipart (port desc) reply message {}", (Object)m);
                this.createOpticalPortList((OFCircuitPortsReply)m);
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    private void processOFPortStatus(OFCircuitPortStatus ps) {
        this.log.debug("OPLK ROADM ..OF Port Status :", (Object)ps);
    }

    public Device.Type deviceType() {
        return Device.Type.ROADM;
    }

    public final void sendMsg(OFMessage m) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(m);
        if (m.getType() == OFType.STATS_REQUEST) {
            OFStatsRequest sr = (OFStatsRequest)m;
            this.log.debug("OPLK ROADM rebuilding stats request type {}", (Object)sr.getStatsType());
            switch (sr.getStatsType()) {
                case PORT: {
                    OFOplinkPortPowerRequest oFOplinkPortPowerRequest = this.factory().buildOplinkPortPowerRequest().setXid(sr.getXid()).setFlags(sr.getFlags()).build();
                    messages.add(oFOplinkPortPowerRequest);
                    OFExpPortAdjacencyRequest adjacencyRequest = this.factory().buildExpPortAdjacencyRequest().setXid(sr.getXid()).setFlags(sr.getFlags()).build();
                    messages.add(adjacencyRequest);
                    break;
                }
            }
        } else {
            this.log.debug("OPLK ROADM sends msg:{}, as is", (Object)m.getType());
        }
        for (OFMessage oFMessage : messages) {
            super.sendMsg(oFMessage);
        }
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCircuitPortsRequest circuitPortsRequest = this.factory().buildCircuitPortsRequest().setXid((long)this.getNextTransactionId()).build();
        this.log.info("OPLK ROADM : Sending experimented circuit port stats message {}", (Object)circuitPortsRequest);
        this.sendHandshakeMessage((OFMessage)circuitPortsRequest);
    }

    private void createOpticalPortList(OFCircuitPortsReply wPorts) {
        this.opticalPorts = new ArrayList<OFPortOptical>();
        this.opticalPorts.addAll(wPorts.getEntries());
    }

    public List<PortDescription> processExpPortStats(OFMessage msg) {
        if (msg instanceof OFOplinkPortPowerReply) {
            return this.buildPortPowerDescriptions(((OFOplinkPortPowerReply)msg).getEntries());
        }
        if (msg instanceof OFExpPortAdjacencyReply) {
            return this.buildPortAdjacencyDescriptions(((OFExpPortAdjacencyReply)msg).getEntries());
        }
        return Collections.emptyList();
    }

    private List<PortDescription> buildPortPowerDescriptions(List<OFOplinkPortPower> portPowers) {
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        HashMap powerMap = new HashMap(portPowers.size());
        portPowers.forEach(power -> powerMap.put(Long.valueOf(power.getPort()), power));
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (Port port : ports) {
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            builder.putAll(port.annotations());
            OFOplinkPortPower power2 = (OFOplinkPortPower)powerMap.get(port.number().toLong());
            if (power2 != null) {
                builder.set("currentPower", Long.toString(power2.getPowerValue()));
            }
            portDescs.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{builder.build()}));
        }
        return portDescs;
    }

    private OplinkPortAdjacency getNeighbor(OFExpPortAdjacency ad) {
        for (OFExpPortAdjacencyId adid : ad.getProperties()) {
            List otns = adid.getAdId();
            if (otns == null || otns.size() <= 0) continue;
            OFExpPortAdidOtn otn = (OFExpPortAdidOtn)otns.get(0);
            ChannelBuffer buffer = ChannelBuffers.buffer((int)32);
            otn.getOpspec().write32Bytes(buffer);
            long mac = buffer.getLong(18) << 4 >>> 16;
            int port = (int)(buffer.getLong(24) << 4 >>> 32);
            return new OplinkPortAdjacency(DeviceId.deviceId((URI)Dpid.uri((Dpid)new Dpid(mac))), PortNumber.portNumber((long)port));
        }
        return null;
    }

    private List<PortDescription> buildPortAdjacencyDescriptions(List<OFExpPortAdjacency> portAds) {
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        HashMap adMap = new HashMap(portAds.size());
        portAds.forEach(ad -> adMap.put(Long.valueOf(ad.getPortNo().getPortNumber()), ad));
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (Port port : ports) {
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            Annotations oldAnnotations = port.annotations();
            builder.putAll(oldAnnotations);
            OFExpPortAdjacency ad2 = (OFExpPortAdjacency)adMap.get(port.number().toLong());
            if (ad2 != null) {
                OplinkPortAdjacency neighbor = this.getNeighbor(ad2);
                String newId = neighbor.getDeviceId().toString();
                String newPort = neighbor.getPort().toString();
                if (!newId.equals(oldAnnotations.value("neighborDeviceId")) || !newPort.equals(oldAnnotations.value("neighborPort"))) {
                    builder.set("neighborDeviceId", newId);
                    builder.set("neighborPort", newPort);
                }
                this.addLink(port.number(), neighbor);
            } else {
                builder.remove("neighborDeviceId");
                builder.remove("neighborPort");
                this.removeLink(port.number());
            }
            portDescs.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{builder.build()}));
        }
        return portDescs;
    }

    private void addLink(PortNumber portNumber, OplinkPortAdjacency neighbor) {
        ConnectPoint dst = new ConnectPoint((ElementId)this.handler().data().deviceId(), portNumber);
        ConnectPoint src = new ConnectPoint((ElementId)neighbor.getDeviceId(), neighbor.getPort());
        OpticalAdjacencyLinkService adService = (OpticalAdjacencyLinkService)this.handler().get(OpticalAdjacencyLinkService.class);
        adService.linkDetected((LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.OPTICAL, new SparseAnnotations[0]));
    }

    private void removeLink(PortNumber portNumber) {
        ConnectPoint dst = new ConnectPoint((ElementId)this.handler().data().deviceId(), portNumber);
        Set links = ((LinkService)this.handler().get(LinkService.class)).getIngressLinks(dst);
        if (!links.isEmpty()) {
            OpticalAdjacencyLinkService adService = (OpticalAdjacencyLinkService)this.handler().get(OpticalAdjacencyLinkService.class);
            adService.linksVanished(dst);
        }
    }

    private class OplinkPortAdjacency {
        private DeviceId deviceId;
        private PortNumber portNumber;

        public OplinkPortAdjacency(DeviceId deviceId, PortNumber portNumber) {
            this.deviceId = deviceId;
            this.portNumber = portNumber;
        }

        public DeviceId getDeviceId() {
            return this.deviceId;
        }

        public PortNumber getPort() {
            return this.portNumber;
        }
    }
}

