/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.util.GuavaCollectors;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

public class LincOELambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    private static final int LAMBDA_COUNT = 80;
    private static final Set<OchSignal> OMS_LAMDAS = (Set)IntStream.range(0, 80).mapToObj(x -> new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, x - 40, 4)).collect(GuavaCollectors.toImmutableSet());

    public Set<OchSignal> queryLambdas(PortNumber port) {
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        Port p = deviceService.getPort(this.data().deviceId(), port);
        if (p == null || !p.type().equals((Object)Port.Type.OMS)) {
            return ImmutableSet.of();
        }
        return OMS_LAMDAS;
    }
}

