/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.optical;

import com.google.common.annotations.Beta;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.drivers.optical.OpticalAdjacencyLinkService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
@Service
public class OpticalAdjacencyLinkManager
implements OpticalAdjacencyLinkService {
    private static final ProviderId PID = new ProviderId("of", "org.onosproject.drivers.optical");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private LinkProvider linkProvider = new StubLinkProvider();
    private LinkProviderService linkProviderService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;

    @Activate
    public void activate() {
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this.linkProvider);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.linkProviderRegistry.unregister((Provider)this.linkProvider);
        this.log.info("Stopped");
    }

    @Override
    public void linkDetected(LinkDescription linkDescription) {
        this.linkProviderService.linkDetected(linkDescription);
    }

    @Override
    public void linkVanished(LinkDescription linkDescription) {
        this.linkProviderService.linkVanished(linkDescription);
    }

    @Override
    public void linksVanished(ConnectPoint connectPoint) {
        this.linkProviderService.linksVanished(connectPoint);
    }

    @Override
    public void linksVanished(DeviceId deviceId) {
        this.linkProviderService.linksVanished(deviceId);
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    private static final class StubLinkProvider
    implements LinkProvider {
        private StubLinkProvider() {
        }

        public ProviderId id() {
            return PID;
        }
    }
}

