/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onlab.util.Spectrum;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

public class CalientLambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    public Set<OchSignal> queryLambdas(PortNumber port) {
        long startSpacingMultiplier = Spectrum.U_BAND_MIN.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_12P5GHZ.frequency().asHz();
        long stopSpacingMultiplier = Spectrum.O_BAND_MAX.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_12P5GHZ.frequency().asHz();
        return IntStream.rangeClosed((int)startSpacingMultiplier, (int)stopSpacingMultiplier).filter(i -> i % 2 == 1).mapToObj(i -> new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, i, 1)).collect(Collectors.toSet());
    }
}

