/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.onosproject.drivers.p4runtime.P4RuntimeActionGroupProgrammable;
import org.onosproject.drivers.p4runtime.P4RuntimeReplicationGroupProgrammable;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProgrammable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4RuntimeGroupProgrammable
extends AbstractHandlerBehaviour
implements GroupProgrammable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private void doPerformGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        Preconditions.checkArgument((boolean)deviceId.equals((Object)this.data().deviceId()), (Object)"passed deviceId must be the same assigned to this behavior");
        ArrayList actionGroups = Lists.newArrayList();
        ArrayList preGroups = Lists.newArrayList();
        groupOps.operations().forEach(op -> {
            switch (op.groupType()) {
                case SELECT: {
                    actionGroups.add(op);
                    break;
                }
                case ALL: 
                case CLONE: {
                    preGroups.add(op);
                    break;
                }
                default: {
                    this.log.warn("{} group type not supported [{}]", (Object)op.groupType(), op);
                }
            }
        });
        if (!actionGroups.isEmpty()) {
            this.actionProgrammable().performGroupOperation(deviceId, new GroupOperations((List)actionGroups));
        }
        if (!preGroups.isEmpty()) {
            this.replicationProgrammable().performGroupOperation(deviceId, new GroupOperations((List)preGroups));
        }
    }

    private Collection<Group> doGetGroups() {
        return new ImmutableList.Builder().addAll(this.actionProgrammable().getGroups()).addAll(this.replicationProgrammable().getGroups()).build();
    }

    private P4RuntimeActionGroupProgrammable actionProgrammable() {
        P4RuntimeActionGroupProgrammable prog = new P4RuntimeActionGroupProgrammable();
        prog.setData(this.data());
        prog.setHandler(this.handler());
        return prog;
    }

    private P4RuntimeReplicationGroupProgrammable replicationProgrammable() {
        P4RuntimeReplicationGroupProgrammable prog = new P4RuntimeReplicationGroupProgrammable();
        prog.setData(this.data());
        prog.setHandler(this.handler());
        return prog;
    }

    public void performGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        try {
            this.doPerformGroupOperation(deviceId, groupOps);
        }
        catch (Throwable ex) {
            this.log.error("Unhandled exception on performGroupOperation", ex);
        }
    }

    public Collection<Group> getGroups() {
        try {
            return this.doGetGroups();
        }
        catch (Throwable ex) {
            this.log.error("Unhandled exception on getGroups", ex);
            return Collections.emptyList();
        }
    }
}

