/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.pi.model.PiPipelineInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class P4RuntimeDriverUtils {
    private static final String DEVICE_ID_PARAM = "device_id=";
    private static final Logger log = LoggerFactory.getLogger(P4RuntimeDriverUtils.class);

    private P4RuntimeDriverUtils() {
    }

    static PiPipelineInterpreter getInterpreter(DriverHandler handler) {
        DeviceId deviceId = handler.data().deviceId();
        Device device = ((DeviceService)handler.get(DeviceService.class)).getDevice(deviceId);
        if (device == null) {
            log.warn("Unable to find device {}, cannot get interpreter", (Object)deviceId);
            return null;
        }
        if (!device.is(PiPipelineInterpreter.class)) {
            log.warn("Unable to get interpreter for {}, missing behaviour", (Object)deviceId);
            return null;
        }
        return (PiPipelineInterpreter)device.as(PiPipelineInterpreter.class);
    }

    static Long extractP4DeviceId(URI uri) {
        if (uri == null) {
            return null;
        }
        String[] segments = uri.getRawQuery().split("&");
        try {
            for (String s : segments) {
                if (!s.startsWith(DEVICE_ID_PARAM)) continue;
                return Long.parseUnsignedLong(URLDecoder.decode(s.substring(DEVICE_ID_PARAM.length()), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode P4Runtime-internal device_id from URI {}: {}", (Object)uri, (Object)e.toString());
        }
        catch (NumberFormatException e) {
            log.error("Invalid P4Runtime-internal device_id in URI {}: {}", (Object)uri, (Object)e.toString());
        }
        log.error("Missing P4Runtime-internal device_id in URI {}", (Object)uri);
        return null;
    }
}

